/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path.fa;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.fa.FAFactory;
import org.apache.iotdb.commons.path.fa.IFAState;
import org.apache.iotdb.commons.path.fa.IFATransition;

public interface IPatternFA {
    public Map<String, IFATransition> getPreciseMatchTransition(IFAState var1);

    public Iterator<IFATransition> getPreciseMatchTransitionIterator(IFAState var1);

    public Iterator<IFATransition> getFuzzyMatchTransitionIterator(IFAState var1);

    public int getFuzzyMatchTransitionSize(IFAState var1);

    public IFAState getNextState(IFAState var1, IFATransition var2);

    public IFAState getInitialState();

    public int getStateSize();

    public IFAState getState(int var1);

    public boolean mayTransitionOverlap();

    public static final class Builder {
        private PartialPath pathPattern;
        private PathPatternTree patternTree;
        private boolean isPrefixMatch = false;

        public Builder pattern(PartialPath pattern) {
            this.pathPattern = pattern;
            return this;
        }

        public Builder patternTree(PathPatternTree patternTree) {
            this.patternTree = patternTree;
            return this;
        }

        public Builder isPrefixMatch(boolean isPrefixMatch) {
            this.isPrefixMatch = isPrefixMatch;
            return this;
        }

        public PartialPath getPathPattern() {
            return this.pathPattern;
        }

        public PathPatternTree getPatternTree() {
            return this.patternTree;
        }

        public boolean isPrefixMatch() {
            return this.isPrefixMatch;
        }

        public IPatternFA buildNFA() {
            return FAFactory.getInstance().constructNFA(this);
        }

        public IPatternFA buildDFA() {
            return FAFactory.getInstance().constructDFA(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.isPrefixMatch == builder.isPrefixMatch && Objects.equals(this.pathPattern, builder.pathPattern) && Objects.equals(this.patternTree, builder.patternTree);
        }

        public int hashCode() {
            return Objects.hash(this.pathPattern, this.patternTree, this.isPrefixMatch);
        }
    }
}

