/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.view.ViewType;

public class ViewTypeFilter
extends SchemaFilter {
    private final ViewType viewType;

    public ViewTypeFilter(ViewType viewType) {
        this.viewType = viewType;
    }

    public ViewTypeFilter(ByteBuffer byteBuffer) {
        this.viewType = ViewType.deserializeFrom(byteBuffer);
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public <C> boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitViewTypeFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.VIEW_TYPE;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.viewType.serializeTo(byteBuffer);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        this.viewType.serializeTo(stream);
    }
}

