/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import com.google.common.net.InetAddresses;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.iotdb.db.audit.AuditLogOperation;
import org.apache.iotdb.db.audit.AuditLogStorage;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.constant.CompactionPriority;
import org.apache.iotdb.db.engine.compaction.cross.CrossCompactionStrategy;
import org.apache.iotdb.db.engine.compaction.inner.InnerCompactionStrategy;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.external.api.IPropertiesLoader;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBDescriptor.class);
    private final IoTDBConfig conf = new IoTDBConfig();

    protected IoTDBDescriptor() {
        this.loadProps();
        ServiceLoader<IPropertiesLoader> propertiesLoaderServiceLoader = ServiceLoader.load(IPropertiesLoader.class);
        for (IPropertiesLoader loader : propertiesLoaderServiceLoader) {
            logger.info("Will reload properties from {} ", (Object)loader.getClass().getName());
            try {
                Properties properties = loader.loadProperties();
                this.loadProperties(properties);
                this.conf.setCustomizedProperties(loader.getCustomizedProperties());
                TSFileDescriptor.getInstance().overwriteConfigByCustomSettings(properties);
                TSFileDescriptor.getInstance().getConfig().setCustomizedProperties(loader.getCustomizedProperties());
            }
            catch (UnknownHostException e) {
                logger.warn("load property from {} failed.", (Object)loader.getClass().getName(), (Object)e);
            }
        }
    }

    public static IoTDBDescriptor getInstance() {
        return IoTDBDescriptorHolder.INSTANCE;
    }

    public IoTDBConfig getConfig() {
        return this.conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getPropsUrl() {
        String urlString;
        block8: {
            urlString = System.getProperty("IOTDB_CONF", null);
            if (urlString == null) {
                urlString = System.getProperty("IOTDB_HOME", null);
                if (urlString != null) {
                    urlString = urlString + File.separatorChar + "conf" + File.separatorChar + "iotdb-engine.properties";
                    break block8;
                } else {
                    URL uri = IoTDBConfig.class.getResource("/iotdb-engine.properties");
                    if (uri != null) {
                        return uri;
                    }
                    logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-engine.properties");
                    this.conf.updatePath();
                    return null;
                }
            }
            if (!urlString.endsWith(".properties")) {
                urlString = urlString + File.separatorChar + "iotdb-engine.properties";
            }
        }
        if (!urlString.startsWith("file:") && !urlString.startsWith("classpath:")) {
            urlString = "file:" + urlString;
        }
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProps() {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            logger.info("Start to read config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadProperties(properties);
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find config file {}", (Object)url, (Object)e);
        }
        catch (IOException e) {
            logger.warn("Cannot load config file, use default configuration", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Incorrect format in config file, use default configuration", (Throwable)e);
        }
        finally {
            this.conf.updatePath();
            MetricConfigDescriptor.getInstance().getMetricConfig().updateRpcInstance(this.conf.getRpcAddress(), this.conf.getRpcPort());
        }
    }

    public void loadProperties(Properties properties) throws UnknownHostException {
        long memTableSizeThreshold;
        long unSeqTsFileSize;
        long forceMlogPeriodInMs;
        this.conf.setRpcAddress(properties.getProperty("rpc_address", this.conf.getRpcAddress()));
        this.replaceHostnameWithIP();
        this.conf.setRpcThriftCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_thrift_compression_enable", Boolean.toString(this.conf.isRpcThriftCompressionEnable()))));
        this.conf.setRpcAdvancedCompressionEnable(Boolean.parseBoolean(properties.getProperty("rpc_advanced_compression_enable", Boolean.toString(this.conf.isRpcAdvancedCompressionEnable()))));
        this.conf.setRpcPort(Integer.parseInt(properties.getProperty("rpc_port", Integer.toString(this.conf.getRpcPort()))));
        this.conf.setEnableInfluxDBRpcService(Boolean.parseBoolean(properties.getProperty("enable_influxdb_rpc_service", Boolean.toString(this.conf.isEnableInfluxDBRpcService()))));
        this.conf.setInfluxDBRpcPort(Integer.parseInt(properties.getProperty("influxdb_rpc_port", Integer.toString(this.conf.getInfluxDBRpcPort()))));
        this.conf.setTimestampPrecision(properties.getProperty("timestamp_precision", this.conf.getTimestampPrecision()));
        this.conf.setBufferedArraysMemoryProportion(Double.parseDouble(properties.getProperty("buffered_arrays_memory_proportion", Double.toString(this.conf.getBufferedArraysMemoryProportion()))));
        this.conf.setTimeIndexMemoryProportion(Double.parseDouble(properties.getProperty("time_index_memory_proportion", Double.toString(this.conf.getTimeIndexMemoryProportion()))));
        this.conf.setFlushProportion(Double.parseDouble(properties.getProperty("flush_proportion", Double.toString(this.conf.getFlushProportion()))));
        this.conf.setRejectProportion(Double.parseDouble(properties.getProperty("reject_proportion", Double.toString(this.conf.getRejectProportion()))));
        this.conf.setStorageGroupSizeReportThreshold(Long.parseLong(properties.getProperty("storage_group_report_threshold", Long.toString(this.conf.getStorageGroupSizeReportThreshold()))));
        this.conf.setMetaDataCacheEnable(Boolean.parseBoolean(properties.getProperty("meta_data_cache_enable", Boolean.toString(this.conf.isMetaDataCacheEnable()))));
        this.conf.setEnableLastCache(Boolean.parseBoolean(properties.getProperty("enable_last_cache", Boolean.toString(this.conf.isLastCacheEnabled()))));
        this.initMemoryAllocate(properties);
        this.loadWALProps(properties);
        String systemDir = properties.getProperty("system_dir");
        if (systemDir == null) {
            systemDir = properties.getProperty("base_dir");
            systemDir = systemDir != null ? FilePathUtils.regularizePath((String)systemDir) + "system" : this.conf.getSystemDir();
        }
        this.conf.setSystemDir(systemDir);
        this.conf.setSchemaDir(FilePathUtils.regularizePath((String)this.conf.getSystemDir()) + "schema");
        this.conf.setSyncDir(FilePathUtils.regularizePath((String)this.conf.getSystemDir()) + "sync");
        this.conf.setQueryDir(FilePathUtils.regularizePath((String)(this.conf.getSystemDir() + "query")));
        this.conf.setTracingDir(properties.getProperty("tracing_dir", this.conf.getTracingDir()));
        this.conf.setDataDirs(properties.getProperty("data_dirs", this.conf.getDataDirs()[0]).split(","));
        this.conf.setWalDir(properties.getProperty("wal_dir", this.conf.getWalDir()));
        int mlogBufferSize = Integer.parseInt(properties.getProperty("mlog_buffer_size", Integer.toString(this.conf.getMlogBufferSize())));
        if (mlogBufferSize > 0) {
            this.conf.setMlogBufferSize(mlogBufferSize);
        }
        if ((forceMlogPeriodInMs = Long.parseLong(properties.getProperty("sync_mlog_period_in_ms", Long.toString(this.conf.getSyncMlogPeriodInMs())))) > 0L) {
            this.conf.setSyncMlogPeriodInMs(forceMlogPeriodInMs);
        }
        this.conf.setMultiDirStrategyClassName(properties.getProperty("multi_dir_strategy", this.conf.getMultiDirStrategyClassName()));
        this.conf.setBatchSize(Integer.parseInt(properties.getProperty("batch_size", Integer.toString(this.conf.getBatchSize()))));
        this.conf.setEnableMemControl(Boolean.parseBoolean(properties.getProperty("enable_mem_control", Boolean.toString(this.conf.isEnableMemControl()))));
        logger.info("IoTDB enable memory control: {}", (Object)this.conf.isEnableMemControl());
        long seqTsFileSize = Long.parseLong(properties.getProperty("seq_tsfile_size", Long.toString(this.conf.getSeqTsFileSize())).trim());
        if (seqTsFileSize >= 0L) {
            this.conf.setSeqTsFileSize(seqTsFileSize);
        }
        if ((unSeqTsFileSize = Long.parseLong(properties.getProperty("unseq_tsfile_size", Long.toString(this.conf.getUnSeqTsFileSize())).trim())) >= 0L) {
            this.conf.setUnSeqTsFileSize(unSeqTsFileSize);
        }
        if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
            this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
        }
        this.conf.setAvgSeriesPointNumberThreshold(Integer.parseInt(properties.getProperty("avg_series_point_number_threshold", Integer.toString(this.conf.getAvgSeriesPointNumberThreshold()))));
        this.conf.setCheckPeriodWhenInsertBlocked(Integer.parseInt(properties.getProperty("check_period_when_insert_blocked", Integer.toString(this.conf.getCheckPeriodWhenInsertBlocked()))));
        this.conf.setMaxWaitingTimeWhenInsertBlocked(Integer.parseInt(properties.getProperty("max_waiting_time_when_insert_blocked", Integer.toString(this.conf.getMaxWaitingTimeWhenInsertBlocked()))));
        this.conf.setChunkMetadataMemorySizeProportion(Double.parseDouble(properties.getProperty("chunk_metadata_memory_size_proportion", Double.toString(this.conf.getChunkMetadataMemorySizeProportion()))));
        this.conf.setEstimatedSeriesSize(Integer.parseInt(properties.getProperty("estimated_series_size", Integer.toString(this.conf.getEstimatedSeriesSize()))));
        this.conf.setIoTaskQueueSizeForFlushing(Integer.parseInt(properties.getProperty("io_task_queue_size_for_flushing", Integer.toString(this.conf.getIoTaskQueueSizeForFlushing()))));
        this.conf.setCompactionScheduleIntervalInMs(Long.parseLong(properties.getProperty("compaction_schedule_interval_in_ms", Long.toString(this.conf.getCompactionScheduleIntervalInMs()))));
        this.conf.setCompactionSubmissionIntervalInMs(Long.parseLong(properties.getProperty("compaction_submission_interval_in_ms", Long.toString(this.conf.getCompactionSubmissionIntervalInMs()))));
        this.conf.setEnableCrossSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_cross_space_compaction", Boolean.toString(this.conf.isEnableCrossSpaceCompaction()))));
        this.conf.setEnableSeqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_seq_space_compaction", Boolean.toString(this.conf.isEnableSeqSpaceCompaction()))));
        this.conf.setEnableUnseqSpaceCompaction(Boolean.parseBoolean(properties.getProperty("enable_unseq_space_compaction", Boolean.toString(this.conf.isEnableUnseqSpaceCompaction()))));
        this.conf.setCrossCompactionStrategy(CrossCompactionStrategy.getCrossCompactionStrategy(properties.getProperty("cross_compaction_strategy", this.conf.getCrossCompactionStrategy().toString())));
        this.conf.setInnerCompactionStrategy(InnerCompactionStrategy.getInnerCompactionStrategy(properties.getProperty("inner_compaction_strategy", this.conf.getInnerCompactionStrategy().toString())));
        this.conf.setCompactionPriority(CompactionPriority.valueOf(properties.getProperty("compaction_priority", this.conf.getCompactionPriority().toString())));
        int subtaskNum = Integer.parseInt(properties.getProperty("sub_compaction_thread_num", Integer.toString(this.conf.getSubCompactionTaskNum())));
        subtaskNum = subtaskNum <= 0 ? 1 : subtaskNum;
        this.conf.setSubCompactionTaskNum(subtaskNum);
        this.conf.setQueryTimeoutThreshold(Integer.parseInt(properties.getProperty("query_timeout_threshold", Integer.toString(this.conf.getQueryTimeoutThreshold()))));
        this.conf.setSessionTimeoutThreshold(Integer.parseInt(properties.getProperty("session_timeout_threshold", Integer.toString(this.conf.getSessionTimeoutThreshold()))));
        this.conf.setSyncEnable(Boolean.parseBoolean(properties.getProperty("is_sync_enable", Boolean.toString(this.conf.isSyncEnable()))));
        this.conf.setSyncServerPort(Integer.parseInt(properties.getProperty("sync_server_port", Integer.toString(this.conf.getSyncServerPort())).trim()));
        this.conf.setIpWhiteList(properties.getProperty("ip_white_list", this.conf.getIpWhiteList()));
        this.conf.setConcurrentFlushThread(Integer.parseInt(properties.getProperty("concurrent_flush_thread", Integer.toString(this.conf.getConcurrentFlushThread()))));
        if (this.conf.getConcurrentFlushThread() <= 0) {
            this.conf.setConcurrentFlushThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setIndexRootFolder(properties.getProperty("index_root_dir", this.conf.getIndexRootFolder()));
        this.conf.setEnableIndex(Boolean.parseBoolean(properties.getProperty("enable_index", Boolean.toString(this.conf.isEnableIndex()))));
        this.conf.setConcurrentIndexBuildThread(Integer.parseInt(properties.getProperty("concurrent_index_build_thread", Integer.toString(this.conf.getConcurrentIndexBuildThread()))));
        if (this.conf.getConcurrentIndexBuildThread() <= 0) {
            this.conf.setConcurrentIndexBuildThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setDefaultIndexWindowRange(Integer.parseInt(properties.getProperty("default_index_window_range", Integer.toString(this.conf.getDefaultIndexWindowRange()))));
        this.conf.setIndexBufferSize(Long.parseLong(properties.getProperty("index_buffer_size", Long.toString(this.conf.getIndexBufferSize()))));
        this.conf.setConcurrentQueryThread(Integer.parseInt(properties.getProperty("concurrent_query_thread", Integer.toString(this.conf.getConcurrentQueryThread()))));
        if (this.conf.getConcurrentQueryThread() <= 0) {
            this.conf.setConcurrentQueryThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setConcurrentSubRawQueryThread(Integer.parseInt(properties.getProperty("concurrent_sub_rawQuery_thread", Integer.toString(this.conf.getConcurrentSubRawQueryThread()))));
        if (this.conf.getConcurrentSubRawQueryThread() <= 0) {
            this.conf.setConcurrentSubRawQueryThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setArchivingThreadNum(Integer.parseInt(properties.getProperty("archiving_thread_num", Integer.toString(this.conf.getArchivingThreadNum()))));
        if (this.conf.getArchivingThreadNum() <= 0) {
            this.conf.setArchivingThreadNum(2);
        }
        this.conf.setRawQueryBlockingQueueCapacity(Integer.parseInt(properties.getProperty("raw_query_blocking_queue_capacity", Integer.toString(this.conf.getRawQueryBlockingQueueCapacity()))));
        this.conf.setmManagerCacheSize(Integer.parseInt(properties.getProperty("metadata_node_cache_size", Integer.toString(this.conf.getmManagerCacheSize())).trim()));
        this.conf.setmRemoteSchemaCacheSize(Integer.parseInt(properties.getProperty("remote_schema_cache_size", Integer.toString(this.conf.getmRemoteSchemaCacheSize())).trim()));
        this.conf.setLanguageVersion(properties.getProperty("language_version", this.conf.getLanguageVersion()).trim());
        if (properties.containsKey("chunk_buffer_pool_enable")) {
            this.conf.setChunkBufferPoolEnable(Boolean.parseBoolean(properties.getProperty("chunk_buffer_pool_enable")));
        }
        this.conf.setEnableExternalSort(Boolean.parseBoolean(properties.getProperty("enable_external_sort", Boolean.toString(this.conf.isEnableExternalSort()))));
        this.conf.setExternalSortThreshold(Integer.parseInt(properties.getProperty("external_sort_threshold", Integer.toString(this.conf.getExternalSortThreshold()))));
        this.conf.setUpgradeThreadNum(Integer.parseInt(properties.getProperty("upgrade_thread_num", Integer.toString(this.conf.getUpgradeThreadNum()))));
        this.conf.setCrossCompactionFileSelectionTimeBudget(Long.parseLong(properties.getProperty("cross_compaction_file_selection_time_budget", Long.toString(this.conf.getCrossCompactionFileSelectionTimeBudget()))));
        this.conf.setMergeIntervalSec(Long.parseLong(properties.getProperty("merge_interval_sec", Long.toString(this.conf.getMergeIntervalSec()))));
        this.conf.setConcurrentCompactionThread(Integer.parseInt(properties.getProperty("concurrent_compaction_thread", Integer.toString(this.conf.getConcurrentCompactionThread()))));
        this.conf.setTargetCompactionFileSize(Long.parseLong(properties.getProperty("target_compaction_file_size", Long.toString(this.conf.getTargetCompactionFileSize()))));
        this.conf.setTargetChunkSize(Long.parseLong(properties.getProperty("target_chunk_size", Long.toString(this.conf.getTargetChunkSize()))));
        this.conf.setTargetChunkPointNum(Long.parseLong(properties.getProperty("target_chunk_point_num", Long.toString(this.conf.getTargetChunkPointNum()))));
        this.conf.setChunkPointNumLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_point_num_lower_bound_in_compaction", Long.toString(this.conf.getChunkPointNumLowerBoundInCompaction()))));
        this.conf.setChunkSizeLowerBoundInCompaction(Long.parseLong(properties.getProperty("chunk_size_lower_bound_in_compaction", Long.toString(this.conf.getChunkSizeLowerBoundInCompaction()))));
        this.conf.setMaxInnerCompactionCandidateFileNum(Integer.parseInt(properties.getProperty("max_inner_compaction_candidate_file_num", Integer.toString(this.conf.getMaxInnerCompactionCandidateFileNum()))));
        this.conf.setMaxCrossCompactionCandidateFileNum(Integer.parseInt(properties.getProperty("max_cross_compaction_candidate_file_num", Integer.toString(this.conf.getMaxCrossCompactionCandidateFileNum()))));
        this.conf.setMaxCrossCompactionCandidateFileSize(Long.parseLong(properties.getProperty("max_cross_compaction_candidate_file_size", Long.toString(this.conf.getMaxCrossCompactionCandidateFileSize()))));
        this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("compaction_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
        this.conf.setEnablePartialInsert(Boolean.parseBoolean(properties.getProperty("enable_partial_insert", String.valueOf(this.conf.isEnablePartialInsert()))));
        this.conf.setEnableMTreeSnapshot(Boolean.parseBoolean(properties.getProperty("enable_mtree_snapshot", Boolean.toString(this.conf.isEnableMTreeSnapshot()))));
        this.conf.setMtreeSnapshotInterval(Integer.parseInt(properties.getProperty("mtree_snapshot_interval", Integer.toString(this.conf.getMtreeSnapshotInterval()))));
        this.conf.setMtreeSnapshotThresholdTime(Integer.parseInt(properties.getProperty("mtree_snapshot_threshold_time", Integer.toString(this.conf.getMtreeSnapshotThresholdTime()))));
        int maxConcurrentClientNum = Integer.parseInt(properties.getProperty("rpc_max_concurrent_client_num", Integer.toString(this.conf.getRpcMaxConcurrentClientNum()).trim()));
        if (maxConcurrentClientNum <= 0) {
            maxConcurrentClientNum = 65535;
        }
        this.conf.setEnableWatermark(Boolean.parseBoolean(properties.getProperty("watermark_module_opened", Boolean.toString(this.conf.isEnableWatermark()).trim())));
        this.conf.setWatermarkSecretKey(properties.getProperty("watermark_secret_key", this.conf.getWatermarkSecretKey()));
        this.conf.setWatermarkBitString(properties.getProperty("watermark_bit_string", this.conf.getWatermarkBitString()));
        this.conf.setWatermarkMethod(properties.getProperty("watermark_method", this.conf.getWatermarkMethod()));
        this.loadAutoCreateSchemaProps(properties);
        this.conf.setRpcMaxConcurrentClientNum(maxConcurrentClientNum);
        this.conf.setTsFileStorageFs(properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().toString()));
        this.conf.setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        this.conf.setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        this.conf.setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        this.conf.setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        this.conf.setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        this.conf.setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        this.conf.setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        this.conf.setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        this.conf.setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        this.conf.setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        this.conf.setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        this.conf.setDefaultTTL(Long.parseLong(properties.getProperty("default_ttl", String.valueOf(this.conf.getDefaultTTL()))));
        this.conf.setAllowReadOnlyWhenErrorsOccur(Boolean.parseBoolean(properties.getProperty("allow_read_only_when_errors_occur", String.valueOf(this.conf.isAllowReadOnlyWhenErrorsOccur()))));
        this.conf.setConcurrentWritingTimePartition(Integer.parseInt(properties.getProperty("concurrent_writing_time_partition", String.valueOf(this.conf.getConcurrentWritingTimePartition()))));
        this.conf.setDefaultFillInterval(Integer.parseInt(properties.getProperty("default_fill_interval", String.valueOf(this.conf.getDefaultFillInterval()))));
        this.conf.setTagAttributeTotalSize(Integer.parseInt(properties.getProperty("tag_attribute_total_size", String.valueOf(this.conf.getTagAttributeTotalSize()))));
        this.conf.setTagAttributeFlushInterval(Integer.parseInt(properties.getProperty("tag_attribute_flush_interval", String.valueOf(this.conf.getTagAttributeFlushInterval()))));
        this.conf.setPrimitiveArraySize(Integer.parseInt(properties.getProperty("primitive_array_size", String.valueOf(this.conf.getPrimitiveArraySize()))));
        this.conf.setThriftMaxFrameSize(Integer.parseInt(properties.getProperty("thrift_max_frame_size", String.valueOf(this.conf.getThriftMaxFrameSize()))));
        if (this.conf.getThriftMaxFrameSize() < 0x800000) {
            this.conf.setThriftMaxFrameSize(0x800000);
        }
        this.conf.setThriftDefaultBufferSize(Integer.parseInt(properties.getProperty("thrift_init_buffer_size", String.valueOf(this.conf.getThriftDefaultBufferSize()))));
        this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute", String.valueOf(this.conf.getFrequencyIntervalInMinute()))));
        this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", String.valueOf(this.conf.getSlowQueryThreshold()))));
        this.conf.setVirtualStorageGroupNum(Integer.parseInt(properties.getProperty("virtual_storage_group_num", String.valueOf(this.conf.getVirtualStorageGroupNum()))));
        this.conf.setRecoveryLogIntervalInMs(Long.parseLong(properties.getProperty("recovery_log_interval_in_ms", String.valueOf(this.conf.getRecoveryLogIntervalInMs()))));
        this.conf.setConcurrentWindowEvaluationThread(Integer.parseInt(properties.getProperty("concurrent_window_evaluation_thread", Integer.toString(this.conf.getConcurrentWindowEvaluationThread()))));
        if (this.conf.getConcurrentWindowEvaluationThread() <= 0) {
            this.conf.setConcurrentWindowEvaluationThread(Runtime.getRuntime().availableProcessors());
        }
        this.conf.setMaxPendingWindowEvaluationTasks(Integer.parseInt(properties.getProperty("max_pending_window_evaluation_tasks", Integer.toString(this.conf.getMaxPendingWindowEvaluationTasks()))));
        if (this.conf.getMaxPendingWindowEvaluationTasks() <= 0) {
            this.conf.setMaxPendingWindowEvaluationTasks(64);
        }
        if (properties.getProperty("mqtt_host") != null) {
            this.conf.setMqttHost(properties.getProperty("mqtt_host"));
        }
        if (properties.getProperty("mqtt_port") != null) {
            this.conf.setMqttPort(Integer.parseInt(properties.getProperty("mqtt_port")));
        }
        if (properties.getProperty("mqtt_handler_pool_size") != null) {
            this.conf.setMqttHandlerPoolSize(Integer.parseInt(properties.getProperty("mqtt_handler_pool_size")));
        }
        if (properties.getProperty("mqtt_payload_formatter") != null) {
            this.conf.setMqttPayloadFormatter(properties.getProperty("mqtt_payload_formatter"));
        }
        if (properties.getProperty("enable_mqtt_service") != null) {
            this.conf.setEnableMQTTService(Boolean.parseBoolean(properties.getProperty("enable_mqtt_service")));
        }
        if (properties.getProperty("mqtt_max_message_size") != null) {
            this.conf.setMqttMaxMessageSize(Integer.parseInt(properties.getProperty("mqtt_max_message_size")));
        }
        this.conf.setAuthorizerProvider(properties.getProperty("authorizer_provider_class", this.conf.getAuthorizerProvider()));
        this.conf.setOpenIdProviderUrl(properties.getProperty("openID_url", this.conf.getOpenIdProviderUrl()));
        this.conf.setEnablePartition(Boolean.parseBoolean(properties.getProperty("enable_partition", String.valueOf(this.conf.isEnablePartition()))));
        this.conf.setPartitionInterval(Long.parseLong(properties.getProperty("partition_interval", String.valueOf(this.conf.getPartitionInterval()))));
        this.conf.setAdminName(properties.getProperty("admin_name", this.conf.getAdminName()));
        this.conf.setAdminPassword(properties.getProperty("admin_password", this.conf.getAdminPassword()));
        this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
        this.conf.setInsertMultiTabletEnableMultithreadingColumnThreshold(Integer.parseInt(properties.getProperty("insert_multi_tablet_enable_multithreading_column_threshold", String.valueOf(this.conf.getInsertMultiTabletEnableMultithreadingColumnThreshold()))));
        this.conf.setEncryptDecryptProvider(properties.getProperty("iotdb_server_encrypt_decrypt_provider", this.conf.getEncryptDecryptProvider()));
        this.conf.setEncryptDecryptProviderParameter(properties.getProperty("iotdb_server_encrypt_decrypt_provider_parameter", this.conf.getEncryptDecryptProviderParameter()));
        this.conf.setEnableOperationSync(Boolean.parseBoolean(properties.getProperty("enable_operation_sync", String.valueOf(this.conf.isEnableOperationSync()))));
        this.conf.setSecondaryAddress(properties.getProperty("secondary_address", this.conf.getSecondaryAddress()));
        this.conf.setSecondaryPort(Integer.parseInt(properties.getProperty("secondary_port", String.valueOf(this.conf.getSecondaryPort()))));
        this.conf.setSecondaryUser(properties.getProperty("secondary_user", this.conf.getSecondaryUser()));
        this.conf.setSecondaryPassword(properties.getProperty("secondary_password", this.conf.getSecondaryPassword()));
        this.conf.setOperationSyncSessionConcurrencySize(Integer.parseInt(properties.getProperty("operation_sync_session_concurrency_size", String.valueOf(this.conf.getOperationSyncSessionConcurrencySize()))));
        this.conf.setOperationSyncLogDir(properties.getProperty("operation_sync_log_dir", this.conf.getOperationSyncLogDir()));
        this.conf.setOperationSyncLogValidity(Integer.parseInt(properties.getProperty("operation_sync_log_file_validity", String.valueOf(this.conf.getOperationSyncLogValidity()))));
        this.conf.setOperationSyncLogNum(Integer.parseInt(properties.getProperty("operation_sync_log_file_num", String.valueOf(this.conf.getOperationSyncLogNum()))));
        this.conf.setOperationSyncMaxLogSize(Long.parseLong(properties.getProperty("operation_sync_max_log_size", String.valueOf(this.conf.getOperationSyncMaxLogSize()))));
        this.conf.setOperationSyncProducerCacheSize(Integer.parseInt(properties.getProperty("operation_sync_producer_cache_size", String.valueOf(this.conf.getOperationSyncProducerCacheSize()))));
        this.conf.setOperationSyncProducerCacheNum(Integer.parseInt(properties.getProperty("operation_sync_producer_cache_num", String.valueOf(this.conf.getOperationSyncProducerCacheNum()))));
        this.conf.setSchemaQueryFetchSize(Integer.parseInt(properties.getProperty("schema_query_fetch_size", String.valueOf(this.conf.getSchemaQueryFetchSize()))));
        this.conf.setEnableAuditLog(Boolean.parseBoolean(properties.getProperty("enable_audit_log", String.valueOf(this.conf.isEnableAuditLog()))));
        if (properties.getProperty("audit_log_storage") != null) {
            this.conf.setAuditLogStorage(Arrays.stream(properties.getProperty("audit_log_storage").split(",")).map(AuditLogStorage::valueOf).collect(Collectors.toList()));
        }
        if (properties.getProperty("audit_log_operation") != null) {
            this.conf.setAuditLogOperation(Arrays.stream(properties.getProperty("audit_log_operation").split(",")).map(AuditLogOperation::valueOf).collect(Collectors.toList()));
        }
        this.conf.setEnableAuditLogForNativeInsertApi(Boolean.parseBoolean(properties.getProperty("enable_audit_log_for_native_insert_api", String.valueOf(this.conf.isEnableAuditLogForNativeInsertApi()))));
        TSFileDescriptor.getInstance().getConfig().setTSFileStorageFs(FSType.valueOf((String)properties.getProperty("tsfile_storage_fs", this.conf.getTsFileStorageFs().name())));
        TSFileDescriptor.getInstance().getConfig().setCoreSitePath(properties.getProperty("core_site_path", this.conf.getCoreSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsSitePath(properties.getProperty("hdfs_site_path", this.conf.getHdfsSitePath()));
        TSFileDescriptor.getInstance().getConfig().setHdfsIp(properties.getProperty("hdfs_ip", this.conf.getRawHDFSIp()).split(","));
        TSFileDescriptor.getInstance().getConfig().setHdfsPort(properties.getProperty("hdfs_port", this.conf.getHdfsPort()));
        TSFileDescriptor.getInstance().getConfig().setDfsNameServices(properties.getProperty("dfs_nameservices", this.conf.getDfsNameServices()));
        TSFileDescriptor.getInstance().getConfig().setDfsHaNamenodes(properties.getProperty("dfs_ha_namenodes", this.conf.getRawDfsHaNamenodes()).split(","));
        TSFileDescriptor.getInstance().getConfig().setDfsHaAutomaticFailoverEnabled(Boolean.parseBoolean(properties.getProperty("dfs_ha_automatic_failover_enabled", String.valueOf(this.conf.isDfsHaAutomaticFailoverEnabled()))));
        TSFileDescriptor.getInstance().getConfig().setDfsClientFailoverProxyProvider(properties.getProperty("dfs_client_failover_proxy_provider", this.conf.getDfsClientFailoverProxyProvider()));
        TSFileDescriptor.getInstance().getConfig().setPatternMatchingThreshold(Integer.parseInt(properties.getProperty("pattern_matching_threshold", String.valueOf(this.conf.getPatternMatchingThreshold()))));
        TSFileDescriptor.getInstance().getConfig().setUseKerberos(Boolean.parseBoolean(properties.getProperty("hdfs_use_kerberos", String.valueOf(this.conf.isUseKerberos()))));
        TSFileDescriptor.getInstance().getConfig().setKerberosKeytabFilePath(properties.getProperty("kerberos_keytab_file_path", this.conf.getKerberosKeytabFilePath()));
        TSFileDescriptor.getInstance().getConfig().setKerberosPrincipal(properties.getProperty("kerberos_principal", this.conf.getKerberosPrincipal()));
        TSFileDescriptor.getInstance().getConfig().setBatchSize(this.conf.getBatchSize());
        this.loadTimedService(properties);
        this.loadTsFileProps(properties);
        RpcTransportFactory.reInit();
        this.loadUDFProps(properties);
        this.loadTriggerProps(properties);
        this.loadCQProps(properties);
    }

    private void replaceHostnameWithIP() throws UnknownHostException {
        boolean isInvalidRpcIp = InetAddresses.isInetAddress((String)this.conf.getRpcAddress());
        if (!isInvalidRpcIp) {
            InetAddress address = InetAddress.getByName(this.getConfig().getRpcAddress());
            this.getConfig().setRpcAddress(address.getHostAddress());
        }
        logger.debug("after replace, the rpc_address={},", (Object)this.conf.getRpcAddress());
    }

    private void loadWALProps(Properties properties) {
        long registerBufferRejectThresholdInMs;
        long registerBufferSleepIntervalInMs;
        long poolTrimIntervalInMS;
        int maxWalBytebufferNumForEachPartition;
        this.conf.setEnableWal(Boolean.parseBoolean(properties.getProperty("enable_wal", Boolean.toString(this.conf.isEnableWal()))));
        this.conf.setFlushWalThreshold(Integer.parseInt(properties.getProperty("flush_wal_threshold", Integer.toString(this.conf.getFlushWalThreshold()))));
        this.conf.setForceWalPeriodInMs(Long.parseLong(properties.getProperty("force_wal_period_in_ms", Long.toString(this.conf.getForceWalPeriodInMs()))));
        this.conf.setEnableDiscardOutOfOrderData(Boolean.parseBoolean(properties.getProperty("enable_discard_out_of_order_data", Boolean.toString(this.conf.isEnableDiscardOutOfOrderData()))));
        int walBufferSize = Integer.parseInt(properties.getProperty("wal_buffer_size", Integer.toString(this.conf.getWalBufferSize())));
        if (walBufferSize > 0) {
            this.conf.setWalBufferSize(walBufferSize);
        }
        if ((maxWalBytebufferNumForEachPartition = Integer.parseInt(properties.getProperty("max_wal_bytebuffer_num_for_each_partition", Integer.toString(this.conf.getMaxWalBytebufferNumForEachPartition())))) > 0) {
            this.conf.setMaxWalBytebufferNumForEachPartition(maxWalBytebufferNumForEachPartition);
        }
        if ((poolTrimIntervalInMS = Long.parseLong(properties.getProperty("wal_pool_trim_interval_ms", Long.toString(this.conf.getWalPoolTrimIntervalInMS())))) > 0L) {
            this.conf.setWalPoolTrimIntervalInMS(poolTrimIntervalInMS);
        }
        if ((registerBufferSleepIntervalInMs = Long.parseLong(properties.getProperty("register_buffer_sleep_interval_in_ms", Long.toString(this.conf.getRegisterBufferSleepIntervalInMs())))) > 0L) {
            this.conf.setRegisterBufferSleepIntervalInMs(registerBufferSleepIntervalInMs);
        }
        if ((registerBufferRejectThresholdInMs = Long.parseLong(properties.getProperty("register_buffer_reject_threshold_in_ms", Long.toString(this.conf.getRegisterBufferRejectThresholdInMs())))) > 0L) {
            this.conf.setRegisterBufferRejectThresholdInMs(registerBufferRejectThresholdInMs);
        }
    }

    private void loadAutoCreateSchemaProps(Properties properties) {
        this.conf.setAutoCreateSchemaEnabled(Boolean.parseBoolean(properties.getProperty("enable_auto_create_schema", Boolean.toString(this.conf.isAutoCreateSchemaEnabled()).trim())));
        this.conf.setBooleanStringInferType(TSDataType.valueOf((String)properties.getProperty("boolean_string_infer_type", this.conf.getBooleanStringInferType().toString())));
        this.conf.setIntegerStringInferType(TSDataType.valueOf((String)properties.getProperty("integer_string_infer_type", this.conf.getIntegerStringInferType().toString())));
        this.conf.setLongStringInferType(TSDataType.valueOf((String)properties.getProperty("long_string_infer_type", this.conf.getLongStringInferType().toString())));
        this.conf.setFloatingStringInferType(TSDataType.valueOf((String)properties.getProperty("floating_string_infer_type", this.conf.getFloatingStringInferType().toString())));
        this.conf.setNanStringInferType(TSDataType.valueOf((String)properties.getProperty("nan_string_infer_type", this.conf.getNanStringInferType().toString())));
        this.conf.setDefaultStorageGroupLevel(Integer.parseInt(properties.getProperty("default_storage_group_level", Integer.toString(this.conf.getDefaultStorageGroupLevel()))));
        this.conf.setDefaultBooleanEncoding(properties.getProperty("default_boolean_encoding", this.conf.getDefaultBooleanEncoding().toString()));
        this.conf.setDefaultInt32Encoding(properties.getProperty("default_int32_encoding", this.conf.getDefaultInt32Encoding().toString()));
        this.conf.setDefaultInt64Encoding(properties.getProperty("default_int64_encoding", this.conf.getDefaultInt64Encoding().toString()));
        this.conf.setDefaultFloatEncoding(properties.getProperty("default_float_encoding", this.conf.getDefaultFloatEncoding().toString()));
        this.conf.setDefaultDoubleEncoding(properties.getProperty("default_double_encoding", this.conf.getDefaultDoubleEncoding().toString()));
        this.conf.setDefaultTextEncoding(properties.getProperty("default_text_encoding", this.conf.getDefaultTextEncoding().toString()));
    }

    private void loadTsFileProps(Properties properties) {
        TSFileDescriptor.getInstance().getConfig().setGroupSizeInByte(Integer.parseInt(properties.getProperty("group_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()))));
        TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(Integer.parseInt(properties.getProperty("page_size_in_byte", Integer.toString(TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()))));
        if (TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() > TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte()) {
            logger.warn("page_size is greater than group size, will set it as the same with group size");
            TSFileDescriptor.getInstance().getConfig().setPageSizeInByte(TSFileDescriptor.getInstance().getConfig().getGroupSizeInByte());
        }
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(Integer.parseInt(properties.getProperty("max_number_of_points_in_page", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage()))));
        TSFileDescriptor.getInstance().getConfig().setMaxStringLength(Integer.parseInt(properties.getProperty("max_string_length", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxStringLength()))));
        TSFileDescriptor.getInstance().getConfig().setBloomFilterErrorRate(Double.parseDouble(properties.getProperty("bloom_filter_error_rate", Double.toString(TSFileDescriptor.getInstance().getConfig().getBloomFilterErrorRate()))));
        TSFileDescriptor.getInstance().getConfig().setFloatPrecision(Integer.parseInt(properties.getProperty("float_precision", Integer.toString(TSFileDescriptor.getInstance().getConfig().getFloatPrecision()))));
        TSFileDescriptor.getInstance().getConfig().setTimeEncoder(properties.getProperty("time_encoder", TSFileDescriptor.getInstance().getConfig().getTimeEncoder()));
        TSFileDescriptor.getInstance().getConfig().setValueEncoder(properties.getProperty("value_encoder", TSFileDescriptor.getInstance().getConfig().getValueEncoder()));
        TSFileDescriptor.getInstance().getConfig().setCompressor(properties.getProperty("compressor", TSFileDescriptor.getInstance().getConfig().getCompressor().toString()));
        TSFileDescriptor.getInstance().getConfig().setMaxDegreeOfIndexNode(Integer.parseInt(properties.getProperty("max_degree_of_index_node", Integer.toString(TSFileDescriptor.getInstance().getConfig().getMaxDegreeOfIndexNode()))));
    }

    private void loadTimedService(Properties properties) {
        long closeTsFileCheckInterval;
        long unseqMemTableFlushCheckInterval;
        long seqMemTableFlushCheckInterval;
        this.conf.setEnableTimedFlushSeqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_seq_memtable", Boolean.toString(this.conf.isEnableTimedFlushSeqMemtable()))));
        long seqMemTableFlushInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushInterval())).trim());
        if (seqMemTableFlushInterval > 0L) {
            this.conf.setSeqMemtableFlushInterval(seqMemTableFlushInterval);
        }
        if ((seqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("seq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getSeqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setSeqMemtableFlushCheckInterval(seqMemTableFlushCheckInterval);
        }
        this.conf.setEnableTimedFlushUnseqMemtable(Boolean.parseBoolean(properties.getProperty("enable_timed_flush_unseq_memtable", Boolean.toString(this.conf.isEnableTimedFlushUnseqMemtable()))));
        long unseqMemTableFlushInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushInterval())).trim());
        if (unseqMemTableFlushInterval > 0L) {
            this.conf.setUnseqMemtableFlushInterval(unseqMemTableFlushInterval);
        }
        if ((unseqMemTableFlushCheckInterval = Long.parseLong(properties.getProperty("unseq_memtable_flush_check_interval_in_ms", Long.toString(this.conf.getUnseqMemtableFlushCheckInterval())).trim())) > 0L) {
            this.conf.setUnseqMemtableFlushCheckInterval(unseqMemTableFlushCheckInterval);
        }
        this.conf.setEnableTimedCloseTsFile(Boolean.parseBoolean(properties.getProperty("enable_timed_close_tsfile", Boolean.toString(this.conf.isEnableTimedCloseTsFile()))));
        long closeTsFileIntervalAfterFlushing = Long.parseLong(properties.getProperty("close_tsfile_interval_after_flushing_in_ms", Long.toString(this.conf.getCloseTsFileIntervalAfterFlushing())).trim());
        if (closeTsFileIntervalAfterFlushing > 0L) {
            this.conf.setCloseTsFileIntervalAfterFlushing(closeTsFileIntervalAfterFlushing);
        }
        if ((closeTsFileCheckInterval = Long.parseLong(properties.getProperty("close_tsfile_check_interval_in_ms", Long.toString(this.conf.getCloseTsFileCheckInterval())).trim())) > 0L) {
            this.conf.setCloseTsFileCheckInterval(closeTsFileCheckInterval);
        }
    }

    public void loadHotModifiedProps(Properties properties) throws QueryProcessException {
        try {
            long memTableSizeThreshold;
            long unSeqTsFileSize;
            String multiDirStrategyClassName;
            String dataDirs = properties.getProperty("data_dirs", null);
            if (dataDirs != null) {
                this.conf.reloadDataDirs(dataDirs.split(","));
            }
            if ((multiDirStrategyClassName = properties.getProperty("multi_dir_strategy", null)) != null && !multiDirStrategyClassName.equals(this.conf.getMultiDirStrategyClassName())) {
                this.conf.setMultiDirStrategyClassName(multiDirStrategyClassName);
                DirectoryManager.getInstance().updateDirectoryStrategy();
            }
            this.loadWALProps(properties);
            this.loadTimedService(properties);
            StorageEngine.getInstance().rebootTimedService();
            long seqTsFileSize = Long.parseLong(properties.getProperty("seq_tsfile_size", Long.toString(this.conf.getSeqTsFileSize())).trim());
            if (seqTsFileSize >= 0L) {
                this.conf.setSeqTsFileSize(seqTsFileSize);
            }
            if ((unSeqTsFileSize = Long.parseLong(properties.getProperty("unseq_tsfile_size", Long.toString(this.conf.getUnSeqTsFileSize())).trim())) >= 0L) {
                this.conf.setUnSeqTsFileSize(unSeqTsFileSize);
            }
            if ((memTableSizeThreshold = Long.parseLong(properties.getProperty("memtable_size_threshold", Long.toString(this.conf.getMemtableSizeThreshold())).trim())) > 0L) {
                this.conf.setMemtableSizeThreshold(memTableSizeThreshold);
            }
            this.loadAutoCreateSchemaProps(properties);
            this.loadTsFileProps(properties);
            this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num", Integer.toString(this.conf.getMaxQueryDeduplicatedPathNum()))));
            this.conf.setFrequencyIntervalInMinute(Integer.parseInt(properties.getProperty("frequency_interval_in_minute", Integer.toString(this.conf.getFrequencyIntervalInMinute()))));
            this.conf.setSlowQueryThreshold(Long.parseLong(properties.getProperty("slow_query_threshold", Long.toString(this.conf.getSlowQueryThreshold()))));
            this.conf.setCompactionWriteThroughputMbPerSec(Integer.parseInt(properties.getProperty("merge_write_throughput_mb_per_sec", Integer.toString(this.conf.getCompactionWriteThroughputMbPerSec()))));
            this.conf.setSelectIntoInsertTabletPlanRowLimit(Integer.parseInt(properties.getProperty("select_into_insert_tablet_plan_row_limit", String.valueOf(this.conf.getSelectIntoInsertTabletPlanRowLimit()))));
        }
        catch (Exception e) {
            throw new QueryProcessException(String.format("Fail to reload configuration because %s", e));
        }
    }

    public void loadHotModifiedProps() throws QueryProcessException {
        URL url = this.getPropsUrl();
        if (url == null) {
            logger.warn("Couldn't load the configuration from any of the known sources.");
            return;
        }
        try (InputStream inputStream = url.openStream();){
            logger.info("Start to reload config file {}", (Object)url);
            Properties properties = new Properties();
            properties.load(inputStream);
            this.loadHotModifiedProps(properties);
        }
        catch (Exception e) {
            logger.warn("Fail to reload config file {}", (Object)url, (Object)e);
            throw new QueryProcessException(String.format("Fail to reload config file %s because %s", url, e.getMessage()));
        }
        ReloadLevel reloadLevel = MetricConfigDescriptor.getInstance().loadHotProps();
        MetricService.getInstance().reloadProperties(reloadLevel);
    }

    private void initMemoryAllocate(Properties properties) {
        String memoryAllocateProportion = properties.getProperty("write_read_schema_free_memory_proportion");
        if (memoryAllocateProportion != null) {
            String[] proportions = memoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = Runtime.getRuntime().maxMemory();
            if (proportionSum != 0) {
                this.conf.setAllocateMemoryForStorageEngine(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForRead(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                this.conf.setAllocateMemoryForSchema(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
            }
        }
        logger.info("allocateMemoryForRead = {}", (Object)this.conf.getAllocateMemoryForRead());
        logger.info("allocateMemoryForWrite = {}", (Object)this.conf.getAllocateMemoryForStorageEngine());
        logger.info("allocateMemoryForSchema = {}", (Object)this.conf.getAllocateMemoryForSchema());
        this.conf.setMaxQueryDeduplicatedPathNum(Integer.parseInt(properties.getProperty("max_deduplicated_path_num", Integer.toString(this.conf.getMaxQueryDeduplicatedPathNum()))));
        if (!this.conf.isMetaDataCacheEnable()) {
            return;
        }
        String queryMemoryAllocateProportion = properties.getProperty("chunk_timeseriesmeta_free_memory_proportion");
        if (queryMemoryAllocateProportion != null) {
            String[] proportions = queryMemoryAllocateProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            long maxMemoryAvailable = this.conf.getAllocateMemoryForRead();
            if (proportionSum != 0) {
                try {
                    this.conf.setAllocateMemoryForBloomFilterCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[0].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForChunkCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[1].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForTimeSeriesMetaDataCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[2].trim()) / (long)proportionSum);
                    this.conf.setAllocateMemoryForReadWithoutCache(maxMemoryAvailable * (long)Integer.parseInt(proportions[3].trim()) / (long)proportionSum);
                }
                catch (Exception e) {
                    throw new RuntimeException("Each subsection of configuration item chunkmeta_chunk_timeseriesmeta_free_memory_proportion should be an integer, which is " + queryMemoryAllocateProportion);
                }
            }
        }
        this.initStorageEngineAllocate(properties);
    }

    private void loadUDFProps(Properties properties) {
        String readerTransformerCollectorMemoryProportion;
        String groupByFillCacheSizeInMB;
        String initialByteArrayLengthForMemoryControl = properties.getProperty("udf_initial_byte_array_length_for_memory_control");
        if (initialByteArrayLengthForMemoryControl != null) {
            this.conf.setUdfInitialByteArrayLengthForMemoryControl(Integer.parseInt(initialByteArrayLengthForMemoryControl));
        }
        this.conf.setUdfDir(properties.getProperty("udf_root_dir", this.conf.getUdfDir()));
        String memoryBudgetInMb = properties.getProperty("udf_memory_budget_in_mb");
        if (memoryBudgetInMb != null) {
            this.conf.setUdfMemoryBudgetInMB((float)Math.min((double)Float.parseFloat(memoryBudgetInMb), 0.2 * (double)this.conf.getAllocateMemoryForRead()));
        }
        if ((groupByFillCacheSizeInMB = properties.getProperty("group_by_fill_cache_size_in_mb")) != null) {
            this.conf.setGroupByFillCacheSizeInMB(Float.parseFloat(groupByFillCacheSizeInMB));
        }
        if ((readerTransformerCollectorMemoryProportion = properties.getProperty("udf_reader_transformer_collector_memory_proportion")) != null) {
            String[] proportions = readerTransformerCollectorMemoryProportion.split(":");
            int proportionSum = 0;
            for (String proportion : proportions) {
                proportionSum += Integer.parseInt(proportion.trim());
            }
            float maxMemoryAvailable = this.conf.getUdfMemoryBudgetInMB();
            try {
                this.conf.setUdfReaderMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[0].trim()) / (float)proportionSum);
                this.conf.setUdfTransformerMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[1].trim()) / (float)proportionSum);
                this.conf.setUdfCollectorMemoryBudgetInMB(maxMemoryAvailable * (float)Integer.parseInt(proportions[2].trim()) / (float)proportionSum);
            }
            catch (Exception e) {
                throw new RuntimeException("Each subsection of configuration item udf_reader_transformer_collector_memory_proportion should be an integer, which is " + readerTransformerCollectorMemoryProportion);
            }
        }
    }

    private void loadTriggerProps(Properties properties) {
        this.conf.setTriggerDir(properties.getProperty("trigger_root_dir", this.conf.getTriggerDir()));
        int tlogBufferSize = Integer.parseInt(properties.getProperty("tlog_buffer_size", Integer.toString(this.conf.getTlogBufferSize())));
        if (tlogBufferSize > 0) {
            this.conf.setTlogBufferSize(tlogBufferSize);
        }
    }

    private void loadCQProps(Properties properties) {
        this.conf.setContinuousQueryThreadNum(Integer.parseInt(properties.getProperty("continuous_query_thread_num", Integer.toString(this.conf.getContinuousQueryThreadNum()))));
        if (this.conf.getContinuousQueryThreadNum() <= 0) {
            this.conf.setContinuousQueryThreadNum(Runtime.getRuntime().availableProcessors() / 2);
        }
        this.conf.setMaxPendingContinuousQueryTasks(Integer.parseInt(properties.getProperty("max_pending_continuous_query_tasks", Integer.toString(this.conf.getMaxPendingContinuousQueryTasks()))));
        if (this.conf.getMaxPendingContinuousQueryTasks() <= 0) {
            this.conf.setMaxPendingContinuousQueryTasks(64);
        }
        this.conf.setContinuousQueryMinimumEveryInterval(DateTimeUtils.convertDurationStrToLong(properties.getProperty("continuous_query_minimum_every_interval", "1s"), this.conf.getTimestampPrecision()));
        this.conf.setCqlogBufferSize(Integer.parseInt(properties.getProperty("cqlog_buffer_size", Integer.toString(this.conf.getCqlogBufferSize()))));
    }

    private void initStorageEngineAllocate(Properties properties) {
        String allocationRatio = properties.getProperty("storage_engine_memory_proportion", "8:2");
        String[] proportions = allocationRatio.split(":");
        int proportionForMemTable = Integer.parseInt(proportions[0].trim());
        int proportionForCompaction = Integer.parseInt(proportions[1].trim());
        this.conf.setWriteProportion((double)proportionForMemTable / (double)(proportionForCompaction + proportionForMemTable));
        this.conf.setCompactionProportion((double)proportionForCompaction / (double)(proportionForCompaction + proportionForMemTable));
    }

    public TSEncoding getDefaultEncodingByType(TSDataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return this.conf.getDefaultBooleanEncoding();
            }
            case INT32: {
                return this.conf.getDefaultInt32Encoding();
            }
            case INT64: {
                return this.conf.getDefaultInt64Encoding();
            }
            case FLOAT: {
                return this.conf.getDefaultFloatEncoding();
            }
            case DOUBLE: {
                return this.conf.getDefaultDoubleEncoding();
            }
        }
        return this.conf.getDefaultTextEncoding();
    }

    private static class IoTDBDescriptorHolder {
        private static final IoTDBDescriptor INSTANCE = new IoTDBDescriptor();

        private IoTDBDescriptorHolder() {
        }
    }
}

