/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.delivery;

import com.bugsnag.delivery.HttpDelivery;
import com.bugsnag.delivery.SyncHttpDelivery;
import com.bugsnag.serialization.Serializer;
import java.net.Proxy;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpDelivery
implements HttpDelivery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncHttpDelivery.class);
    private static final int SHUTDOWN_TIMEOUT = 5000;
    private HttpDelivery baseDelivery;
    private final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("bugsnag-async-delivery-" + thread.getId());
            return thread;
        }
    };
    private ExecutorService executorService = new ThreadPoolExecutor(0, 1, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactory);
    private boolean shuttingDown = false;

    public AsyncHttpDelivery() {
        this("https://notify.bugsnag.com");
    }

    public AsyncHttpDelivery(String endpoint) {
        this.baseDelivery = new SyncHttpDelivery(endpoint);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AsyncHttpDelivery.this.shutdown();
            }
        });
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.baseDelivery.setEndpoint(endpoint);
    }

    @Override
    public void setProxy(Proxy proxy) {
        this.baseDelivery.setProxy(proxy);
    }

    @Override
    public void setTimeout(int timeout) {
        this.baseDelivery.setTimeout(timeout);
    }

    public void setBaseDelivery(HttpDelivery baseDelivery) {
        this.baseDelivery = baseDelivery;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void deliver(final Serializer serializer, final Object object, final Map<String, String> headers) {
        if (this.shuttingDown) {
            LOGGER.warn("Not notifying - 'sending' threads are already shutting down");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHttpDelivery.this.baseDelivery.deliver(serializer, object, headers);
            }
        });
    }

    @Override
    public void close() {
        this.shutdown();
    }

    private void shutdown() {
        this.shuttingDown = true;
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Shutdown of 'sending' threads took too long - forcing a shutdown");
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Shutdown of 'sending' threads was interrupted - forcing a shutdown");
            this.executorService.shutdownNow();
        }
    }
}

