/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader.mult;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.cluster.query.reader.mult.IMultBatchReader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;

public class MultBatchReader
implements IMultBatchReader {
    private Map<String, IBatchReader> pathBatchReaders;

    public MultBatchReader(Map<String, IBatchReader> pathBatchReaders) {
        this.pathBatchReaders = pathBatchReaders;
    }

    public boolean hasNextBatch() throws IOException {
        for (IBatchReader reader : this.pathBatchReaders.values()) {
            if (reader == null || !reader.hasNextBatch()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNextBatch(String fullPath) throws IOException {
        IBatchReader reader = this.pathBatchReaders.get(fullPath);
        return reader != null && reader.hasNextBatch();
    }

    @Override
    public BatchData nextBatch(String fullPath) throws IOException {
        return this.pathBatchReaders.get(fullPath).nextBatch();
    }

    public BatchData nextBatch() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }
}

