/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.jdbc.JdbcConverterUtils;
import org.apache.ignite.internal.jdbc.JdbcResultSetMetadata;
import org.apache.ignite.internal.jdbc.JdbcStatement;
import org.apache.ignite.internal.jdbc.proto.IgniteQueryErrorCode;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcFetchQueryResultsRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseRequest;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryCloseResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQueryFetchResult;
import org.apache.ignite.internal.jdbc.proto.event.JdbcQuerySingleResult;
import org.apache.ignite.internal.util.TransformingIterator;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class JdbcResultSet
implements ResultSet {
    private static final ThreadLocal<DecimalFormat> decimalFormat = new ThreadLocal<DecimalFormat>(){

        @Override
        protected DecimalFormat initialValue() {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setGroupingSeparator(',');
            symbols.setDecimalSeparator('.');
            DecimalFormat decimalFormat = new DecimalFormat("", symbols);
            decimalFormat.setParseBigDecimal(true);
            return decimalFormat;
        }
    };
    private final JdbcStatement stmt;
    @Nullable
    private final Long cursorId;
    private final boolean hasResultSet;
    private final boolean hasNextResult;
    @Nullable
    private final JdbcResultSetMetadata jdbcMeta;
    @Nullable
    private Map<String, Integer> colOrder;
    @Nullable
    private List<BinaryTupleReader> rows;
    @Nullable
    private Iterator<List<Object>> rowsIter;
    @Nullable
    private List<Object> curRow;
    private int curPos;
    private boolean finished;
    private boolean closed;
    private boolean holdsResource;
    private boolean wasNull;
    private int fetchSize;
    private long updCnt;
    private boolean closeStmt;
    private JdbcQueryCursorHandler cursorHandler;
    private int columnCount;
    @Nullable
    private Function<BinaryTupleReader, List<Object>> transformer;

    JdbcResultSet(JdbcQueryCursorHandler handler, JdbcStatement stmt, @Nullable Long cursorId, int fetchSize, boolean finished, @Nullable List<BinaryTupleReader> rows, @Nullable List<JdbcColumnMeta> meta, boolean hasResultSet, boolean hasNextResult, long updCnt, boolean closeStmt, int columnCount, @Nullable Function<BinaryTupleReader, List<Object>> transformer) {
        assert (stmt != null);
        assert (fetchSize > 0);
        this.cursorHandler = handler;
        this.stmt = stmt;
        this.cursorId = cursorId;
        this.fetchSize = fetchSize;
        this.finished = finished;
        this.hasResultSet = hasResultSet;
        this.hasNextResult = hasNextResult;
        this.closeStmt = closeStmt;
        this.columnCount = columnCount;
        if (this.hasResultSet) {
            this.transformer = Objects.requireNonNull(transformer);
            this.rows = Objects.requireNonNull(rows);
            this.jdbcMeta = new JdbcResultSetMetadata(Objects.requireNonNull(meta));
            this.rowsIter = new TransformingIterator(rows.iterator(), transformer);
        } else {
            this.updCnt = updCnt;
            this.jdbcMeta = null;
        }
        this.holdsResource = cursorId != null;
    }

    JdbcResultSet(List<List<Object>> rows, List<JdbcColumnMeta> meta) throws SQLException {
        this.stmt = null;
        this.cursorId = null;
        this.finished = true;
        this.hasResultSet = true;
        this.hasNextResult = false;
        this.holdsResource = false;
        this.rowsIter = rows.iterator();
        this.jdbcMeta = new JdbcResultSetMetadata(meta);
        this.initColumnOrder(this.jdbcMeta);
    }

    boolean holdResults() {
        return this.rows != null;
    }

    @Nullable
    JdbcResultSet getNextResultSet() throws SQLException {
        try {
            if (this.hasNextResult) {
                assert (this.cursorId != null);
                this.closed = true;
                this.holdsResource = false;
                JdbcFetchQueryResultsRequest req = new JdbcFetchQueryResultsRequest(this.cursorId.longValue(), this.fetchSize);
                JdbcQuerySingleResult res = (JdbcQuerySingleResult)this.cursorHandler.getMoreResultsAsync(req).get();
                if (!res.success()) {
                    throw IgniteQueryErrorCode.createJdbcSqlException((String)res.err(), (int)res.status());
                }
                Long newCursorId = res.cursorId();
                List meta = res.meta();
                this.rows = List.of();
                Function<BinaryTupleReader, List<Object>> transformer = meta != null ? JdbcResultSet.createTransformer(meta) : null;
                int colCount = meta != null ? meta.size() : 0;
                return new JdbcResultSet(this.cursorHandler, this.stmt, newCursorId, this.fetchSize, !res.hasMoreData(), res.items(), meta, res.hasResultSet(), res.hasNextResult(), res.updateCount(), this.closeStmt, colCount, transformer);
            }
            this.close0(true);
            return null;
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Fetch request failed.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Fetch request canceled.", "57014");
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureNotClosed();
        if (!(this.rowsIter != null && this.rowsIter.hasNext() || this.finished)) {
            try {
                JdbcQueryFetchResult res = (JdbcQueryFetchResult)this.cursorHandler.fetchAsync(new JdbcFetchQueryResultsRequest(this.cursorId.longValue(), this.fetchSize)).get();
                if (!res.success()) {
                    throw IgniteQueryErrorCode.createJdbcSqlException((String)res.err(), (int)res.status());
                }
                this.rows = new ArrayList<BinaryTupleReader>(res.items().size());
                for (ByteBuffer item : res.items()) {
                    this.rows.add(new BinaryTupleReader(this.columnCount, item));
                }
                this.finished = res.last();
                this.rowsIter = new TransformingIterator(this.rows.iterator(), this.transformer);
            }
            catch (InterruptedException e) {
                throw new SQLException("Thread was interrupted.", e);
            }
            catch (ExecutionException e) {
                throw new SQLException("Fetch request failed.", e);
            }
            catch (CancellationException e) {
                throw new SQLException("Fetch request canceled.", "57014");
            }
        }
        if (this.rowsIter != null) {
            if (this.rowsIter.hasNext()) {
                this.curRow = this.rowsIter.next();
                ++this.curPos;
                return true;
            }
            this.rowsIter = null;
            this.curRow = null;
            return false;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.close0(!this.hasNextResult);
        if (this.closeStmt) {
            this.stmt.closeIfAllResultsClosed();
        }
    }

    void close0(boolean removeFromResources) throws SQLException {
        try {
            JdbcQueryCloseResult res;
            if (!this.holdsResource) {
                return;
            }
            boolean bl = this.holdsResource = !removeFromResources;
            assert (this.cursorId != null);
            if (this.stmt != null && !(res = (JdbcQueryCloseResult)this.cursorHandler.closeAsync(new JdbcQueryCloseRequest(this.cursorId.longValue(), removeFromResources)).get()).success()) {
                throw IgniteQueryErrorCode.createJdbcSqlException((String)res.err(), (int)res.status());
            }
        }
        catch (InterruptedException e) {
            throw new SQLException("Thread was interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new SQLException("Unable to close result set.", e);
        }
        catch (CancellationException e) {
            throw new SQLException("Close result set request canceled.", e);
        }
        finally {
            this.closed = true;
        }
    }

    boolean holdsResources() {
        return this.holdsResource;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.ensureNotClosed();
        this.ensureHasCurrentRow();
        return this.wasNull;
    }

    @Override
    public String getString(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        return val == null ? null : String.valueOf(val);
    }

    @Override
    public String getString(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getString(colIdx);
    }

    @Override
    public boolean getBoolean(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return false;
        }
        Class<?> cls = val.getClass();
        if (cls == Boolean.class) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() != 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Integer.parseInt(val.toString()) != 0;
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to boolean: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to boolean: " + String.valueOf(val), "0700B");
    }

    @Override
    public boolean getBoolean(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBoolean(colIdx);
    }

    @Override
    public byte getByte(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? (byte)1 : 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Byte.parseByte(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to byte: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to byte: " + String.valueOf(val), "0700B");
    }

    @Override
    public byte getByte(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getByte(colIdx);
    }

    @Override
    public short getShort(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? (short)1 : 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Short.parseShort(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to short: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to short: " + String.valueOf(val), "0700B");
    }

    @Override
    public short getShort(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getShort(colIdx);
    }

    @Override
    public int getInt(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to int: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to int: " + String.valueOf(val), "0700B");
    }

    @Override
    public int getInt(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getInt(colIdx);
    }

    @Override
    public long getLong(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0L;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Long.parseLong(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to long: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to long: " + String.valueOf(val), "0700B");
    }

    @Override
    public long getLong(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getLong(colIdx);
    }

    @Override
    public float getFloat(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0.0f;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Float.parseFloat(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to float: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to float: " + String.valueOf(val), "0700B");
    }

    @Override
    public float getFloat(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getFloat(colIdx);
    }

    @Override
    public double getDouble(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return 0.0;
        }
        Class<?> cls = val.getClass();
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (cls == Boolean.class) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return Double.parseDouble(val.toString());
            }
            catch (NumberFormatException e) {
                throw new SQLException("Cannot convert to double: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to double: " + String.valueOf(val), "0700B");
    }

    @Override
    public double getDouble(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDouble(colIdx);
    }

    @Override
    public BigDecimal getBigDecimal(int colIdx, int scale) throws SQLException {
        BigDecimal val = this.getBigDecimal(colIdx);
        return val == null ? null : val.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == BigDecimal.class) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(((Number)val).doubleValue());
        }
        if (cls == Boolean.class) {
            return new BigDecimal((Boolean)val != false ? 1 : 0);
        }
        if (cls == String.class || cls == Character.class) {
            try {
                return (BigDecimal)decimalFormat.get().parse(val.toString());
            }
            catch (ParseException e) {
                throw new SQLException("Cannot convert to BigDecimal: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to BigDecimal: " + String.valueOf(val), "0700B");
    }

    @Override
    public BigDecimal getBigDecimal(String colLb, int scale) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBigDecimal(colIdx, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBigDecimal(colIdx);
    }

    @Override
    public byte[] getBytes(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == byte[].class) {
            return (byte[])val;
        }
        if (cls == Byte.class) {
            return new byte[]{(Byte)val};
        }
        if (cls == Short.class) {
            short x = (Short)val;
            return new byte[]{(byte)(x >> 8), (byte)x};
        }
        if (cls == Integer.class) {
            int x = (Integer)val;
            return new byte[]{(byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)x};
        }
        if (cls == Long.class) {
            long x = (Long)val;
            return new byte[]{(byte)(x >> 56), (byte)(x >> 48), (byte)(x >> 40), (byte)(x >> 32), (byte)(x >> 24), (byte)(x >> 16), (byte)(x >> 8), (byte)x};
        }
        if (cls == Float.class) {
            return ByteBuffer.allocate(4).putFloat(((Float)val).floatValue()).array();
        }
        if (cls == Double.class) {
            return ByteBuffer.allocate(8).putDouble((Double)val).array();
        }
        if (cls == String.class) {
            return ((String)val).getBytes(StandardCharsets.UTF_8);
        }
        if (cls == UUID.class) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(((UUID)val).getMostSignificantBits());
            bb.putLong(((UUID)val).getLeastSignificantBits());
            return bb.array();
        }
        throw new SQLException("Cannot convert to byte[]: " + String.valueOf(val), "0700B");
    }

    @Override
    public byte[] getBytes(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getBytes(colIdx);
    }

    @Override
    public Date getDate(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == LocalDate.class) {
            return Date.valueOf((LocalDate)val);
        }
        if (cls == LocalTime.class) {
            return new Date(Time.valueOf((LocalTime)val).getTime());
        }
        if (cls == Instant.class) {
            java.util.Date odlDate = java.util.Date.from((Instant)val);
            return new Date(odlDate.getTime());
        }
        if (cls == LocalDateTime.class) {
            return Date.valueOf(((LocalDateTime)val).toLocalDate());
        }
        throw new SQLException("Cannot convert to date: " + String.valueOf(val), "0700B");
    }

    @Override
    public Date getDate(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDate(colIdx);
    }

    @Override
    public Date getDate(int colIdx, Calendar cal) throws SQLException {
        return this.getDate(colIdx);
    }

    @Override
    public Date getDate(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getDate(colIdx);
    }

    @Override
    public Time getTime(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == LocalTime.class) {
            return Time.valueOf((LocalTime)val);
        }
        if (cls == LocalDate.class) {
            return new Time(Date.valueOf((LocalDate)val).getTime());
        }
        if (cls == Instant.class) {
            Timestamp oldTs = Timestamp.from((Instant)val);
            return new Time(oldTs.getTime());
        }
        if (cls == LocalDateTime.class) {
            return Time.valueOf(((LocalDateTime)val).toLocalTime());
        }
        throw new SQLException("Cannot convert to time: " + String.valueOf(val), "0700B");
    }

    @Override
    public Time getTime(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTime(colIdx);
    }

    @Override
    public Time getTime(int colIdx, Calendar cal) throws SQLException {
        return this.getTime(colIdx);
    }

    @Override
    public Time getTime(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTime(colIdx);
    }

    @Override
    public Timestamp getTimestamp(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == LocalTime.class) {
            return new Timestamp(Time.valueOf((LocalTime)val).getTime());
        }
        if (cls == LocalDate.class) {
            return new Timestamp(Date.valueOf((LocalDate)val).getTime());
        }
        if (cls == Instant.class) {
            return Timestamp.from((Instant)val);
        }
        if (cls == LocalDateTime.class) {
            return Timestamp.valueOf((LocalDateTime)val);
        }
        throw new SQLException("Cannot convert to timestamp: " + String.valueOf(val), "0700B");
    }

    @Override
    public Timestamp getTimestamp(int colIdx, Calendar cal) throws SQLException {
        return this.getTimestamp(colIdx);
    }

    @Override
    public Timestamp getTimestamp(String colLb, Calendar cal) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTimestamp(colIdx);
    }

    @Override
    public Timestamp getTimestamp(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getTimestamp(colIdx);
    }

    @Override
    public InputStream getAsciiStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getAsciiStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getUnicodeStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getUnicodeStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public InputStream getBinaryStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Stream are not supported.");
    }

    @Override
    public InputStream getBinaryStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return this.metaOrThrow();
    }

    @Override
    public int findColumn(String colLb) throws SQLException {
        this.ensureNotClosed();
        Objects.requireNonNull(colLb);
        Integer order = this.columnOrder().get(colLb.toUpperCase());
        if (order == null) {
            throw new SQLException("Column not found: " + colLb, "42000");
        }
        assert (order >= 0);
        return order + 1;
    }

    @Override
    public Reader getCharacterStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public Reader getCharacterStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Streams are not supported.");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureNotClosed();
        return this.curPos == 0 && this.rowsIter != null && this.rowsIter.hasNext();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureNotClosed();
        return this.finished && this.rowsIter == null && this.curRow == null;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureNotClosed();
        return this.curPos == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureNotClosed();
        return this.finished && this.rowsIter != null && !this.rowsIter.hasNext() && this.curRow != null;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureNotClosed();
        return this.isAfterLast() ? 0 : this.curPos;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureNotClosed();
        throw new SQLException("Result set is forward-only.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.ensureNotClosed();
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only forward direction is supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.ensureNotClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.ensureNotClosed();
        if (fetchSize <= 0) {
            throw new SQLException("Fetch size must be greater than zero.");
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureNotClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureNotClosed();
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureNotClosed();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.ensureNotClosed();
        return false;
    }

    @Override
    public void updateNull(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNull(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBoolean(int colIdx, boolean x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBoolean(String colLb, boolean x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateByte(int colIdx, byte x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateByte(String colLb, byte x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateShort(int colIdx, short x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateShort(String colLb, short x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateInt(int colIdx, int x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateInt(String colLb, int x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateLong(int colIdx, long x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateLong(String colLb, long x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateFloat(int colIdx, float x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateFloat(String colLb, float x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateDouble(int colIdx, double x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateDouble(String colLb, double x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBigDecimal(int colIdx, BigDecimal x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBigDecimal(String colLb, BigDecimal x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateString(int colIdx, String x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateString(String colLb, String x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBytes(int colIdx, byte[] x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBytes(String colLb, byte[] x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateDate(int colIdx, Date x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateDate(String colLb, Date x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateTime(int colIdx, Time x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateTime(String colLb, Time x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateTimestamp(int colIdx, Timestamp x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateTimestamp(String colLb, Timestamp x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(int colIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateAsciiStream(String colLb, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(int colIdx, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBinaryStream(String colLb, InputStream x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader, int len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(int colIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateCharacterStream(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateObject(int colIdx, Object x, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateObject(int colIdx, Object x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateObject(String colLb, Object x, int scaleOrLen) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateObject(String colLb, Object x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void insertRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Row refreshing is not supported.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Row updates are not supported.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.ensureNotClosed();
        if (this.getConcurrency() == 1007) {
            throw new SQLException("The result set concurrency is CONCUR_READ_ONLY");
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureNotClosed();
        return this.stmt;
    }

    @Override
    public Object getObject(int colIdx, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL structured type are not supported.");
    }

    @Override
    public <T> T getObject(int colIdx, Class<T> targetCls) throws SQLException {
        this.ensureNotClosed();
        return (T)this.getObject0(colIdx, targetCls);
    }

    @Override
    public <T> T getObject(String colLb, Class<T> type) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getObject(colIdx, type);
    }

    @Override
    public Object getObject(int colIdx) throws SQLException {
        return this.getValue(colIdx);
    }

    @Override
    public Object getObject(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getValue(colIdx);
    }

    @Override
    public Object getObject(String colLb, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("SQL structured type are not supported.");
    }

    @Override
    public Ref getRef(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Ref getRef(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob getBlob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob getBlob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Clob getClob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Clob getClob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Array getArray(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Array getArray(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public URL getURL(int colIdx) throws SQLException {
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (cls == URL.class) {
            return (URL)val;
        }
        if (cls == String.class) {
            try {
                return new URL(val.toString());
            }
            catch (MalformedURLException e) {
                throw new SQLException("Cannot convert to URL: " + String.valueOf(val), "0700B", e);
            }
        }
        throw new SQLException("Cannot convert to URL: " + String.valueOf(val), "0700B");
    }

    @Override
    public URL getURL(String colLb) throws SQLException {
        int colIdx = this.findColumn(colLb);
        return this.getURL(colIdx);
    }

    @Override
    public void updateRef(int colIdx, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateRef(String colLb, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(int colIdx, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(String colLb, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(int colIdx, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(String colLb, InputStream inputStream, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(int colIdx, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateBlob(String colLb, InputStream inputStream) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(int colIdx, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(String colLb, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(int colIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(int colIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateClob(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateArray(int colIdx, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateArray(String colLb, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public RowId getRowId(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public RowId getRowId(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void updateRowId(int colIdx, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateRowId(String colLb, RowId x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.stmt == null || this.stmt.isClosed();
    }

    @Override
    public void updateNString(int colIdx, String val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNString(String colLb, String val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(int colIdx, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(String colLb, NClob val) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(int colIdx, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(int colIdx, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNClob(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public NClob getNClob(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob getNClob(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML getSQLXML(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML getSQLXML(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void updateSQLXML(int colIdx, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateSQLXML(String colLb, SQLXML xmlObj) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public String getNString(int colIdx) throws SQLException {
        return this.getString(colIdx);
    }

    @Override
    public String getNString(String colLb) throws SQLException {
        return this.getString(colLb);
    }

    @Override
    public Reader getNCharacterStream(int colIdx) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Reader getNCharacterStream(String colLb) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public void updateNCharacterStream(int colIdx, Reader x, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNCharacterStream(String colLb, Reader reader, long len) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNCharacterStream(int colIdx, Reader x) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public void updateNCharacterStream(String colLb, Reader reader) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Result set is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcResultSet.class);
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    private Object getValue(int colIdx) throws SQLException {
        this.ensureNotClosed();
        this.ensureHasCurrentRow();
        try {
            assert (this.curRow != null);
            Object val = this.curRow.get(colIdx - 1);
            this.wasNull = val == null;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException("Invalid column index: " + colIdx, "42000", e);
        }
    }

    private void ensureHasCurrentRow() throws SQLException {
        if (this.curRow == null) {
            throw new SQLException("Result set is not positioned on a row.");
        }
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Result set is closed.", "24000");
        }
    }

    public long updatedCount() {
        return this.updCnt;
    }

    public void closeStatement(boolean closeStmt) {
        this.closeStmt = closeStmt;
    }

    private Object getObject0(int colIdx, Class<?> targetCls) throws SQLException {
        if (targetCls == Boolean.class) {
            return this.getBoolean(colIdx);
        }
        if (targetCls == Byte.class) {
            return this.getByte(colIdx);
        }
        if (targetCls == Short.class) {
            return this.getShort(colIdx);
        }
        if (targetCls == Integer.class) {
            return this.getInt(colIdx);
        }
        if (targetCls == Long.class) {
            return this.getLong(colIdx);
        }
        if (targetCls == Float.class) {
            return Float.valueOf(this.getFloat(colIdx));
        }
        if (targetCls == Double.class) {
            return this.getDouble(colIdx);
        }
        if (targetCls == String.class) {
            return this.getString(colIdx);
        }
        if (targetCls == BigDecimal.class) {
            return this.getBigDecimal(colIdx);
        }
        if (targetCls == Date.class) {
            return this.getDate(colIdx);
        }
        if (targetCls == Time.class) {
            return this.getTime(colIdx);
        }
        if (targetCls == Timestamp.class) {
            return this.getTimestamp(colIdx);
        }
        if (targetCls == byte[].class) {
            return this.getBytes(colIdx);
        }
        if (targetCls == URL.class) {
            return this.getURL(colIdx);
        }
        Object val = this.getValue(colIdx);
        if (val == null) {
            return null;
        }
        Class<?> cls = val.getClass();
        if (targetCls.isAssignableFrom(cls)) {
            return val;
        }
        throw new SQLException("Cannot convert to " + targetCls.getName() + ": " + String.valueOf(val), "0700B");
    }

    private Map<String, Integer> columnOrder() throws SQLException {
        if (this.colOrder != null) {
            return this.colOrder;
        }
        this.initColumnOrder(this.metaOrThrow());
        return this.colOrder;
    }

    private void initColumnOrder(JdbcResultSetMetadata jdbcMeta) throws SQLException {
        this.colOrder = new HashMap<String, Integer>(jdbcMeta.getColumnCount());
        for (int i = 0; i < jdbcMeta.getColumnCount(); ++i) {
            String colName = jdbcMeta.getColumnLabel(i + 1).toUpperCase();
            if (this.colOrder.containsKey(colName)) continue;
            this.colOrder.put(colName, i);
        }
    }

    private JdbcResultSetMetadata metaOrThrow() throws SQLException {
        if (this.jdbcMeta == null) {
            throw new SQLException("Result doesn't have metadata");
        }
        return this.jdbcMeta;
    }

    static Function<BinaryTupleReader, List<Object>> createTransformer(List<JdbcColumnMeta> meta) {
        return tuple -> {
            int columnCount = meta.size();
            ArrayList<Object> row = new ArrayList<Object>(columnCount);
            int currentDecimalScale = -1;
            int idx = 0;
            for (JdbcColumnMeta columnMeta : meta) {
                ColumnType type = columnMeta.columnType();
                if (type == ColumnType.DECIMAL) {
                    currentDecimalScale = columnMeta.scale();
                }
                row.add(JdbcConverterUtils.deriveValueFromBinaryTuple((ColumnType)type, (BinaryTupleReader)tuple, (int)idx++, (int)currentDecimalScale));
            }
            return row;
        };
    }
}

