/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.observation;

import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MetricConfig {
    public final String prefix;
    public final Duration slo;
    public final double[] percentiles;
    public final boolean perUriIo;
    public final List<Tag> commonTags;
    public static final MetricConfig DEFAULT = MetricConfig.builder().build();

    private MetricConfig(Builder b) {
        this.prefix = b.prefix;
        this.slo = b.slo;
        this.percentiles = b.percentiles != null ? (double[])b.percentiles.clone() : new double[]{};
        this.perUriIo = b.perUriIo;
        this.commonTags = Collections.unmodifiableList(new ArrayList(b.commonTags));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String prefix = "http.client";
        private Duration slo = Duration.ofMillis(500L);
        private double[] percentiles = new double[]{0.9, 0.99};
        private boolean perUriIo = false;
        private final List<Tag> commonTags = new ArrayList<Tag>();

        public Builder prefix(String p) {
            this.prefix = p;
            return this;
        }

        public Builder slo(Duration d) {
            this.slo = d;
            return this;
        }

        public Builder percentiles(double ... p) {
            if (p != null) {
                for (double d : p) {
                    if (!(d < 0.0) && !(d > 1.0)) continue;
                    throw new IllegalArgumentException("percentile out of range [0..1]: " + d);
                }
                this.percentiles = (double[])p.clone();
            } else {
                this.percentiles = new double[0];
            }
            return this;
        }

        public Builder perUriIo(boolean b) {
            this.perUriIo = b;
            return this;
        }

        public Builder addCommonTag(String k, String v) {
            this.commonTags.add(Tag.of((String)k, (String)v));
            return this;
        }

        public Builder addCommonTags(Iterable<Tag> tags) {
            for (Tag t : tags) {
                this.commonTags.add(t);
            }
            return this;
        }

        public MetricConfig build() {
            return new MetricConfig(this);
        }
    }
}

