/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;

public class GroupMessageHandler {
    final ConcurrentHashMap<String, GroupMessageInfo> _groupMsgMap = new ConcurrentHashMap();

    public void put(Message message) {
        this._groupMsgMap.putIfAbsent(message.getId(), new GroupMessageInfo(message));
    }

    public GroupMessageInfo onCompleteSubMessage(Message subMessage) {
        int val;
        String parentMid = subMessage.getAttribute(Message.Attributes.PARENT_MSG_ID);
        GroupMessageInfo info = this._groupMsgMap.get(parentMid);
        if (info != null && (val = info._countDown.decrementAndGet()) <= 0) {
            return this._groupMsgMap.remove(parentMid);
        }
        return null;
    }

    void addCurStateUpdate(Message subMessage, PropertyKey key, CurrentState delta) {
        String parentMid = subMessage.getAttribute(Message.Attributes.PARENT_MSG_ID);
        GroupMessageInfo info = this._groupMsgMap.get(parentMid);
        if (info != null) {
            info._curStateUpdateList.add(new CurrentStateUpdate(key, delta));
        }
    }

    static class GroupMessageInfo {
        final Message _message;
        final AtomicInteger _countDown;
        final ConcurrentLinkedQueue<CurrentStateUpdate> _curStateUpdateList;

        public GroupMessageInfo(Message message) {
            this._message = message;
            List<String> partitionNames = message.getPartitionNames();
            this._countDown = new AtomicInteger(partitionNames.size());
            this._curStateUpdateList = new ConcurrentLinkedQueue();
        }

        public Map<PropertyKey, CurrentState> merge() {
            HashMap<String, CurrentStateUpdate> curStateUpdateMap = new HashMap<String, CurrentStateUpdate>();
            for (CurrentStateUpdate update : this._curStateUpdateList) {
                String path = update._key.getPath();
                if (!curStateUpdateMap.containsKey(path)) {
                    curStateUpdateMap.put(path, update);
                    continue;
                }
                ((CurrentStateUpdate)curStateUpdateMap.get(path)).merge(update._curStateDelta);
            }
            HashMap<PropertyKey, CurrentState> ret = new HashMap<PropertyKey, CurrentState>();
            for (CurrentStateUpdate update : curStateUpdateMap.values()) {
                ret.put(update._key, update._curStateDelta);
            }
            return ret;
        }
    }

    class CurrentStateUpdate {
        final PropertyKey _key;
        final CurrentState _curStateDelta;

        public CurrentStateUpdate(PropertyKey key, CurrentState curStateDelta) {
            this._key = key;
            this._curStateDelta = curStateDelta;
        }

        public void merge(CurrentState curState) {
            this._curStateDelta.getRecord().merge(curState.getRecord());
        }
    }
}

