/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDag {
    private static final Logger LOG = LoggerFactory.getLogger(JobDag.class);
    @JsonProperty(value="parentsToChildren")
    protected Map<String, Set<String>> _parentsToChildren = new TreeMap<String, Set<String>>();
    @JsonProperty(value="childrenToParents")
    protected Map<String, Set<String>> _childrenToParents = new TreeMap<String, Set<String>>();
    @JsonProperty(value="allNodes")
    protected Set<String> _allNodes = new TreeSet<String>();
    protected Set<String> _independentNodes;
    public static final JobDag EMPTY_DAG = new JobDag();
    protected Iterator<String> _jobIterator;

    public void addParentToChild(String parent, String child) {
        if (!this._parentsToChildren.containsKey(parent)) {
            this._parentsToChildren.put(parent, new TreeSet());
        }
        this._parentsToChildren.get(parent).add(child);
        if (!this._childrenToParents.containsKey(child)) {
            this._childrenToParents.put(child, new TreeSet());
        }
        this._childrenToParents.get(child).add(parent);
        this._allNodes.add(parent);
        this._allNodes.add(child);
    }

    private void removeParentToChild(String parent, String child) {
        if (this._parentsToChildren.containsKey(parent)) {
            Set<String> children = this._parentsToChildren.get(parent);
            children.remove(child);
            if (children.isEmpty()) {
                this._parentsToChildren.remove(parent);
            }
        }
        if (this._childrenToParents.containsKey(child)) {
            Set<String> parents = this._childrenToParents.get(child);
            parents.remove(parent);
            if (parents.isEmpty()) {
                this._childrenToParents.remove(child);
            }
        }
    }

    public void addNode(String node) {
        this._allNodes.add(node);
    }

    private void removeNode(String node) {
        if (this._parentsToChildren.containsKey(node) || this._childrenToParents.containsKey(node)) {
            throw new IllegalStateException("The node is either a parent or a child of other node, could not be deleted");
        }
        this._allNodes.remove(node);
    }

    public void removeNode(String job, boolean maintainDependency) {
        if (!this._allNodes.contains(job)) {
            LOG.info("Could not delete job {} from DAG, node does not exist", (Object)job);
            return;
        }
        if (maintainDependency) {
            String parent = null;
            String child = null;
            for (String n : this._allNodes) {
                if (this.getDirectChildren(n).contains(job)) {
                    parent = n;
                    this.removeParentToChild(parent, job);
                    continue;
                }
                if (!this.getDirectParents(n).contains(job)) continue;
                child = n;
                this.removeParentToChild(job, child);
            }
            if (parent != null && child != null) {
                this.addParentToChild(parent, child);
            }
            this.removeNode(job);
        } else {
            for (String child : this.getDirectChildren(job)) {
                this.getChildrenToParents().get(child).remove(job);
            }
            for (String parent : this.getDirectParents(job)) {
                this.getParentsToChildren().get(parent).remove(job);
            }
            this._childrenToParents.remove(job);
            this._parentsToChildren.remove(job);
            this.removeNode(job);
        }
    }

    public Map<String, Set<String>> getParentsToChildren() {
        return this._parentsToChildren;
    }

    public Map<String, Set<String>> getChildrenToParents() {
        return this._childrenToParents;
    }

    public Set<String> getAllNodes() {
        return this._allNodes;
    }

    public Set<String> getDirectChildren(String node) {
        if (!this._parentsToChildren.containsKey(node)) {
            return Collections.emptySet();
        }
        return this._parentsToChildren.get(node);
    }

    public Set<String> getDirectParents(String node) {
        if (!this._childrenToParents.containsKey(node)) {
            return Collections.emptySet();
        }
        return this._childrenToParents.get(node);
    }

    public Set<String> getAncestors(String node) {
        HashSet<String> ancestors = new HashSet<String>();
        Set<String> current = Collections.singleton(node);
        while (!current.isEmpty()) {
            HashSet<String> next = new HashSet<String>();
            for (String currentNode : current) {
                next.addAll(this.getDirectParents(currentNode));
            }
            ancestors.addAll(next);
            current = next;
        }
        return ancestors;
    }

    public String toJson() throws IOException {
        return new ObjectMapper().writeValueAsString((Object)this);
    }

    public static JobDag fromJson(String json) {
        try {
            return (JobDag)new ObjectMapper().readValue(json, JobDag.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse json " + json + " into job dag");
        }
    }

    public int size() {
        return this._allNodes.size();
    }

    public void validate() {
        int iterationCount;
        this.computeIndependentNodes();
        Set<String> prevIteration = this._independentNodes;
        HashSet<String> allNodesReached = new HashSet<String>();
        int maxIterations = this._allNodes.size() + 1;
        for (iterationCount = 0; !prevIteration.isEmpty() && iterationCount < maxIterations; ++iterationCount) {
            HashSet<String> thisIteration = new HashSet<String>();
            for (String node : prevIteration) {
                thisIteration.addAll(this.getDirectChildren(node));
            }
            allNodesReached.addAll(prevIteration);
            prevIteration = thisIteration;
        }
        allNodesReached.addAll(prevIteration);
        if (iterationCount >= maxIterations) {
            throw new IllegalArgumentException("DAG invalid: cycles detected");
        }
        if (!allNodesReached.containsAll(this._allNodes)) {
            throw new IllegalArgumentException("DAG invalid: unreachable nodes found. Reachable set is " + allNodesReached);
        }
    }

    protected void computeIndependentNodes() {
        this._independentNodes = new HashSet<String>();
        for (String node : this._allNodes) {
            if (this._childrenToParents.containsKey(node)) continue;
            this._independentNodes.add(node);
        }
    }

    @JsonIgnore
    public String getNextJob() {
        if (this._jobIterator == null) {
            this._jobIterator = this._allNodes.iterator();
        }
        if (this._jobIterator.hasNext()) {
            return this._jobIterator.next();
        }
        return null;
    }
}

