/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.model.ConfigScope;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.util.StringTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ConfigScopeBuilder {
    private static Logger LOG = LoggerFactory.getLogger(ConfigScopeBuilder.class);
    private static StringTemplate template = new StringTemplate();
    private final Map<HelixConfigScope.ConfigScopeProperty, String> _scopeMap = new HashMap<HelixConfigScope.ConfigScopeProperty, String>();

    public Map<HelixConfigScope.ConfigScopeProperty, String> getScopeMap() {
        return this._scopeMap;
    }

    public ConfigScopeBuilder forCluster(String clusterName) {
        this._scopeMap.put(HelixConfigScope.ConfigScopeProperty.CLUSTER, clusterName);
        return this;
    }

    public ConfigScopeBuilder forParticipant(String participantName) {
        this._scopeMap.put(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, participantName);
        return this;
    }

    public ConfigScopeBuilder forResource(String resourceName) {
        this._scopeMap.put(HelixConfigScope.ConfigScopeProperty.RESOURCE, resourceName);
        return this;
    }

    public ConfigScopeBuilder forPartition(String partitionName) {
        this._scopeMap.put(HelixConfigScope.ConfigScopeProperty.PARTITION, partitionName);
        return this;
    }

    public ConfigScope build() {
        return new ConfigScope(this);
    }

    public ConfigScope build(HelixConfigScope.ConfigScopeProperty scope, String clusterName, String ... scopeKeys) {
        if (scopeKeys == null) {
            scopeKeys = new String[]{};
        }
        String[] args = new String[1 + scopeKeys.length];
        args[0] = clusterName;
        System.arraycopy(scopeKeys, 0, args, 1, scopeKeys.length);
        String scopePairs = template.instantiate(scope, args);
        return this.build(scopePairs);
    }

    public ConfigScope build(String scopePairs) {
        String[] scopes;
        for (String scope : scopes = scopePairs.split("[\\s,]+")) {
            try {
                int idx = scope.indexOf(61);
                if (idx == -1) {
                    LOG.error("Invalid scope string: " + scope);
                    continue;
                }
                String scopeStr = scope.substring(0, idx);
                String value = scope.substring(idx + 1);
                HelixConfigScope.ConfigScopeProperty scopeProperty = HelixConfigScope.ConfigScopeProperty.valueOf(scopeStr);
                this._scopeMap.put(scopeProperty, value);
            }
            catch (Exception e) {
                LOG.error("Invalid scope string: " + scope);
            }
        }
        return this.build();
    }

    public String toString() {
        return this._scopeMap.toString();
    }

    static {
        template.addEntry(HelixConfigScope.ConfigScopeProperty.CLUSTER, 1, "CLUSTER={clusterName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.RESOURCE, 2, "CLUSTER={clusterName},RESOURCE={resourceName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTITION, 3, "CLUSTER={clusterName},RESOURCE={resourceName},PARTITION={partitionName}");
        template.addEntry(HelixConfigScope.ConfigScopeProperty.PARTICIPANT, 2, "CLUSTER={clusterName},PARTICIPANT={participantName}");
    }
}

