/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.RuntimeJobDag;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDataCache
extends AbstractDataCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)TaskDataCache.class.getName());
    private static final String NAME = "NAME";
    private Map<String, JobConfig> _jobConfigMap = new HashMap<String, JobConfig>();
    private Map<String, RuntimeJobDag> _runtimeJobDagMap = new HashMap<String, RuntimeJobDag>();
    private Map<String, WorkflowConfig> _workflowConfigMap = new ConcurrentHashMap<String, WorkflowConfig>();
    private Map<String, ZNRecord> _contextMap = new HashMap<String, ZNRecord>();
    private Set<String> _contextToUpdate = new HashSet<String>();
    private Set<String> _contextToRemove = new HashSet<String>();
    private final AssignableInstanceManager _assignableInstanceManager = new AssignableInstanceManager();
    private Set<String> _dispatchedJobs = new HashSet<String>();

    public TaskDataCache(ControlContextProvider contextProvider) {
        super(contextProvider);
    }

    public TaskDataCache(String clusterName) {
        this(TaskDataCache.createDefaultControlContextProvider(clusterName));
    }

    public synchronized boolean refresh(HelixDataAccessor accessor, Map<String, ResourceConfig> resourceConfigMap) {
        WorkflowConfig workflowConfig;
        this.refreshContexts(accessor);
        this._workflowConfigMap.clear();
        HashMap<String, JobConfig> newJobConfigs = new HashMap<String, JobConfig>();
        HashSet<String> workflowsUpdated = new HashSet<String>();
        for (Map.Entry<String, ResourceConfig> entry : resourceConfigMap.entrySet()) {
            if (entry.getValue().getRecord().getSimpleFields().containsKey(WorkflowConfig.WorkflowConfigProperty.Dag.name())) {
                this._workflowConfigMap.put(entry.getKey(), new WorkflowConfig(entry.getValue()));
                if (this._runtimeJobDagMap.containsKey(entry.getKey())) continue;
                workflowConfig = this._workflowConfigMap.get(entry.getKey());
                this._runtimeJobDagMap.put(entry.getKey(), new RuntimeJobDag(workflowConfig.getJobDag(), workflowConfig.isJobQueue() || !workflowConfig.isTerminable(), workflowConfig.getParallelJobs(), workflowConfig.getRecord().getVersion()));
                continue;
            }
            if (!entry.getValue().getRecord().getSimpleFields().containsKey(WorkflowConfig.WorkflowConfigProperty.WorkflowID.name())) continue;
            newJobConfigs.put(entry.getKey(), new JobConfig(entry.getValue()));
        }
        for (String workflowName : this._workflowConfigMap.keySet()) {
            if (!this._runtimeJobDagMap.containsKey(workflowName) || this._workflowConfigMap.get(workflowName).getRecord().getVersion() == this._runtimeJobDagMap.get(workflowName).getVersion()) continue;
            workflowsUpdated.add(workflowName);
        }
        for (String changedWorkflow : workflowsUpdated) {
            if (!this._workflowConfigMap.containsKey(changedWorkflow)) continue;
            workflowConfig = this._workflowConfigMap.get(changedWorkflow);
            this._runtimeJobDagMap.put(changedWorkflow, new RuntimeJobDag(workflowConfig.getJobDag(), workflowConfig.isJobQueue() || !workflowConfig.isTerminable(), workflowConfig.getParallelJobs(), workflowConfig.getRecord().getVersion()));
        }
        this._dispatchedJobs.clear();
        this._runtimeJobDagMap.keySet().retainAll(this._workflowConfigMap.keySet());
        this._jobConfigMap = newJobConfigs;
        return true;
    }

    private void refreshContexts(HelixDataAccessor accessor) {
        long start = System.currentTimeMillis();
        this._contextMap.clear();
        if (this._controlContextProvider.getClusterName() == null || this._controlContextProvider.getClusterName().equalsIgnoreCase("UNKNOWN_CLUSTER")) {
            return;
        }
        String path = String.format("/%s/%s%s", this._controlContextProvider.getClusterName(), PropertyType.PROPERTYSTORE.name(), "/TaskRebalancer");
        ArrayList<String> contextPaths = new ArrayList<String>();
        List<String> childNames = accessor.getBaseDataAccessor().getChildNames(path, 0);
        if (childNames == null) {
            return;
        }
        for (String resourceName : childNames) {
            contextPaths.add(this.getTaskDataPath(resourceName, TaskDataType.CONTEXT));
        }
        List<ZNRecord> contexts = accessor.getBaseDataAccessor().get(contextPaths, null, 0, true);
        for (int i = 0; i < contexts.size(); ++i) {
            ZNRecord context = contexts.get(i);
            if (context != null && context.getSimpleField(NAME) != null) {
                this._contextMap.put(context.getSimpleField(NAME), context);
                continue;
            }
            this._contextMap.put(childNames.get(i), context);
            LogUtil.logDebug(LOG, this.genEventInfo(), String.format("Context for %s is null or miss the context NAME!", childNames.get(i)));
        }
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.genEventInfo(), "# of workflow/job context read from zk: " + this._contextMap.size() + ". Take " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    public Map<String, JobConfig> getJobConfigMap() {
        return this._jobConfigMap;
    }

    public JobConfig getJobConfig(String resource) {
        return this._jobConfigMap.get(resource);
    }

    public Map<String, WorkflowConfig> getWorkflowConfigMap() {
        return this._workflowConfigMap;
    }

    public WorkflowConfig getWorkflowConfig(String resource) {
        return this._workflowConfigMap.get(resource);
    }

    public JobContext getJobContext(String resourceName) {
        if (this._contextMap.containsKey(resourceName) && this._contextMap.get(resourceName) != null) {
            return new JobContext(this._contextMap.get(resourceName));
        }
        return null;
    }

    public WorkflowContext getWorkflowContext(String resourceName) {
        if (this._contextMap.containsKey(resourceName) && this._contextMap.get(resourceName) != null) {
            return new WorkflowContext(this._contextMap.get(resourceName));
        }
        return null;
    }

    public void updateJobContext(String resourceName, JobContext jobContext) {
        if (!this._contextMap.containsKey(resourceName) || jobContext.isJobContextModified()) {
            this.updateContext(resourceName, jobContext.getRecord());
        }
    }

    public void updateWorkflowContext(String resourceName, WorkflowContext workflowContext) {
        if (!this._contextMap.containsKey(resourceName) || workflowContext.isWorkflowContextModified()) {
            this.updateContext(resourceName, workflowContext.getRecord());
        }
    }

    private void updateContext(String resourceName, ZNRecord record) {
        this._contextMap.put(resourceName, record);
        this._contextToUpdate.add(resourceName);
    }

    public void persistDataChanges(HelixDataAccessor accessor) {
        this._contextToUpdate.removeAll(this._contextToRemove);
        this.batchUpdateData(accessor, new ArrayList<String>(this._contextToUpdate), this._contextMap, this._contextToUpdate, TaskDataType.CONTEXT);
        this.batchDeleteData(accessor, new ArrayList<String>(this._contextToRemove), TaskDataType.CONTEXT);
        this._contextToRemove.clear();
    }

    private void batchUpdateData(HelixDataAccessor accessor, List<String> dataUpdateNames, Map<String, ZNRecord> dataMap, Set<String> dataToUpdate, TaskDataType taskDataType) {
        ArrayList<String> contextUpdatePaths = new ArrayList<String>();
        ArrayList<ZNRecord> updatedData = new ArrayList<ZNRecord>();
        for (String resourceName : dataUpdateNames) {
            if (dataMap.get(resourceName) == null) continue;
            contextUpdatePaths.add(this.getTaskDataPath(resourceName, taskDataType));
            updatedData.add(dataMap.get(resourceName));
        }
        boolean[] updateSuccess = accessor.getBaseDataAccessor().setChildren(contextUpdatePaths, updatedData, AccessOption.PERSISTENT);
        for (int i = 0; i < updateSuccess.length; ++i) {
            if (updateSuccess[i]) {
                dataToUpdate.remove(dataUpdateNames.get(i));
                continue;
            }
            LogUtil.logWarn(LOG, this._controlContextProvider.getClusterEventId(), String.format("Failed to update the %s for %s", taskDataType.name(), dataUpdateNames.get(i)));
        }
    }

    private void batchDeleteData(HelixDataAccessor accessor, List<String> contextNamesToRemove, TaskDataType taskDataType) {
        ArrayList<String> contextPathsToRemove = new ArrayList<String>();
        for (String resourceName : contextNamesToRemove) {
            contextPathsToRemove.add(this.getTaskDataPath(resourceName, taskDataType));
        }
        accessor.getBaseDataAccessor().remove(contextPathsToRemove, AccessOption.PERSISTENT);
    }

    public Map<String, ZNRecord> getContexts() {
        return this._contextMap;
    }

    public AssignableInstanceManager getAssignableInstanceManager() {
        return this._assignableInstanceManager;
    }

    public void removeContext(String resourceName) {
        if (this._contextMap.containsKey(resourceName)) {
            this._contextMap.remove(resourceName);
            this._contextToRemove.add(resourceName);
        }
    }

    public String toString() {
        return "TaskDataCache{_jobConfigMap=" + this._jobConfigMap + ", _workflowConfigMap=" + this._workflowConfigMap + ", _contextMap=" + this._contextMap + ", _clusterName='" + this._controlContextProvider.getClusterName() + "'}";
    }

    private String getTaskDataPath(String resourceName, TaskDataType taskDataType) {
        String prevFix = String.format("/%s/%s%s/%s", this._controlContextProvider.getClusterName(), PropertyType.PROPERTYSTORE.name(), "/TaskRebalancer", resourceName);
        switch (taskDataType) {
            case CONTEXT: {
                return String.format("%s/%s", prevFix, "Context");
            }
        }
        return null;
    }

    public void dispatchJob(String jobName) {
        this._dispatchedJobs.add(jobName);
    }

    public void removeDispatchedJob(String jobName) {
        this._dispatchedJobs.remove(jobName);
    }

    public Set<String> getDispatchedJobs() {
        return this._dispatchedJobs;
    }

    public RuntimeJobDag getRuntimeJobDag(String workflowName) {
        if (this._runtimeJobDagMap.containsKey(workflowName)) {
            return this._runtimeJobDagMap.get(workflowName);
        }
        return null;
    }

    private static enum TaskDataType {
        CONTEXT;

    }
}

