/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.restlet.security.LocalVerifier;

public class MapVerifier
extends LocalVerifier {
    private final ConcurrentMap<String, char[]> localSecrets;

    public MapVerifier() {
        this(new ConcurrentHashMap<String, char[]>());
    }

    public MapVerifier(ConcurrentMap<String, char[]> localSecrets) {
        this.localSecrets = localSecrets;
    }

    @Override
    public char[] getLocalSecret(String identifier) {
        return identifier == null ? null : (char[])this.getLocalSecrets().get(identifier);
    }

    public ConcurrentMap<String, char[]> getLocalSecrets() {
        return this.localSecrets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalSecrets(Map<String, char[]> localSecrets) {
        ConcurrentMap<String, char[]> concurrentMap = this.getLocalSecrets();
        synchronized (concurrentMap) {
            if (localSecrets != this.getLocalSecrets()) {
                this.getLocalSecrets().clear();
                if (localSecrets != null) {
                    this.getLocalSecrets().putAll(localSecrets);
                }
            }
        }
    }
}

