/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.util.SetUtils;

public class CorsResponseHelper {
    private static Logger LOGGER = Context.getCurrentLogger();
    public boolean allowAllRequestedHeaders = true;
    public boolean allowedCredentials = false;
    public Set<String> allowedHeaders = null;
    public Set<String> allowedOrigins = SetUtils.newHashSet("*");
    public Set<String> exposedHeaders = null;
    public int maxAge = -1;

    public void addCorsResponseHeaders(Request request, Response response) {
        String origin = request.getHeaders().getFirstValue("Origin", true);
        if (origin == null) {
            return;
        }
        HashSet<Method> allowedMethods = new HashSet<Method>(response.getAllowedMethods());
        response.getAllowedMethods().clear();
        if (!this.allowedOrigins.contains("*") && !this.allowedOrigins.contains(origin)) {
            LOGGER.fine("Origin " + origin + " not allowed for CORS request");
            return;
        }
        boolean isPreflightRequest = Method.OPTIONS.equals(request.getMethod());
        if (isPreflightRequest) {
            if (!(Status.SUCCESS_OK.equals(response.getStatus()) || Status.SUCCESS_NO_CONTENT.equals(response.getStatus()) || Status.CLIENT_ERROR_METHOD_NOT_ALLOWED.equals(response.getStatus()))) {
                LOGGER.fine("The CORS preflight request failed in server resource.");
                return;
            }
            response.setStatus(Status.SUCCESS_OK);
            Method requestedMethod = request.getAccessControlRequestMethod();
            if (requestedMethod == null) {
                LOGGER.fine("A CORS preflight request should specified header 'Access-Control-Request-Method'");
                return;
            }
            if (!allowedMethods.contains(requestedMethod)) {
                LOGGER.fine("The CORS preflight request ask for methods not allowed in header 'Access-Control-Request-Method'");
                return;
            }
            Set<Object> requestedHeaders = request.getAccessControlRequestHeaders();
            if (requestedHeaders == null) {
                requestedHeaders = SetUtils.newHashSet(new Object[0]);
            }
            if (!(this.allowAllRequestedHeaders || this.allowedHeaders != null && this.isAllHeadersAllowed(this.allowedHeaders, requestedHeaders))) {
                LOGGER.fine("The CORS preflight request ask for headers not allowed in header 'Access-Control-Request-Headers'");
                return;
            }
            response.setAccessControlAllowMethods(allowedMethods);
            response.setAccessControlAllowHeaders(requestedHeaders);
            if (this.getMaxAge() > 0) {
                response.setAccessControlMaxAge(this.getMaxAge());
            }
        } else if (this.exposedHeaders != null && !this.exposedHeaders.isEmpty()) {
            response.setAccessControlExposeHeaders(this.exposedHeaders);
        }
        if (this.allowedCredentials) {
            response.setAccessControlAllowCredentials(true);
        }
        if (!this.allowedCredentials && this.allowedOrigins.contains("*")) {
            response.setAccessControlAllowOrigin("*");
        } else {
            response.setAccessControlAllowOrigin(origin);
        }
    }

    public Set<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    private boolean isAllHeadersAllowed(Set<String> allowHeaders, Set<String> requestedHeaders) {
        for (String requestedHeader : requestedHeaders) {
            boolean headerAllowed = false;
            for (String allowHeader : allowHeaders) {
                if (!allowHeader.equalsIgnoreCase(requestedHeader)) continue;
                headerAllowed = true;
                break;
            }
            if (headerAllowed) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowAllRequestedHeaders() {
        return this.allowAllRequestedHeaders;
    }

    public boolean isAllowedCredentials() {
        return this.allowedCredentials;
    }

    public boolean isCorsRequest(Request request) {
        return request.getHeaders().getFirstValue("Origin", true) != null;
    }

    public void setAllowAllRequestedHeaders(boolean allowAllRequestedHeaders) {
        this.allowAllRequestedHeaders = allowAllRequestedHeaders;
    }

    public void setAllowedCredentials(boolean allowedCredentials) {
        this.allowedCredentials = allowedCredentials;
    }

    public void setAllowedHeaders(Set<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public void setExposedHeaders(Set<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }
}

