/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Reference;
import org.restlet.engine.util.SystemUtils;

public final class ChallengeRequest
extends ChallengeMessage {
    private volatile List<String> qualityOptions = null;
    private volatile List<Reference> domainRefs = null;
    private volatile boolean stale = false;

    public ChallengeRequest(ChallengeScheme scheme) {
        this(scheme, (String)null);
    }

    public ChallengeRequest(ChallengeScheme scheme, String realm) {
        super(scheme, realm);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChallengeRequest)) {
            return false;
        }
        ChallengeRequest that = (ChallengeRequest)obj;
        return this.getParameters().equals(that.getParameters()) && Objects.equals(this.getRealm(), that.getRealm()) && Objects.equals(this.getScheme(), that.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getDomainRefs() {
        List<Reference> r = this.domainRefs;
        if (r == null) {
            ChallengeRequest challengeRequest = this;
            synchronized (challengeRequest) {
                r = this.domainRefs;
                if (r == null) {
                    this.domainRefs = r = new CopyOnWriteArrayList<Reference>();
                    this.domainRefs.add(new Reference("/"));
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getQualityOptions() {
        List<String> r = this.qualityOptions;
        if (r == null) {
            ChallengeRequest challengeRequest = this;
            synchronized (challengeRequest) {
                r = this.qualityOptions;
                if (r == null) {
                    this.qualityOptions = r = new CopyOnWriteArrayList<String>();
                    this.qualityOptions.add("auth");
                }
            }
        }
        return r;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.qualityOptions, this.domainRefs, this.stale);
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setDomainRefs(List<Reference> domainRefs) {
        this.domainRefs = domainRefs;
    }

    public void setDomainUris(Collection<String> domainUris) {
        CopyOnWriteArrayList<Reference> domainRefs = null;
        if (domainUris != null) {
            domainRefs = new CopyOnWriteArrayList<Reference>();
            for (String domainUri : domainUris) {
                domainRefs.add(new Reference(domainUri));
            }
        }
        this.setDomainRefs(domainRefs);
    }

    public void setQualityOptions(List<String> qualityOptions) {
        this.qualityOptions = qualityOptions;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }
}

