/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.constants.InstanceConstants;
import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.examples.DummyParticipant;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.StateModelConfigGenerator;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;

public class IdealStateExample {
    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("USAGE: IdealStateExample zkAddress clusterName idealStateMode (FULL_AUTO, SEMI_AUTO, or CUSTOMIZED) idealStateJsonFile (required for CUSTOMIZED mode)");
            System.exit(1);
        }
        final String zkAddr = args[0];
        final String clusterName = args[1];
        String idealStateRebalancerModeStr = args[2].toUpperCase();
        String idealStateJsonFile = null;
        IdealState.RebalanceMode idealStateRebalancerMode = IdealState.RebalanceMode.valueOf(idealStateRebalancerModeStr);
        if (idealStateRebalancerMode == IdealState.RebalanceMode.CUSTOMIZED) {
            if (args.length < 4) {
                System.err.println("Missng idealStateJsonFile for CUSTOMIZED ideal state mode");
                System.exit(1);
            }
            idealStateJsonFile = args[3];
        }
        HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
        clientConfig.setZkSerializer(new ZNRecordSerializer());
        HelixZkClient zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(zkAddr), clientConfig);
        ZKHelixAdmin admin = new ZKHelixAdmin(zkClient);
        admin.addCluster(clusterName, true);
        StateModelConfigGenerator generator = new StateModelConfigGenerator();
        admin.addStateModelDef(clusterName, "MasterSlave", new StateModelDefinition(generator.generateConfigForMasterSlave()));
        for (int i = 0; i < 3; ++i) {
            int port = 12918 + i;
            InstanceConfig config = new InstanceConfig("localhost_" + port);
            config.setHostName("localhost");
            config.setPort(Integer.toString(port));
            config.setInstanceOperation(InstanceConstants.InstanceOperation.ENABLE);
            admin.addInstance(clusterName, config);
        }
        String resourceName = "TestDB";
        if (idealStateRebalancerMode == IdealState.RebalanceMode.SEMI_AUTO || idealStateRebalancerMode == IdealState.RebalanceMode.FULL_AUTO) {
            admin.addResource(clusterName, resourceName, 4, "MasterSlave", idealStateRebalancerModeStr);
            admin.rebalance(clusterName, resourceName, 3);
        } else if (idealStateRebalancerMode == IdealState.RebalanceMode.CUSTOMIZED) {
            admin.addIdealState(clusterName, resourceName, idealStateJsonFile);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HelixControllerMain.main(new String[]{"--zkSvr", zkAddr, "--cluster", clusterName});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        for (int i = 0; i < 3; ++i) {
            int port = 12918 + i;
            final String instanceName = "localhost_" + port;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DummyParticipant.main(new String[]{zkAddr, clusterName, instanceName});
                }
            }).start();
        }
    }
}

