/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.constraint.MonitoredAbnormalResolver;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRebalancer<T extends BaseControllerDataProvider>
implements Rebalancer<T>,
MappingCalculator<T> {
    protected HelixManager _manager;
    protected RebalanceStrategy<T> _rebalanceStrategy;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRebalancer.class);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
        this._rebalanceStrategy = null;
    }

    @Override
    public abstract IdealState computeNewIdealState(String var1, IdealState var2, CurrentStateOutput var3, T var4);

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(T cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing resource:" + resource.getResourceName());
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = ((BaseControllerDataProvider)cache).getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Set<String> disabledInstancesForPartition = ((BaseControllerDataProvider)cache).getDisabledInstancesForPartition(resource.getResourceName(), partition.toString());
            List<String> preferenceList = AbstractRebalancer.getPreferenceList(partition, idealState, Collections.unmodifiableSet(((BaseControllerDataProvider)cache).getAssignableLiveInstances().keySet()));
            Map<String, String> bestStateForPartition = this.computeBestPossibleStateForPartition(((BaseControllerDataProvider)cache).getLiveInstances().keySet(), stateModelDef, preferenceList, currentStateOutput, disabledInstancesForPartition, idealState, ((BaseControllerDataProvider)cache).getClusterConfig(), partition, ((BaseControllerDataProvider)cache).getAbnormalStateResolver(stateModelDefName), cache);
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }

    protected IdealState getCachedIdealState(String resourceName, ResourceControllerDataProvider clusterData) {
        ZNRecord cachedIdealMapping = clusterData.getCachedIdealMapping(resourceName);
        if (cachedIdealMapping != null) {
            return new IdealState(cachedIdealMapping);
        }
        return null;
    }

    protected Map<String, Map<String, String>> currentMapping(CurrentStateOutput currentStateOutput, String resourceName, List<String> partitions, Map<String, Integer> stateCountMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String partition : partitions) {
            Map<String, String> curStateMap = currentStateOutput.getCurrentStateMap(resourceName, new Partition(partition));
            map.put(partition, new HashMap());
            for (String node : curStateMap.keySet()) {
                String state = curStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
            Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, new Partition(partition));
            for (String node : pendingStateMap.keySet()) {
                String state = pendingStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
        }
        return map;
    }

    protected RebalanceStrategy<T> getRebalanceStrategy(String rebalanceStrategyName, List<String> partitions, String resourceName, LinkedHashMap<String, Integer> stateCountMap, int maxPartition) {
        RebalanceStrategy<ResourceControllerDataProvider> rebalanceStrategy;
        if (rebalanceStrategyName == null || rebalanceStrategyName.equalsIgnoreCase("DEFAULT")) {
            rebalanceStrategy = new AutoRebalanceStrategy(resourceName, partitions, stateCountMap, maxPartition);
        } else {
            try {
                rebalanceStrategy = (RebalanceStrategy)RebalanceStrategy.class.cast(HelixUtil.loadClass(this.getClass(), rebalanceStrategyName).newInstance());
                rebalanceStrategy.init(resourceName, partitions, stateCountMap, maxPartition);
            }
            catch (ClassNotFoundException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
            catch (InstantiationException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
            catch (IllegalAccessException ex) {
                throw new HelixException("Exception while invoking custom rebalance strategy class: " + rebalanceStrategyName, ex);
            }
        }
        return rebalanceStrategy;
    }

    protected Map<String, String> computeBestPossibleStateForPartition(Set<String> liveInstances, StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, Set<String> disabledInstancesForPartition, IdealState idealState, ClusterConfig clusterConfig, Partition partition, MonitoredAbnormalResolver monitoredResolver) {
        return this.computeBestPossibleStateForPartition(liveInstances, stateModelDef, preferenceList, currentStateOutput, disabledInstancesForPartition, idealState, clusterConfig, partition, monitoredResolver, null);
    }

    protected Map<String, String> computeBestPossibleStateForPartition(Set<String> liveInstances, StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, Set<String> disabledInstancesForPartition, IdealState idealState, ClusterConfig clusterConfig, Partition partition, MonitoredAbnormalResolver monitoredResolver, T cache) {
        Optional<Map<String, String>> optionalOverwrittenStates = this.computeStatesOverwriteForPartition(stateModelDef, preferenceList, currentStateOutput, idealState, partition, monitoredResolver);
        if (optionalOverwrittenStates.isPresent()) {
            return optionalOverwrittenStates.get();
        }
        HashMap<String, String> currentStateMap = new HashMap<String, String>(currentStateOutput.getCurrentStateMap(idealState.getResourceName(), partition));
        return this.computeBestPossibleMap(preferenceList, stateModelDef, currentStateMap, liveInstances, disabledInstancesForPartition);
    }

    protected Optional<Map<String, String>> computeStatesOverwriteForPartition(StateModelDefinition stateModelDef, List<String> preferenceList, CurrentStateOutput currentStateOutput, IdealState idealState, Partition partition, MonitoredAbnormalResolver monitoredResolver) {
        String resourceName = idealState.getResourceName();
        Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
        if (preferenceList == null) {
            return Optional.of(this.computeBestPossibleMapForDroppedResource(currentStateMap));
        }
        if (!idealState.isEnabled()) {
            return Optional.of(this.computeBestPossibleMapForDisabledResource(currentStateMap, stateModelDef));
        }
        if (!monitoredResolver.checkCurrentStates(currentStateOutput, resourceName, partition, stateModelDef)) {
            monitoredResolver.recordAbnormalState();
            Map<String, String> recoveryAssignment = monitoredResolver.computeRecoveryAssignment(currentStateOutput, resourceName, partition, stateModelDef, preferenceList);
            if (recoveryAssignment == null || !recoveryAssignment.keySet().equals(currentStateMap.keySet())) {
                throw new HelixException(String.format("Invalid recovery assignment %s since it changed the current partition placement %s", recoveryAssignment, currentStateMap));
            }
            monitoredResolver.recordRecoveryAttempt();
            return Optional.of(recoveryAssignment);
        }
        return Optional.empty();
    }

    protected Map<String, String> computeBestPossibleMapForDroppedResource(Map<String, String> currentStateMap) {
        HashMap<String, String> bestPossibleStateMap = new HashMap<String, String>();
        for (String instance : currentStateMap.keySet()) {
            bestPossibleStateMap.put(instance, HelixDefinedState.DROPPED.toString());
        }
        return bestPossibleStateMap;
    }

    protected Map<String, String> computeBestPossibleMapForDisabledResource(Map<String, String> currentStateMap, StateModelDefinition stateModelDef) {
        HashMap<String, String> bestPossibleStateMap = new HashMap<String, String>();
        for (String instance : currentStateMap.keySet()) {
            if (HelixDefinedState.ERROR.name().equals(currentStateMap.get(instance))) continue;
            bestPossibleStateMap.put(instance, stateModelDef.getInitialState());
        }
        return bestPossibleStateMap;
    }

    public static List<String> getPreferenceList(Partition partition, IdealState idealState, Set<String> eligibleInstances) {
        List<String> listField = idealState.getPreferenceList(partition.getPartitionName());
        if (listField != null && listField.size() == 1 && IdealState.IdealStateConstants.ANY_LIVEINSTANCE.toString().equals(listField.get(0))) {
            ArrayList<String> prefList = new ArrayList<String>(eligibleInstances);
            Collections.sort(prefList);
            return prefList;
        }
        return listField;
    }

    public static int getStateCount(String state, StateModelDefinition stateModelDef, int liveAndEnabledSize, int preferenceListSize) {
        String num = stateModelDef.getNumInstancesPerState(state);
        int stateCount = -1;
        if ("N".equals(num)) {
            stateCount = liveAndEnabledSize;
        } else if ("R".equals(num)) {
            stateCount = preferenceListSize;
        } else {
            try {
                stateCount = Integer.parseInt(num);
            }
            catch (Exception e) {
                LOG.error("Invalid count for state:" + state + " ,count=" + num);
            }
        }
        return stateCount;
    }

    protected Map<String, String> computeBestPossibleMap(List<String> preferenceList, StateModelDefinition stateModelDef, Map<String, String> currentStateMap, Set<String> liveInstances, Set<String> disabledInstancesForPartition) {
        HashMap<String, String> bestPossibleStateMap = new HashMap<String, String>();
        for (String instance : currentStateMap.keySet()) {
            if (preferenceList.contains(instance)) continue;
            bestPossibleStateMap.put(instance, HelixDefinedState.DROPPED.name());
        }
        for (String instance : preferenceList) {
            if (!disabledInstancesForPartition.contains(instance)) continue;
            if (currentStateMap.containsKey(instance)) {
                if (currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name())) {
                    bestPossibleStateMap.put(instance, HelixDefinedState.ERROR.name());
                    continue;
                }
                bestPossibleStateMap.put(instance, stateModelDef.getInitialState());
                continue;
            }
            if (!liveInstances.contains(instance)) continue;
            bestPossibleStateMap.put(instance, stateModelDef.getInitialState());
        }
        this.assignStatesToInstances(preferenceList, stateModelDef, currentStateMap, liveInstances, disabledInstancesForPartition, bestPossibleStateMap);
        return bestPossibleStateMap;
    }

    private void assignStatesToInstances(List<String> preferenceList, StateModelDefinition stateModelDef, Map<String, String> currentStateMap, Set<String> liveInstances, Set<String> disabledInstancesForPartition, Map<String, String> bestPossibleStateMap) {
        HashSet<String> assignedInstances = new HashSet<String>();
        Set liveAndEnabled = liveInstances.stream().filter(instance -> !disabledInstancesForPartition.contains(instance)).collect(Collectors.toSet());
        LinkedList<String> preferredActiveInstanceQueue = new LinkedList<String>(preferenceList);
        preferredActiveInstanceQueue.retainAll(liveAndEnabled);
        int totalCandidateCount = preferredActiveInstanceQueue.size();
        ArrayList<String> currentStatePrioritizedList = new ArrayList<String>(preferredActiveInstanceQueue);
        currentStatePrioritizedList.sort(new StatePriorityComparator(currentStateMap, stateModelDef));
        Iterator<String> currentStatePrioritizedInstanceIter = currentStatePrioritizedList.iterator();
        for (String state : stateModelDef.getStatesPriorityList()) {
            int stateCount = AbstractRebalancer.getStateCount(state, stateModelDef, liveAndEnabled.size(), preferenceList.size());
            while (!preferredActiveInstanceQueue.isEmpty() && stateCount > 0) {
                String peekInstance = (String)preferredActiveInstanceQueue.peek();
                if (assignedInstances.contains(peekInstance)) {
                    preferredActiveInstanceQueue.poll();
                    continue;
                }
                String proposedInstance = this.adjustInstanceIfNecessary(state, peekInstance, currentStateMap.getOrDefault(peekInstance, stateModelDef.getInitialState()), stateModelDef, assignedInstances, totalCandidateCount - assignedInstances.size(), stateCount, currentStatePrioritizedInstanceIter);
                if (proposedInstance.equals(peekInstance)) {
                    preferredActiveInstanceQueue.poll();
                }
                if (HelixDefinedState.ERROR.toString().equals(currentStateMap.get(proposedInstance))) {
                    bestPossibleStateMap.put(proposedInstance, HelixDefinedState.ERROR.toString());
                } else {
                    bestPossibleStateMap.put(proposedInstance, state);
                    --stateCount;
                }
                if (!assignedInstances.add(proposedInstance)) {
                    throw new AssertionError((Object)String.format("The proposed instance %s has been already assigned before.", proposedInstance));
                }
            }
        }
    }

    private String adjustInstanceIfNecessary(String requestedState, String proposedInstance, String currentState, StateModelDefinition stateModelDef, Set<String> assignedInstances, int remainCandidateCount, int remainRequestCount, Iterator<String> currentStatePrioritizedInstanceIter) {
        String adjustedInstance = proposedInstance;
        if (remainRequestCount < remainCandidateCount && requestedState.equals(stateModelDef.getTopState()) && !requestedState.equals(currentState) && !stateModelDef.getSecondTopStates().contains(currentState)) {
            while (currentStatePrioritizedInstanceIter.hasNext()) {
                String currentStatePrioritizedInstance = currentStatePrioritizedInstanceIter.next();
                if (assignedInstances.contains(currentStatePrioritizedInstance)) continue;
                adjustedInstance = currentStatePrioritizedInstance;
                break;
            }
        }
        return adjustedInstance;
    }

    protected List<String> getStablePartitionList(ResourceControllerDataProvider clusterData, IdealState currentIdealState) {
        List<String> partitions = clusterData.getStablePartitionList(currentIdealState.getResourceName());
        if (partitions == null) {
            Set<String> currentPartitionSet = currentIdealState.getPartitionSet();
            LOG.warn("The current partition set {} has not been cached in the stable partition list. Use the IdealState partition set directly.", (Object)currentPartitionSet.toString());
            partitions = new ArrayList<String>(currentPartitionSet);
        }
        return partitions;
    }

    protected static class PreferenceListNodeComparator
    implements Comparator<String> {
        protected final Map<String, String> _currentStateMap;
        protected final StateModelDefinition _stateModelDef;
        protected final List<String> _preferenceList;

        public PreferenceListNodeComparator(Map<String, String> currentStateMap, StateModelDefinition stateModelDef, List<String> preferenceList) {
            this._currentStateMap = currentStateMap;
            this._stateModelDef = stateModelDef;
            this._preferenceList = preferenceList;
        }

        @Override
        public int compare(String ins1, String ins2) {
            if (this._preferenceList.contains(ins1) && this._preferenceList.contains(ins2)) {
                return this._preferenceList.indexOf(ins1) - this._preferenceList.indexOf(ins2);
            }
            if (this._preferenceList.contains(ins1)) {
                return -1;
            }
            if (this._preferenceList.contains(ins2)) {
                return 1;
            }
            Integer p1 = Integer.MAX_VALUE;
            Integer p2 = Integer.MAX_VALUE;
            Map<String, Integer> statesPriorityMap = this._stateModelDef.getStatePriorityMap();
            String state1 = this._currentStateMap.get(ins1);
            String state2 = this._currentStateMap.get(ins2);
            if (state1 != null && statesPriorityMap.containsKey(state1)) {
                p1 = statesPriorityMap.get(state1);
            }
            if (state2 != null && statesPriorityMap.containsKey(state2)) {
                p2 = statesPriorityMap.get(state2);
            }
            return p1.compareTo(p2);
        }
    }

    protected static class StatePriorityComparator
    implements Comparator<String> {
        private final Map<String, String> _currentStateMap;
        private final StateModelDefinition _stateModelDef;

        public StatePriorityComparator(Map<String, String> currentStateMap, StateModelDefinition stateModelDef) {
            this._currentStateMap = currentStateMap;
            this._stateModelDef = stateModelDef;
        }

        @Override
        public int compare(String ins1, String ins2) {
            String state1 = this._currentStateMap.get(ins1);
            String state2 = this._currentStateMap.get(ins2);
            int p1 = state1 == null ? Integer.MAX_VALUE : this._stateModelDef.getStatePriorityMap().get(state1);
            int p2 = state2 == null ? Integer.MAX_VALUE : this._stateModelDef.getStatePriorityMap().get(state2);
            return p1 - p2;
        }
    }
}

