/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Set;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FaultZoneAwareConstraint
extends HardConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(FaultZoneAwareConstraint.class);

    FaultZoneAwareConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        if (!node.hasFaultZone()) {
            return true;
        }
        Set<String> partitionsForResourceAndFaultZone = clusterContext.getPartitionsForResourceAndFaultZone(replica.getResourceName(), node.getFaultZone());
        if (partitionsForResourceAndFaultZone.contains(replica.getPartitionName())) {
            LOG.debug("A fault zone cannot contain more than 1 replica of same partition. Found replica for partition: {}", (Object)replica.getPartitionName());
            return false;
        }
        return true;
    }

    @Override
    String getDescription() {
        return "A fault zone cannot contain more than 1 replica of same partition";
    }
}

