/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.helix.PropertyType;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.spectator.CustomizedViewRoutingTable;
import org.apache.helix.spectator.RoutingTable;

public class RoutingTableSnapshot {
    private final RoutingTable _routingTable;
    private final PropertyType _propertyType;
    private final String _stateType;

    public RoutingTableSnapshot(RoutingTable routingTable) {
        this._routingTable = routingTable;
        this._propertyType = routingTable.getPropertyType();
        this._stateType = routingTable.getStateType();
    }

    public Set<InstanceConfig> getInstancesForResource(String resourceName, String state) {
        return this._routingTable.getInstancesForResource(resourceName, state);
    }

    public List<InstanceConfig> getInstancesForResource(String resourceName, String partitionName, String state) {
        return this._routingTable.getInstancesForResource(resourceName, partitionName, state);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state, List<String> resourceTags) {
        return this._routingTable.getInstancesForResourceGroup(resourceGroupName, state, resourceTags);
    }

    public Set<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String state) {
        return this._routingTable.getInstancesForResourceGroup(resourceGroupName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state) {
        return this._routingTable.getInstancesForResourceGroup(resourceGroupName, partitionName, state);
    }

    public List<InstanceConfig> getInstancesForResourceGroup(String resourceGroupName, String partitionName, String state, List<String> resourceTags) {
        return this._routingTable.getInstancesForResourceGroup(resourceGroupName, partitionName, state, resourceTags);
    }

    public Collection<LiveInstance> getLiveInstances() {
        return this._routingTable.getLiveInstances();
    }

    public Collection<InstanceConfig> getInstanceConfigs() {
        return this._routingTable.getInstanceConfigs();
    }

    public Collection<String> getResources() {
        return this._routingTable.getResources();
    }

    public Collection<ExternalView> getExternalViews() {
        return this._routingTable.getExternalViews();
    }

    public Collection<CustomizedView> getCustomizeViews() {
        if (this._propertyType.equals((Object)PropertyType.CUSTOMIZEDVIEW)) {
            CustomizedViewRoutingTable customizedViewRoutingTable = (CustomizedViewRoutingTable)this._routingTable;
            return customizedViewRoutingTable.geCustomizedViews();
        }
        return Collections.emptySet();
    }

    public PropertyType getPropertyType() {
        return this._propertyType;
    }

    public String getCustomizedStateType() {
        return this._stateType;
    }
}

