/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.AssignableInstanceManager;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskAssignmentCalculator;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.task.assigner.TaskAssignResult;
import org.apache.helix.task.assigner.TaskAssigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadCountBasedTaskAssignmentCalculator
extends TaskAssignmentCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadCountBasedTaskAssignmentCalculator.class);
    private TaskAssigner _taskAssigner;
    private AssignableInstanceManager _assignableInstanceManager;

    public ThreadCountBasedTaskAssignmentCalculator(TaskAssigner taskAssigner, AssignableInstanceManager assignableInstanceManager) {
        this._taskAssigner = taskAssigner;
        this._assignableInstanceManager = assignableInstanceManager;
    }

    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Map<String, IdealState> idealStateMap) {
        return this.getAllTaskPartitionsDefault(jobCfg, jobCtx);
    }

    @Override
    @Deprecated
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        return this.getTaskAssignment(currStateOutput, instances, jobCfg, jobContext, workflowCfg, workflowCtx, partitionSet, idealStateMap);
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, Map<String, IdealState> idealStateMap) {
        if (jobCfg.getTargetResource() != null) {
            LOG.error("Target resource is not null, should call FixedTaskAssignmentCalculator, target resource : {}", (Object)jobCfg.getTargetResource());
            return new HashMap<String, SortedSet<Integer>>();
        }
        Iterable<TaskConfig> taskConfigs = this.getFilteredTaskConfigs(partitionSet, jobCfg, jobContext);
        String quotaType = ThreadCountBasedTaskAssignmentCalculator.getQuotaType(workflowCfg, jobCfg);
        Map<String, TaskAssignResult> taskAssignResultMap = this._taskAssigner.assignTasks(this._assignableInstanceManager, instances, taskConfigs, quotaType);
        Map<String, Integer> taskIdPartitionMap = jobContext.getTaskIdPartitionMap();
        HashMap<String, SortedSet<Integer>> taskAssignment = new HashMap<String, SortedSet<Integer>>();
        for (Map.Entry<String, TaskAssignResult> assignResultEntry : taskAssignResultMap.entrySet()) {
            TaskAssignResult taskAssignResult = assignResultEntry.getValue();
            if (!taskAssignResult.isSuccessful()) continue;
            String instanceName = taskAssignResult.getInstanceName();
            String taskId = taskAssignResult.getTaskConfig().getId();
            if (!taskIdPartitionMap.containsKey(taskId)) {
                LOG.warn("Task is not found in taskIdPartitionMap. Skipping this task! JobID: {}, TaskID: {}", (Object)jobCfg.getJobId(), (Object)taskId);
                continue;
            }
            int partitionNumberForTask = taskIdPartitionMap.get(taskId);
            if (!taskAssignment.containsKey(instanceName)) {
                taskAssignment.put(instanceName, new TreeSet());
            }
            ((SortedSet)taskAssignment.get(instanceName)).add(partitionNumberForTask);
        }
        return taskAssignment;
    }

    private Iterable<TaskConfig> getFilteredTaskConfigs(Set<Integer> filteredPartitionNumbers, JobConfig jobConfig, JobContext jobContext) {
        HashSet<TaskConfig> filteredTaskConfigs = new HashSet<TaskConfig>();
        for (int partitionNumber : filteredPartitionNumbers) {
            String taskId = jobContext.getTaskIdForPartition(partitionNumber);
            TaskConfig taskConfig = jobConfig.getTaskConfig(taskId);
            filteredTaskConfigs.add(taskConfig);
        }
        return filteredTaskConfigs;
    }
}

