ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(T,b,D){"use strict";var U=T("./lib/dom"),V=T("./lib/oop"),z=T("./lib/event_emitter").EventEmitter,O=T("./lib/lang"),w=T("./range").Range,S=T("./range_list").RangeList,k=T("./keyboard/hash_handler").HashHandler,I=T("./tokenizer").Tokenizer,N=T("./clipboard"),R={CURRENT_WORD:function(a){return a.session.getTextRange(a.session.getWordRange())},SELECTION:function(a,e,t){var r=a.session.getTextRange();return t?r.replace(/\n\r?([ \t]*\S)/g,"\n"+t+"$1"):r},CURRENT_LINE:function(a){return a.session.getLine(a.getCursorPosition().row)},PREV_LINE:function(a){return a.session.getLine(a.getCursorPosition().row-1)},LINE_INDEX:function(a){return a.getCursorPosition().row},LINE_NUMBER:function(a){return a.getCursorPosition().row+1},SOFT_TABS:function(a){return a.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(a){return a.session.getTabSize()},CLIPBOARD:function(a){return N.getText&&N.getText()},FILENAME:function(a){return/[^/\\]*$/.exec(this.FILEPATH(a))[0]},FILENAME_BASE:function(a){return/[^/\\]*$/.exec(this.FILEPATH(a))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(a){return this.FILEPATH(a).replace(/[^/\\]*$/,"")},FILEPATH:function(a){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(a){var e=a.session.$mode||{};return e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(a){var e=a.session.$mode||{};return e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(a){return(a.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:E.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:E.bind(null,{year:"2-digit"}),CURRENT_MONTH:E.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:E.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:E.bind(null,{month:"short"}),CURRENT_DATE:E.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:E.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:E.bind(null,{weekday:"short"}),CURRENT_HOUR:E.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:E.bind(null,{minute:"2-digit"}),CURRENT_SECOND:E.bind(null,{second:"2-digit"})};function E(a){var e=(new Date).toLocaleString("en-us",a);return 1==e.length?"0"+e:e}R.SELECTED_TEXT=R.SELECTION;var A=function(){function a(){this.snippetMap={},this.snippetNameMap={},this.variables=R}return a.prototype.getTokenizer=function(){return a.$tokenizer||this.createTokenizer()},a.prototype.createTokenizer=function(){function e(i){return i=i.substr(1),/^\d+$/.test(i)?[{tabstopId:parseInt(i,10)}]:[{text:i}]}function t(i){return"(?:[^\\\\"+i+"]|\\\\.)"}var r={regex:"/("+t("/")+"+)/",onMatch:function(i,s,c){var n=c[0];return n.fmtString=!0,n.guard=i.slice(1,-1),n.flag="",""},next:"formatString"};return a.$tokenizer=new I({start:[{regex:/\\./,onMatch:function(i,s,c){var n=i[1];return("}"==n&&c.length||-1!="`$\\".indexOf(n))&&(i=n),[i]}},{regex:/}/,onMatch:function(i,s,c){return[c.length?c.shift():i]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(i,s,c){var n=e(i.substr(1));return c.unshift(n[0]),n},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(i,s,c){var n=i.slice(1,-1).replace(/\\[,|\\]|,/g,function(u){return 2==u.length?u[1]:"\0"}).split("\0").map(function(u){return{value:u}});return c[0].choices=n,[n[0]]},next:"start"},r,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(i,s,c){return c.length&&c[0].expectElse?(c[0].expectElse=!1,c[0].ifEnd={elseEnd:c[0]},[c[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(i,s,c){var n=i[1];return"}"==n&&c.length||-1!="`$\\".indexOf(n)?i=n:"n"==n?i="\n":"t"==n?i="\t":-1!="ulULE".indexOf(n)&&(i={changeCase:n,local:n>"a"}),[i]}},{regex:"/\\w*}",onMatch:function(i,s,c){var n=c.shift();return n&&(n.flag=i.slice(1,-1)),this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(i,s,c){return[{text:i.slice(1)}]}},{regex:/\${\w+/,onMatch:function(i,s,c){var n={text:i.slice(2)};return c.unshift(n),[n]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(i,s,c){var n=c.shift();return this.next=n&&n.tabstopId?"start":"",[n||i]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(i,s,c){return c[0].formatFunction=i.slice(2,-1),[c.shift()]},next:"formatString"},r,{regex:/:[\?\-+]?/,onMatch:function(i,s,c){"+"==i[1]&&(c[0].ifEnd=c[0]),"?"==i[1]&&(c[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},a.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(r){return r.value||r})},a.prototype.getVariableValue=function(e,t,r){if(/^\d+$/.test(t))return(this.variables.__||{})[t]||"";if(/^[A-Z]\d+$/.test(t))return(this.variables[t[0]+"__"]||{})[t.substr(1)]||"";if(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t))return"";var i=this.variables[t];return"function"==typeof i&&(i=this.variables[t](e,t,r)),null==i?"":i},a.prototype.tmStrFormat=function(e,t,r){if(!t.fmt)return e;var s=t.guard;s=new RegExp(s,(t.flag||"").replace(/[^gim]/g,""));var c="string"==typeof t.fmt?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,n=this,u=e.replace(s,function(){var o=n.variables.__;n.variables.__=[].slice.call(arguments);for(var d=n.resolveVariables(c,r),p="E",m=0;m<d.length;m++){var y=d[m];if("object"==typeof y)if(d[m]="",y.changeCase&&y.local){var x=d[m+1];x&&"string"==typeof x&&(d[m]="u"==y.changeCase?x[0].toUpperCase():x[0].toLowerCase(),d[m+1]=x.substr(1))}else y.changeCase&&(p=y.changeCase);else"U"==p?d[m]=y.toUpperCase():"L"==p&&(d[m]=y.toLowerCase())}return n.variables.__=o,d.join("")});return u},a.prototype.tmFormatFunction=function(e,t,r){return"upcase"==t.formatFunction?e.toUpperCase():"downcase"==t.formatFunction?e.toLowerCase():e},a.prototype.resolveVariables=function(e,t){for(var r=[],i="",s=!0,c=0;c<e.length;c++){var n=e[c];if("string"!=typeof n){if(n){if(s=!1,n.fmtString){var u=e.indexOf(n,c+1);-1==u&&(u=e.length),n.fmt=e.slice(c+1,u),c=u}if(n.text){var o=this.getVariableValue(t,n.text,i)+"";n.fmtString&&(o=this.tmStrFormat(o,n,t)),n.formatFunction&&(o=this.tmFormatFunction(o,n,t)),o&&!n.ifEnd?(r.push(o),d(n)):!o&&n.ifEnd&&d(n.ifEnd)}else n.elseEnd?d(n.elseEnd):(null!=n.tabstopId||null!=n.changeCase)&&r.push(n)}}else r.push(n),"\n"==n?(s=!0,i=""):s&&(i=/^\t*/.exec(n)[0],s=/\S/.test(n))}function d(p){var m=e.indexOf(p,c+1);-1!=m&&(c=m)}return r},a.prototype.getDisplayTextForSnippet=function(e,t){return l.call(this,e,t).text},a.prototype.insertSnippetForSelection=function(e,t,r){void 0===r&&(r={});var i=l.call(this,e,t,r),s=e.getSelectionRange();r.range&&0===r.range.compareRange(s)&&(s=r.range);var c=e.session.replace(s,i.text);new f(e).addTabstops(i.tabstops,s.start,c,e.inVirtualSelectionMode&&e.selection.index)},a.prototype.insertSnippet=function(e,t,r){void 0===r&&(r={});var i=this;if(r.range&&!(r.range instanceof w)&&(r.range=w.fromPoints(r.range.start,r.range.end)),e.inVirtualSelectionMode)return i.insertSnippetForSelection(e,t,r);e.forEachSelection(function(){i.insertSnippetForSelection(e,t,r)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},a.prototype.$getScope=function(e){var t=e.session.$mode.$id||"";if("html"===(t=t.split("/").pop())||"php"===t){"php"===t&&!e.session.$mode.inlinePhp&&(t="html");var r=e.getCursorPosition(),i=e.session.getState(r.row);"object"==typeof i&&(i=i[0]),i.substring&&("js-"==i.substring(0,3)?t="javascript":"css-"==i.substring(0,4)?t="css":"php-"==i.substring(0,4)&&(t="php"))}return t},a.prototype.getActiveScopes=function(e){var t=this.$getScope(e),r=[t],i=this.snippetMap;return i[t]&&i[t].includeScopes&&r.push.apply(r,i[t].includeScopes),r.push("_"),r},a.prototype.expandWithTab=function(e,t){var r=this,i=e.forEachSelection(function(){return r.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return i&&e.tabstopManager&&e.tabstopManager.tabNext(),i},a.prototype.expandSnippetForSelection=function(e,t){var u,r=e.getCursorPosition(),i=e.session.getLine(r.row),s=i.substring(0,r.column),c=i.substr(r.column),n=this.snippetMap;return this.getActiveScopes(e).some(function(o){var d=n[o];return d&&(u=this.findMatchingSnippet(d,s,c)),!!u},this),!!u&&(t&&t.dryRun||(e.session.doc.removeInLine(r.row,r.column-u.replaceBefore.length,r.column+u.replaceAfter.length),this.variables.M__=u.matchBefore,this.variables.T__=u.matchAfter,this.insertSnippetForSelection(e,u.content),this.variables.M__=this.variables.T__=null),!0)},a.prototype.findMatchingSnippet=function(e,t,r){for(var i=e.length;i--;){var s=e[i];if((!s.startRe||s.startRe.test(t))&&(!s.endRe||s.endRe.test(r))&&(s.startRe||s.endRe))return s.matchBefore=s.startRe?s.startRe.exec(t):[""],s.matchAfter=s.endRe?s.endRe.exec(r):[""],s.replaceBefore=s.triggerRe?s.triggerRe.exec(t)[0]:"",s.replaceAfter=s.endTriggerRe?s.endTriggerRe.exec(r)[0]:"",s}},a.prototype.register=function(e,t){var r=this.snippetMap,i=this.snippetNameMap,s=this;function c(o){return o&&!/^\^?\(.*\)\$?$|^\\b$/.test(o)&&(o="(?:"+o+")"),o||""}function n(o,d,p){return o=c(o),d=c(d),p?(o=d+o)&&"$"!=o[o.length-1]&&(o+="$"):(o+=d)&&"^"!=o[0]&&(o="^"+o),new RegExp(o)}function u(o){o.scope||(o.scope=t||"_"),r[t=o.scope]||(r[t]=[],i[t]={});var d=i[t];if(o.name){var p=d[o.name];p&&s.unregister(p),d[o.name]=o}r[t].push(o),o.prefix&&(o.tabTrigger=o.prefix),!o.content&&o.body&&(o.content=Array.isArray(o.body)?o.body.join("\n"):o.body),o.tabTrigger&&!o.trigger&&(!o.guard&&/^\w/.test(o.tabTrigger)&&(o.guard="\\b"),o.trigger=O.escapeRegExp(o.tabTrigger)),(o.trigger||o.guard||o.endTrigger||o.endGuard)&&(o.startRe=n(o.trigger,o.guard,!0),o.triggerRe=new RegExp(o.trigger),o.endRe=n(o.endTrigger,o.endGuard,!0),o.endTriggerRe=new RegExp(o.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(u):Object.keys(e).forEach(function(o){u(e[o])}),this._signal("registerSnippets",{scope:t})},a.prototype.unregister=function(e,t){var r=this.snippetMap,i=this.snippetNameMap;function s(c){var n=i[c.scope||t];if(n&&n[c.name]){delete n[c.name];var u=r[c.scope||t],o=u&&u.indexOf(c);o>=0&&u.splice(o,1)}}e.content?s(e):Array.isArray(e)&&e.forEach(s)},a.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var s,t=[],r={},i=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;s=i.exec(e);){if(s[1])try{r=JSON.parse(s[1]),t.push(r)}catch(o){}if(s[4])r.content=s[4].replace(/^\t/gm,""),t.push(r),r={};else{var c=s[2],n=s[3];if("regex"==c){var u=/\/((?:[^\/\\]|\\.)*)|$/g;r.guard=u.exec(n)[1],r.trigger=u.exec(n)[1],r.endTrigger=u.exec(n)[1],r.endGuard=u.exec(n)[1]}else"snippet"==c?(r.tabTrigger=n.match(/^\S*/)[0],r.name||(r.name=n)):c&&(r[c]=n)}}return t},a.prototype.getSnippetByName=function(e,t){var i,r=this.snippetNameMap;return this.getActiveScopes(t).some(function(s){var c=r[s];return c&&(i=c[e]),!!i},this),i},a}();V.implement(A.prototype,z);var l=function(a,e,t){void 0===t&&(t={});var r=a.getCursorPosition(),i=a.session.getLine(r.row),s=a.session.getTabString(),c=i.match(/^\s*/)[0];r.column<c.length&&(c=c.slice(0,r.column)),e=e.replace(/\r/g,"");var n=this.tokenizeTmSnippet(e);n=(n=this.resolveVariables(n,a)).map(function(v){return"\n"!=v||t.excludeExtraIndent?"string"==typeof v?v.replace(/\t/g,s):v:v+c});var u=[];n.forEach(function(v,C){if("object"==typeof v){var $=v.tabstopId,_=u[$];if(_||((_=u[$]=[]).index=$,_.value="",_.parents={}),-1===_.indexOf(v)){v.choices&&!_.choices&&(_.choices=v.choices),_.push(v);var F=n.indexOf(v,C+1);if(-1!==F){var H=n.slice(C+1,F);H.some(function(W){return"object"==typeof W})&&!_.value?_.value=H:H.length&&(!_.value||"string"!=typeof _.value)&&(_.value=H.join(""))}}}}),u.forEach(function(v){v.length=0});var o={};function d(v){for(var C=[],$=0;$<v.length;$++){var _=v[$];if("object"==typeof _){if(o[_.tabstopId])continue;_=C[v.lastIndexOf(_,$-1)]||{tabstopId:_.tabstopId}}C[$]=_}return C}for(var p=0;p<n.length;p++){var m=n[p];if("object"==typeof m){var y=m.tabstopId,x=u[y],K=n.indexOf(m,p+1);if(o[y]){o[y]===m&&(delete o[y],Object.keys(o).forEach(function(v){x.parents[v]=!0}));continue}o[y]=m;var L=x.value;"string"!=typeof L?L=d(L):m.fmt&&(L=this.tmStrFormat(L,m,a)),n.splice.apply(n,[p+1,Math.max(0,K-p)].concat(L,m)),-1===x.indexOf(m)&&x.push(m)}}var B=0,P=0,j="";return n.forEach(function(v){if("string"==typeof v){var C=v.split("\n");C.length>1?(P=C[C.length-1].length,B+=C.length-1):P+=v.length,j+=v}else v&&(v.start?v.end={row:B,column:P}:v.start={row:B,column:P})}),{text:j,tabstops:u,tokens:n}},f=function(){function a(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=O.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}return a.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},a.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},a.prototype.onChange=function(e){for(var t="r"==e.action[0],r=this.selectedTabstop||{},i=r.parents||{},s=this.tabstops.slice(),c=0;c<s.length;c++){var n=s[c];if(n.rangeList.$bias=n==r||i[n.index]?0:1,"remove"==e.action&&n!==r){var o=n.parents&&n.parents[r.index],d=n.rangeList.pointIndex(e.start,o);d=d<0?-d-1:d+1;for(var p=n.rangeList.pointIndex(e.end,o),m=n.rangeList.ranges.slice(d,p=p<0?-p-1:p-1),y=0;y<m.length;y++)this.removeRange(m[y])}n.rangeList.$onChange(e)}var x=this.session;!this.$inChange&&t&&1==x.getLength()&&!x.getValue()&&this.detach()},a.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.session,r=t.getTextRange(e.firstNonLinked),i=0;i<e.length;i++){var s=e[i];if(s.linked){var n=b.snippetManager.tmStrFormat(r,s.original,this.editor);t.replace(s,n)}}this.$inChange=!1}},a.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},a.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,r=this.editor.selection.isEmpty(),i=0;i<this.ranges.length;i++)if(!this.ranges[i].linked){var s=this.ranges[i].contains(e.row,e.column),c=r||this.ranges[i].contains(t.row,t.column);if(s&&c)return}this.detach()}},a.prototype.onChangeSession=function(){this.detach()},a.prototype.tabNext=function(e){var t=this.tabstops.length,r=this.index+(e||1);(r=Math.min(Math.max(r,1),t))==t&&(r=0),this.selectTabstop(r),0===r&&this.detach()},a.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){this.selectedTabstop=t;var r=t.firstNonLinked||t;if(t.choices&&(r.cursor=r.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(r);else{var i=this.editor.multiSelect;i.toSingleRange(r);for(var s=0;s<t.length;s++)t.hasLinkedRanges&&t[s].linked||i.addRange(t[s].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},a.prototype.addTabstops=function(e,t,r){var i=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var s=w.fromPoints(r,r);g(s.start,t),g(s.end,t),e[0]=[s],e[0].index=0}var n=[this.index+1,0],u=this.ranges;e.forEach(function(o,d){for(var p=this.$openTabstops[d]||o,m=0;m<o.length;m++){var y=o[m],x=w.fromPoints(y.start,y.end||y.start);h(x.start,t),h(x.end,t),x.original=y,x.tabstop=p,u.push(x),p!=o?p.unshift(x):p[m]=x,y.fmtString||p.firstNonLinked&&i?(x.linked=!0,p.hasLinkedRanges=!0):p.firstNonLinked||(p.firstNonLinked=x)}p.firstNonLinked||(p.hasLinkedRanges=!1),p===o&&(n.push(p),this.$openTabstops[d]=p),this.addTabstopMarkers(p),p.rangeList=p.rangeList||new S,p.rangeList.$bias=0,p.rangeList.addList(p)},this),n.length>2&&(this.tabstops.length&&n.push(n.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,n))},a.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(r){r.markerId||(r.markerId=t.addMarker(r,"ace_snippet-marker","text"))})},a.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(r){t.removeMarker(r.markerId),r.markerId=null})},a.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);-1!=t&&e.tabstop.splice(t,1),-1!=(t=this.ranges.indexOf(e))&&this.ranges.splice(t,1),-1!=(t=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(t=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(t,1),this.tabstops.length||this.detach())},a}();f.prototype.keyboardHandler=new k,f.prototype.keyboardHandler.bindKeys({Tab:function(a){b.snippetManager&&b.snippetManager.expandWithTab(a)||(a.tabstopManager.tabNext(1),a.renderer.scrollCursorIntoView())},"Shift-Tab":function(a){a.tabstopManager.tabNext(-1),a.renderer.scrollCursorIntoView()},Esc:function(a){a.tabstopManager.detach()}});var h=function(a,e){0==a.row&&(a.column+=e.column),a.row+=e.row},g=function(a,e){a.row==e.row&&(a.column-=e.column),a.row-=e.row};U.importCssString("\n.ace_snippet-marker {\n    -moz-box-sizing: border-box;\n    box-sizing: border-box;\n    background: rgba(194, 193, 208, 0.09);\n    border: 1px dotted rgba(211, 208, 235, 0.62);\n    position: absolute;\n}","snippets.css",!1),b.snippetManager=new A;var M=T("./editor").Editor;(function(){this.insertSnippet=function(a,e){return b.snippetManager.insertSnippet(this,a,e)},this.expandSnippet=function(a){return b.snippetManager.expandWithTab(this,a)}}).call(M.prototype)}),ace.define("ace/ext/emmet",["require","exports","module","ace/keyboard/hash_handler","ace/editor","ace/snippets","ace/range","ace/config","resources","resources","tabStops","resources","utils","actions"],function(T,b,D){"use strict";var S,k,U=T("../keyboard/hash_handler").HashHandler,V=T("../editor").Editor,z=T("../snippets").snippetManager,O=T("../range").Range,w=T("../config"),I=function(){function l(){}return l.prototype.setupContext=function(f){this.ace=f,this.indentation=f.session.getTabString(),S||(S=window.emmet),(S.resources||S.require("resources")).setVariable("indentation",this.indentation),this.$syntax=null,this.$syntax=this.getSyntax()},l.prototype.getSelectionRange=function(){var f=this.ace.getSelectionRange(),h=this.ace.session.doc;return{start:h.positionToIndex(f.start),end:h.positionToIndex(f.end)}},l.prototype.createSelection=function(f,h){var g=this.ace.session.doc;this.ace.selection.setRange({start:g.indexToPosition(f),end:g.indexToPosition(h)})},l.prototype.getCurrentLineRange=function(){var f=this.ace,h=f.getCursorPosition().row,g=f.session.getLine(h).length,M=f.session.doc.positionToIndex({row:h,column:0});return{start:M,end:M+g}},l.prototype.getCaretPos=function(){var f=this.ace.getCursorPosition();return this.ace.session.doc.positionToIndex(f)},l.prototype.setCaretPos=function(f){var h=this.ace.session.doc.indexToPosition(f);this.ace.selection.moveToPosition(h)},l.prototype.getCurrentLine=function(){var f=this.ace.getCursorPosition().row;return this.ace.session.getLine(f)},l.prototype.replaceContent=function(f,h,g,M){null==g&&(g=null==h?this.getContent().length:h),null==h&&(h=0);var a=this.ace,e=a.session.doc,t=O.fromPoints(e.indexToPosition(h),e.indexToPosition(g));a.session.remove(t),t.end=t.start,f=this.$updateTabstops(f),z.insertSnippet(a,f)},l.prototype.getContent=function(){return this.ace.getValue()},l.prototype.getSyntax=function(){if(this.$syntax)return this.$syntax;var f=this.ace.session.$modeId.split("/").pop();if("html"==f||"php"==f){var h=this.ace.getCursorPosition(),g=this.ace.session.getState(h.row);"string"!=typeof g&&(g=g[0]),g&&((g=g.split("-")).length>1?f=g[0]:"php"==f&&(f="html"))}return f},l.prototype.getProfileName=function(){var f=S.resources||S.require("resources");switch(this.getSyntax()){case"css":return"css";case"xml":case"xsl":return"xml";case"html":var h=f.getVariable("profile");return h||(h=-1!=this.ace.session.getLines(0,2).join("").search(/<!DOCTYPE[^>]+XHTML/i)?"xhtml":"html"),h;default:var g=this.ace.session.$mode;return g.emmetConfig&&g.emmetConfig.profile||"xhtml"}},l.prototype.prompt=function(f){return prompt(f)},l.prototype.getSelection=function(){return this.ace.session.getTextRange()},l.prototype.getFilePath=function(){return""},l.prototype.$updateTabstops=function(f){var g=0,M=null,a=S.tabStops||S.require("tabStops"),t=(S.resources||S.require("resources")).getVocabulary("user"),r={tabstop:function(s){var c=parseInt(s.group,10),n=0===c;n?c=++g:c+=1e3;var u=s.placeholder;u&&(u=a.processText(u,r));var o="${"+c+(u?":"+u:"")+"}";return n&&(M=[s.start,o]),o},escape:function(s){return"$"==s?"\\$":"\\"==s?"\\\\":s}};return f=a.processText(f,r),t.variables.insert_final_tabstop&&!/\$\{0\}$/.test(f)?f+="${0}":M&&(f=(S.utils?S.utils.common:S.require("utils")).replaceSubstring(f,"${0}",M[0],M[1])),f},l}(),N={expand_abbreviation:{mac:"ctrl+alt+e",win:"alt+e"},match_pair_outward:{mac:"ctrl+d",win:"ctrl+,"},match_pair_inward:{mac:"ctrl+j",win:"ctrl+shift+0"},matching_pair:{mac:"ctrl+alt+j",win:"alt+j"},next_edit_point:"alt+right",prev_edit_point:"alt+left",toggle_comment:{mac:"command+/",win:"ctrl+/"},split_join_tag:{mac:"shift+command+'",win:"shift+ctrl+`"},remove_tag:{mac:"command+'",win:"shift+ctrl+;"},evaluate_math_expression:{mac:"shift+command+y",win:"shift+ctrl+y"},increment_number_by_1:"ctrl+up",decrement_number_by_1:"ctrl+down",increment_number_by_01:"alt+up",decrement_number_by_01:"alt+down",increment_number_by_10:{mac:"alt+command+up",win:"shift+alt+up"},decrement_number_by_10:{mac:"alt+command+down",win:"shift+alt+down"},select_next_item:{mac:"shift+command+.",win:"shift+ctrl+."},select_previous_item:{mac:"shift+command+,",win:"shift+ctrl+,"},reflect_css_value:{mac:"shift+command+r",win:"shift+ctrl+r"},encode_decode_data_url:{mac:"shift+ctrl+d",win:"ctrl+'"},expand_abbreviation_with_tab:"Tab",wrap_with_abbreviation:{mac:"shift+ctrl+a",win:"shift+ctrl+a"}},R=new I;for(var E in b.commands=new U,b.runEmmetCommand=function l(f){if("expand_abbreviation_with_tab"==this.action){if(!f.selection.isEmpty())return!1;var h=f.selection.lead,g=f.session.getTokenAt(h.row,h.column);if(g&&/\btag\b/.test(g.type))return!1}try{R.setupContext(f);var M=S.actions||S.require("actions");if("wrap_with_abbreviation"==this.action)return setTimeout(function(){M.run("wrap_with_abbreviation",R)},0);var a=M.run(this.action,R)}catch(t){if(!S){var e=b.load(l.bind(this,f));return"expand_abbreviation_with_tab"!=this.action&&e}f._signal("changeStatus","string"==typeof t?t:t.message),w.warn(t),a=!1}return a},N)b.commands.addCommand({name:"emmet:"+E,action:E,bindKey:N[E],exec:b.runEmmetCommand,multiSelectAction:"forEach"});b.updateCommands=function(l,f){f?l.keyBinding.addKeyboardHandler(b.commands):l.keyBinding.removeKeyboardHandler(b.commands)},b.isSupportedMode=function(l){return!!l&&(!!l.emmetConfig||/css|less|scss|sass|stylus|html|php|twig|ejs|handlebars/.test(l.$id||l))},b.isAvailable=function(l,f){if(/(evaluate_math_expression|expand_abbreviation)$/.test(f))return!0;var h=l.session.$mode,g=b.isSupportedMode(h);if(g&&h.$modes)try{R.setupContext(l),/js|php/.test(R.getSyntax())&&(g=!1)}catch(M){}return g};var A=function(l,f){var h=f;if(h){var g=b.isSupportedMode(h.session.$mode);!1===l.enableEmmet&&(g=!1),g&&b.load(),b.updateCommands(h,g)}};b.load=function(l){return"string"!=typeof k?(w.warn("script for emmet-core is not loaded"),!1):(w.loadModule(k,function(){k=null,l&&l()}),!0)},b.AceEmmetEditor=I,w.defineOptions(V.prototype,"editor",{enableEmmet:{set:function(l){this[l?"on":"removeListener"]("changeMode",A),A({enableEmmet:!!l},this)},value:!0}}),b.setCore=function(l){"string"==typeof l?k=l:S=l}}),ace.require(["ace/ext/emmet"],function(T){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=T)});