/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.cloud.constants.CloudProvider;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class CloudConfig
extends HelixProperty {
    public static final String CLOUD_CONFIG_KW = "CloudConfig";
    private static final boolean DEFAULT_CLOUD_ENABLED = false;

    public CloudConfig() {
        super(CLOUD_CONFIG_KW);
        this.setCloudEnabled(false);
    }

    public CloudConfig(ZNRecord record) {
        super(CLOUD_CONFIG_KW);
        this._record.setSimpleFields(record.getSimpleFields());
        this._record.setListFields(record.getListFields());
        this._record.setMapFields(record.getMapFields());
    }

    public CloudConfig(String cluster, boolean enabled, CloudProvider cloudProvider, String cloudID, List<String> cloudInfoSource, String cloudProcessorName) {
        super(cluster);
        this._record.setBooleanField(CloudConfigProperty.CLOUD_ENABLED.name(), enabled);
        if (enabled) {
            this._record.setSimpleField(CloudConfigProperty.CLOUD_PROVIDER.name(), cloudProvider.name());
            this._record.setSimpleField(CloudConfigProperty.CLOUD_ID.name(), cloudID);
            if (cloudProvider.equals((Object)CloudProvider.CUSTOMIZED)) {
                this._record.setSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_NAME.name(), cloudProcessorName);
                this._record.setListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name(), cloudInfoSource);
            }
        }
    }

    public void setCloudEnabled(boolean enabled) {
        this._record.setBooleanField(CloudConfigProperty.CLOUD_ENABLED.name(), enabled);
    }

    public boolean isCloudEnabled() {
        return this._record.getBooleanField(CloudConfigProperty.CLOUD_ENABLED.name(), false);
    }

    public void setCloudID(String cloudID) {
        this._record.setSimpleField(CloudConfigProperty.CLOUD_ID.name(), cloudID);
    }

    public String getCloudID() {
        return this._record.getSimpleField(CloudConfigProperty.CLOUD_ID.name());
    }

    public void setCloudInfoSource(List<String> cloudInfoSources) {
        this._record.setListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name(), cloudInfoSources);
    }

    public List<String> getCloudInfoSources() {
        return this._record.getListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name());
    }

    public String getCloudInfoProcessorName() {
        return this._record.getSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_NAME.name());
    }

    public String getCloudInfoProcessorPackage() {
        return this._record.getSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_PACKAGE.name());
    }

    public String getCloudProvider() {
        return this._record.getSimpleField(CloudConfigProperty.CLOUD_PROVIDER.name());
    }

    public static class Builder {
        private ZNRecord _record;

        public CloudConfig build() {
            this.validate();
            return new CloudConfig(this._record);
        }

        public Builder() {
            this._record = new ZNRecord(CloudConfig.CLOUD_CONFIG_KW);
        }

        public Builder(ZNRecord record) {
            this._record = record;
        }

        public Builder(CloudConfig cloudConfig) {
            this._record = cloudConfig.getRecord();
        }

        public Builder setCloudEnabled(boolean isEnabled) {
            this._record.setBooleanField(CloudConfigProperty.CLOUD_ENABLED.name(), isEnabled);
            return this;
        }

        public Builder setCloudProvider(CloudProvider cloudProvider) {
            this._record.setSimpleField(CloudConfigProperty.CLOUD_PROVIDER.name(), cloudProvider.name());
            return this;
        }

        public Builder setCloudID(String cloudID) {
            this._record.setSimpleField(CloudConfigProperty.CLOUD_ID.name(), cloudID);
            return this;
        }

        public Builder setCloudInfoSources(List<String> cloudInfoSources) {
            this._record.setListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name(), cloudInfoSources);
            return this;
        }

        public Builder addCloudInfoSource(String cloudInfoSource) {
            if (this._record.getListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name()) == null) {
                this._record.setListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name(), new ArrayList<String>());
            }
            List<String> cloudInfoSourcesList = this._record.getListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name());
            cloudInfoSourcesList.add(cloudInfoSource);
            this._record.setListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name(), cloudInfoSourcesList);
            return this;
        }

        public Builder setCloudInfoProcessorName(String cloudInfoProcessorName) {
            this._record.setSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_NAME.name(), cloudInfoProcessorName);
            return this;
        }

        public Builder setCloudInfoProcessorPackageName(String cloudInfoProcessorPackage) {
            this._record.setSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_PACKAGE.name(), cloudInfoProcessorPackage);
            return this;
        }

        public String getCloudProvider() {
            return this._record.getSimpleField(CloudConfigProperty.CLOUD_PROVIDER.name());
        }

        public boolean getCloudEnabled() {
            return this._record.getBooleanField(CloudConfigProperty.CLOUD_ENABLED.name(), false);
        }

        public String getCloudID() {
            return this._record.getSimpleField(CloudConfigProperty.CLOUD_ID.name());
        }

        public List<String> getCloudInfoSources() {
            return this._record.getListField(CloudConfigProperty.CLOUD_INFO_SOURCE.name());
        }

        public String getCloudInfoProcessorName() {
            return this._record.getSimpleField(CloudConfigProperty.CLOUD_INFO_PROCESSOR_NAME.name());
        }

        private void validate() {
            if (this.getCloudEnabled()) {
                if (this.getCloudProvider() == null) {
                    throw new HelixException("This Cloud Configuration is Invalid. The Cloud Provider is missing from the config.");
                }
                if (this.getCloudProvider().equals(CloudProvider.CUSTOMIZED.name()) && (this.getCloudInfoProcessorName() == null || this.getCloudInfoSources() == null || this.getCloudInfoSources().size() == 0)) {
                    throw new HelixException("This Cloud Configuration is Invalid. CUSTOMIZED provider has been chosen without defining CloudInfoProcessorName or CloudInfoSources");
                }
            }
        }
    }

    public static enum CloudConfigProperty {
        CLOUD_ENABLED,
        CLOUD_PROVIDER,
        CLOUD_ID,
        CLOUD_INFO_SOURCE,
        CLOUD_INFO_PROCESSOR_NAME,
        CLOUD_INFO_PROCESSOR_PACKAGE;

    }
}

