/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixException;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;

public class ClusterModelProvider {
    public static ClusterModel generateClusterModelForEmergencyRebalance(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Set<String> activeInstances, Map<String, ResourceAssignment> bestPossibleAssignment) {
        return ClusterModelProvider.generateClusterModel(dataProvider, resourceMap, activeInstances, Collections.emptyMap(), Collections.emptyMap(), bestPossibleAssignment, RebalanceScopeType.EMERGENCY);
    }

    public static ClusterModel generateClusterModelForPartialRebalance(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Set<String> activeInstances, Map<String, ResourceAssignment> baselineAssignment, Map<String, ResourceAssignment> bestPossibleAssignment) {
        return ClusterModelProvider.generateClusterModel(dataProvider, resourceMap, activeInstances, Collections.emptyMap(), baselineAssignment, bestPossibleAssignment, RebalanceScopeType.PARTIAL);
    }

    public static ClusterModel generateClusterModelForBaseline(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Set<String> allInstances, Map<HelixConstants.ChangeType, Set<String>> clusterChanges, Map<String, ResourceAssignment> baselineAssignment) {
        return ClusterModelProvider.generateClusterModel(dataProvider, resourceMap, allInstances, clusterChanges, Collections.emptyMap(), baselineAssignment, RebalanceScopeType.GLOBAL_BASELINE);
    }

    public static ClusterModel generateClusterModelFromExistingAssignment(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Map<String, ResourceAssignment> currentStateAssignment) {
        return ClusterModelProvider.generateClusterModel(dataProvider, resourceMap, dataProvider.getEnabledLiveInstances(), Collections.emptyMap(), Collections.emptyMap(), currentStateAssignment, RebalanceScopeType.GLOBAL_BASELINE);
    }

    private static ClusterModel generateClusterModel(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Set<String> activeInstances, Map<HelixConstants.ChangeType, Set<String>> clusterChanges, Map<String, ResourceAssignment> idealAssignment, Map<String, ResourceAssignment> currentAssignment, RebalanceScopeType scopeType) {
        Set<AssignableReplica> toBeAssignedReplicas;
        Set<AssignableNode> assignableNodes = ClusterModelProvider.getAllAssignableNodes(dataProvider.getClusterConfig(), dataProvider.getInstanceConfigMap(), activeInstances);
        Map<String, Set<AssignableReplica>> replicaMap = ClusterModelProvider.getAllAssignableReplicas(dataProvider, resourceMap, assignableNodes);
        HashMap<String, Set<AssignableReplica>> allocatedReplicas = new HashMap<String, Set<AssignableReplica>>();
        switch (scopeType) {
            case GLOBAL_BASELINE: {
                toBeAssignedReplicas = ClusterModelProvider.findToBeAssignedReplicasByClusterChanges(replicaMap, activeInstances, dataProvider.getLiveInstances().keySet(), clusterChanges, currentAssignment, allocatedReplicas);
                break;
            }
            case PARTIAL: {
                ClusterModelProvider.retainExistingReplicas(replicaMap, idealAssignment);
                toBeAssignedReplicas = ClusterModelProvider.findToBeAssignedReplicasByComparingWithIdealAssignment(replicaMap, activeInstances, idealAssignment, currentAssignment, allocatedReplicas);
                break;
            }
            case EMERGENCY: {
                toBeAssignedReplicas = ClusterModelProvider.findToBeAssignedReplicasOnDownInstances(replicaMap, activeInstances, currentAssignment, allocatedReplicas);
                break;
            }
            default: {
                throw new HelixException("Unknown rebalance scope type: " + scopeType);
            }
        }
        assignableNodes.parallelStream().forEach(node -> node.assignInitBatch(allocatedReplicas.getOrDefault(node.getInstanceName(), Collections.emptySet())));
        ClusterContext context = new ClusterContext(replicaMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), assignableNodes, idealAssignment, currentAssignment);
        context.setAssignmentForFaultZoneMap(ClusterModelProvider.mapAssignmentToFaultZone(assignableNodes));
        return new ClusterModel(context, toBeAssignedReplicas, assignableNodes);
    }

    private static void retainExistingReplicas(Map<String, Set<AssignableReplica>> replicaMap, Map<String, ResourceAssignment> assignmentMap) {
        replicaMap.entrySet().parallelStream().forEach(replicaSetEntry -> {
            Map<String, Map<String, Set<String>>> stateInstanceMap = ClusterModelProvider.getStateInstanceMap((ResourceAssignment)assignmentMap.get(replicaSetEntry.getKey()));
            Iterator replicaIter = ((Set)replicaSetEntry.getValue()).iterator();
            while (replicaIter.hasNext()) {
                AssignableReplica replica = (AssignableReplica)replicaIter.next();
                Set validInstances = stateInstanceMap.getOrDefault(replica.getPartitionName(), Collections.emptyMap()).getOrDefault(replica.getReplicaState(), Collections.emptySet());
                if (validInstances.isEmpty()) {
                    replicaIter.remove();
                    continue;
                }
                validInstances.remove(validInstances.iterator().next());
            }
        });
    }

    private static Set<AssignableReplica> findToBeAssignedReplicasByComparingWithIdealAssignment(Map<String, Set<AssignableReplica>> replicaMap, Set<String> activeInstances, Map<String, ResourceAssignment> idealAssignment, Map<String, ResourceAssignment> currentAssignment, Map<String, Set<AssignableReplica>> allocatedReplicas) {
        HashSet<AssignableReplica> toBeAssignedReplicas = new HashSet<AssignableReplica>();
        for (String resourceName : replicaMap.keySet()) {
            Map<String, Map<String, Set<String>>> idealPartitionStateMap = ClusterModelProvider.getValidStateInstanceMap(idealAssignment.get(resourceName), activeInstances);
            Map<String, Map<String, Set<String>>> currentPartitionStateMap = ClusterModelProvider.getValidStateInstanceMap(currentAssignment.get(resourceName), activeInstances);
            for (AssignableReplica replica : replicaMap.get(resourceName)) {
                String allocatedInstance;
                String partitionName = replica.getPartitionName();
                String replicaState = replica.getReplicaState();
                Set idealAllocations = idealPartitionStateMap.getOrDefault(partitionName, Collections.emptyMap()).getOrDefault(replicaState, Collections.emptySet());
                Set currentAllocations = currentPartitionStateMap.getOrDefault(partitionName, Collections.emptyMap()).getOrDefault(replicaState, Collections.emptySet());
                ArrayList commonAllocations = new ArrayList(currentAllocations);
                commonAllocations.retainAll(idealAllocations);
                if (!commonAllocations.isEmpty()) {
                    allocatedInstance = (String)commonAllocations.get(0);
                    allocatedReplicas.computeIfAbsent(allocatedInstance, key -> new HashSet()).add(replica);
                    idealAllocations.remove(allocatedInstance);
                    currentAllocations.remove(allocatedInstance);
                    continue;
                }
                if (!idealAllocations.isEmpty()) {
                    toBeAssignedReplicas.add(replica);
                    String pendingAllocation = (String)idealAllocations.iterator().next();
                    idealAllocations.remove(pendingAllocation);
                    continue;
                }
                if (!currentAllocations.isEmpty()) {
                    allocatedInstance = (String)currentAllocations.iterator().next();
                    allocatedReplicas.computeIfAbsent(allocatedInstance, key -> new HashSet()).add(replica);
                    currentAllocations.remove(allocatedInstance);
                    continue;
                }
                toBeAssignedReplicas.add(replica);
            }
        }
        return toBeAssignedReplicas;
    }

    private static Set<AssignableReplica> findToBeAssignedReplicasByClusterChanges(Map<String, Set<AssignableReplica>> replicaMap, Set<String> activeInstances, Set<String> liveInstances, Map<HelixConstants.ChangeType, Set<String>> clusterChanges, Map<String, ResourceAssignment> currentAssignment, Map<String, Set<AssignableReplica>> allocatedReplicas) {
        HashSet<AssignableReplica> toBeAssignedReplicas = new HashSet<AssignableReplica>();
        Set newlyConnectedNodes = clusterChanges.getOrDefault((Object)HelixConstants.ChangeType.LIVE_INSTANCE, Collections.emptySet());
        newlyConnectedNodes.retainAll(liveInstances);
        if (clusterChanges.containsKey((Object)HelixConstants.ChangeType.CLUSTER_CONFIG) || clusterChanges.containsKey((Object)HelixConstants.ChangeType.INSTANCE_CONFIG) || !newlyConnectedNodes.isEmpty()) {
            toBeAssignedReplicas.addAll(replicaMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        } else {
            for (Map.Entry<String, Set<AssignableReplica>> replicaMapEntry : replicaMap.entrySet()) {
                String resourceName = replicaMapEntry.getKey();
                Set<AssignableReplica> replicas = replicaMapEntry.getValue();
                if (clusterChanges.getOrDefault((Object)HelixConstants.ChangeType.RESOURCE_CONFIG, Collections.emptySet()).contains(resourceName) || clusterChanges.getOrDefault((Object)HelixConstants.ChangeType.IDEAL_STATE, Collections.emptySet()).contains(resourceName) || !currentAssignment.containsKey(resourceName)) {
                    toBeAssignedReplicas.addAll(replicas);
                    continue;
                }
                Map<String, Map<String, Set<String>>> stateMap = ClusterModelProvider.getValidStateInstanceMap(currentAssignment.get(resourceName), activeInstances);
                for (AssignableReplica replica : replicas) {
                    Set validInstances = stateMap.getOrDefault(replica.getPartitionName(), Collections.emptyMap()).getOrDefault(replica.getReplicaState(), Collections.emptySet());
                    if (validInstances.isEmpty()) {
                        toBeAssignedReplicas.add(replica);
                        continue;
                    }
                    Iterator iter = validInstances.iterator();
                    String instanceName = (String)iter.next();
                    iter.remove();
                    allocatedReplicas.computeIfAbsent(instanceName, key -> new HashSet()).add(replica);
                }
            }
        }
        return toBeAssignedReplicas;
    }

    private static Set<AssignableReplica> findToBeAssignedReplicasOnDownInstances(Map<String, Set<AssignableReplica>> replicaMap, Set<String> activeInstances, Map<String, ResourceAssignment> currentAssignment, Map<String, Set<AssignableReplica>> allocatedReplicas) {
        HashSet<AssignableReplica> toBeAssignedReplicas = new HashSet<AssignableReplica>();
        for (String resourceName : replicaMap.keySet()) {
            Map<String, Map<String, Set<String>>> stateInstanceMap = ClusterModelProvider.getStateInstanceMap(currentAssignment.get(resourceName));
            for (AssignableReplica replica : replicaMap.get(resourceName)) {
                String partitionName = replica.getPartitionName();
                String replicaState = replica.getReplicaState();
                Set currentAllocations = stateInstanceMap.getOrDefault(partitionName, Collections.emptyMap()).getOrDefault(replicaState, Collections.emptySet());
                if (currentAllocations.isEmpty()) continue;
                String allocatedInstance = (String)currentAllocations.iterator().next();
                if (activeInstances.contains(allocatedInstance)) {
                    allocatedReplicas.computeIfAbsent(allocatedInstance, key -> new HashSet()).add(replica);
                } else {
                    toBeAssignedReplicas.add(replica);
                }
                currentAllocations.remove(allocatedInstance);
            }
        }
        return toBeAssignedReplicas;
    }

    private static Map<String, Map<String, Set<String>>> getValidStateInstanceMap(ResourceAssignment assignment, Set<String> activeInstances) {
        Map<String, Map<String, Set<String>>> stateInstanceMap = ClusterModelProvider.getStateInstanceMap(assignment);
        stateInstanceMap.values().stream().forEach(stateMap -> stateMap.values().stream().forEach(instanceSet -> instanceSet.retainAll(activeInstances)));
        return stateInstanceMap;
    }

    private static Map<String, Map<String, Set<String>>> getStateInstanceMap(ResourceAssignment assignment) {
        if (assignment == null) {
            return Collections.emptyMap();
        }
        return assignment.getMappedPartitions().stream().collect(Collectors.toMap(partition -> partition.getPartitionName(), partition -> {
            HashMap stateInstanceMap = new HashMap();
            assignment.getReplicaMap((Partition)partition).entrySet().stream().forEach(stateMapEntry -> stateInstanceMap.computeIfAbsent((String)stateMapEntry.getValue(), key -> new HashSet()).add((String)stateMapEntry.getKey()));
            return stateInstanceMap;
        }));
    }

    private static Set<AssignableNode> getAllAssignableNodes(ClusterConfig clusterConfig, Map<String, InstanceConfig> instanceConfigMap, Set<String> activeInstances) {
        return activeInstances.parallelStream().filter(instance -> instanceConfigMap.containsKey(instance)).map(instanceName -> new AssignableNode(clusterConfig, (InstanceConfig)instanceConfigMap.get(instanceName), (String)instanceName)).collect(Collectors.toSet());
    }

    private static Map<String, Set<AssignableReplica>> getAllAssignableReplicas(ResourceControllerDataProvider dataProvider, Map<String, Resource> resourceMap, Set<AssignableNode> assignableNodes) {
        ClusterConfig clusterConfig = dataProvider.getClusterConfig();
        int activeFaultZoneCount = assignableNodes.stream().map(node -> node.getFaultZone()).collect(Collectors.toSet()).size();
        return resourceMap.keySet().parallelStream().map(resourceName -> {
            IdealState is;
            ResourceConfig resourceConfig = dataProvider.getResourceConfig((String)resourceName);
            if (resourceConfig == null) {
                resourceConfig = new ResourceConfig((String)resourceName);
            }
            if ((is = dataProvider.getIdealState((String)resourceName)) == null) {
                throw new HelixException("Cannot find the resource ideal state for resource: " + resourceName);
            }
            String defName = is.getStateModelDefRef();
            StateModelDefinition def = dataProvider.getStateModelDef(defName);
            if (def == null) {
                throw new IllegalArgumentException(String.format("Cannot find state model definition %s for resource %s.", is.getStateModelDefRef(), resourceName));
            }
            LinkedHashMap<String, Integer> stateCountMap = def.getStateCountMap(activeFaultZoneCount, is.getReplicaCount(assignableNodes.size()));
            ResourceConfig mergedResourceConfig = ResourceConfig.mergeIdealStateWithResourceConfig(resourceConfig, is);
            HashSet<AssignableReplica> replicas = new HashSet<AssignableReplica>();
            for (String partition : is.getPartitionSet()) {
                for (Map.Entry entry : stateCountMap.entrySet()) {
                    String state = (String)entry.getKey();
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        replicas.add(new AssignableReplica(clusterConfig, mergedResourceConfig, partition, state, def.getStatePriorityMap().get(state)));
                    }
                }
            }
            return new AbstractMap.SimpleEntry((String)resourceName, replicas);
        }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Set)entry.getValue()));
    }

    private static Map<String, Map<String, Set<String>>> mapAssignmentToFaultZone(Set<AssignableNode> assignableNodes) {
        HashMap<String, Map<String, Set<String>>> faultZoneAssignmentMap = new HashMap<String, Map<String, Set<String>>>();
        assignableNodes.stream().forEach(node -> {
            for (Map.Entry<String, Set<String>> resourceMap : node.getAssignedPartitionsMap().entrySet()) {
                faultZoneAssignmentMap.computeIfAbsent(node.getFaultZone(), k -> new HashMap()).computeIfAbsent(resourceMap.getKey(), k -> new HashSet()).addAll((Collection)resourceMap.getValue());
            }
        });
        return faultZoneAssignmentMap;
    }

    private static enum RebalanceScopeType {
        PARTIAL,
        GLOBAL_BASELINE,
        EMERGENCY;

    }
}

