/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerInstanceResourceMonitor
extends DynamicMBeanProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PerInstanceResourceMonitor.class);
    private static final String MBEAN_DESCRIPTION = "Per Instance Resource Monitor";
    private final String _clusterName;
    private List<String> _tags;
    private final String _participantName;
    private final String _resourceName;
    private SimpleDynamicMetric<Long> _partitions;

    public PerInstanceResourceMonitor(String clusterName, String participantName, String resourceName) {
        this._clusterName = clusterName;
        this._tags = ImmutableList.of((Object)"DEFAULT");
        this._participantName = participantName;
        this._resourceName = resourceName;
        this._partitions = new SimpleDynamicMetric<Long>("PartitionGauge", 0L);
    }

    @Override
    public String getSensorName() {
        return Joiner.on((char)'.').join((Iterable)ImmutableList.of((Object)"ParticipantStatus", (Object)this._clusterName, (Object)this.serializedTags(), (Object)this._participantName, (Object)this._resourceName));
    }

    private String serializedTags() {
        return Joiner.on((char)'|').skipNulls().join(this._tags);
    }

    public String getInstanceName() {
        return this._participantName;
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public synchronized void update(Map<Partition, String> stateMap, Set<String> tags, StateModelDefinition stateModelDef) {
        if (tags == null || tags.isEmpty()) {
            this._tags = ImmutableList.of((Object)"DEFAULT");
        } else {
            this._tags = Lists.newArrayList(tags);
            Collections.sort(this._tags);
        }
        int cnt = 0;
        for (String state : stateMap.values()) {
            if (state.equalsIgnoreCase(HelixDefinedState.DROPPED.name()) || state.equalsIgnoreCase(stateModelDef.getInitialState())) continue;
            ++cnt;
        }
        this._partitions.updateValue(Long.valueOf(cnt));
    }

    @Override
    public DynamicMBeanProvider register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._partitions);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, new BeanName(this._clusterName, this._participantName, this._resourceName).objectName());
        return this;
    }

    public static class BeanName {
        private final String _instanceName;
        private final String _resourceName;
        private final String _clusterName;

        public BeanName(String clusterName, String instanceName, String resourceName) {
            if (clusterName == null || instanceName == null || resourceName == null) {
                throw new NullPointerException("Illegal beanName. clusterName: " + clusterName + ", instanceName: " + instanceName + ", resourceName: " + resourceName);
            }
            this._clusterName = clusterName;
            this._instanceName = instanceName;
            this._resourceName = resourceName;
        }

        public String instanceName() {
            return this._instanceName;
        }

        public String resourceName() {
            return this._resourceName;
        }

        public ObjectName objectName() {
            try {
                return new ObjectName(MonitorDomainNames.ClusterStatus.name() + ":" + this);
            }
            catch (MalformedObjectNameException e) {
                LOG.error("Failed to create object name for cluster: {}, instance: {}, resource: {}.", new Object[]{this._clusterName, this._instanceName, this._resourceName});
                return null;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BeanName)) {
                return false;
            }
            BeanName that = (BeanName)obj;
            return this._clusterName.equals(that._clusterName) && this._instanceName.equals(that._instanceName) && this._resourceName.equals(that._resourceName);
        }

        public int hashCode() {
            return 961 * this._clusterName.hashCode() + 31 * this._instanceName.hashCode() + this._resourceName.hashCode();
        }

        public String toString() {
            return "cluster=" + this._clusterName + "," + "instanceName" + "=" + this._instanceName + "," + "resourceName" + "=" + this._resourceName;
        }
    }
}

