/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.extension;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.net.auth.AuthenticationProvider;

@Path(value="/ext")
public class ExtensionRESTService {
    @Inject
    private List<AuthenticationProvider> authProviders;

    private AuthenticationProvider getAuthenticationProvider(String identifier) {
        for (AuthenticationProvider authProvider : this.authProviders) {
            if (!authProvider.getIdentifier().equals(identifier)) continue;
            return authProvider;
        }
        return null;
    }

    @Path(value="{identifier}")
    public Object getExtensionResource(@PathParam(value="identifier") String identifier) throws GuacamoleException {
        Object resource;
        AuthenticationProvider authProvider = this.getAuthenticationProvider(identifier);
        if (authProvider != null && (resource = authProvider.getResource()) != null) {
            return resource;
        }
        throw new GuacamoleResourceNotFoundException("No such resource.");
    }
}

