/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.spark.SparkFilterConverter;
import org.apache.flink.table.store.spark.SparkScanBuilder;
import org.apache.flink.table.store.spark.SparkTypeUtils;
import org.apache.flink.table.store.spark.SparkWriteBuilder;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.SupportsPartition;
import org.apache.spark.sql.connector.catalog.SupportsDelete;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class SparkTable
implements Table,
SupportsRead,
SupportsWrite,
SupportsDelete {
    private final org.apache.flink.table.store.table.Table table;
    private final Lock.Factory lockFactory;
    private final Configuration conf;

    public SparkTable(org.apache.flink.table.store.table.Table table, Lock.Factory lockFactory, Configuration conf) {
        this.table = table;
        this.lockFactory = lockFactory;
        this.conf = conf;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new SparkScanBuilder(this.table, this.conf);
    }

    public String name() {
        return this.table.name();
    }

    public StructType schema() {
        return SparkTypeUtils.fromFlinkRowType(this.table.rowType());
    }

    public Set<TableCapability> capabilities() {
        HashSet<TableCapability> capabilities = new HashSet<TableCapability>();
        capabilities.add(TableCapability.BATCH_READ);
        capabilities.add(TableCapability.V1_BATCH_WRITE);
        return capabilities;
    }

    public Transform[] partitioning() {
        if (this.table instanceof SupportsPartition) {
            return (Transform[])((SupportsPartition)((Object)this.table)).partitionKeys().stream().map(FieldReference::apply).map(IdentityTransform::apply).toArray(Transform[]::new);
        }
        return new Transform[0];
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new SparkWriteBuilder(SparkTable.castToWritable(this.table), info.queryId(), this.lockFactory, this.conf);
    }

    public void deleteWhere(Filter[] filters) {
        SparkFilterConverter converter = new SparkFilterConverter(this.table.rowType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Filter filter : filters) {
            if ("AlwaysTrue()".equals(filter.toString())) continue;
            predicates.add(converter.convert(filter));
        }
        String commitUser = UUID.randomUUID().toString();
        SparkTable.castToWritable(this.table).deleteWhere(commitUser, predicates, this.lockFactory);
    }

    public Map<String, String> properties() {
        if (this.table instanceof DataTable) {
            return ((DataTable)this.table).options().toMap();
        }
        return Collections.emptyMap();
    }

    private static org.apache.flink.table.store.table.SupportsWrite castToWritable(org.apache.flink.table.store.table.Table table) {
        if (!(table instanceof org.apache.flink.table.store.table.SupportsWrite)) {
            throw new UnsupportedOperationException("Unsupported table for writing: " + table.getClass());
        }
        return (org.apache.flink.table.store.table.SupportsWrite)table;
    }
}

