/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json;

import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.store.shaded.com.google.common.collect.Lists;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Table;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.flink.table.store.shaded.org.apache.thrift.TException;
import org.codehaus.jackson.annotate.JsonProperty;

public class JSONInsertMessage
extends InsertMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableType;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    String ptnObjJson;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    String replace;
    @JsonProperty
    List<String> files;

    public JSONInsertMessage() {
    }

    public JSONInsertMessage(String server, String servicePrincipal, Table tableObj, Partition ptnObj, boolean replace, Iterator<String> fileIter, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        if (null == tableObj) {
            throw new IllegalArgumentException("Table not valid.");
        }
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        this.tableType = tableObj.getTableType();
        try {
            this.tableObjJson = JSONMessageFactory.createTableObjJson(tableObj);
            this.ptnObjJson = null != ptnObj ? JSONMessageFactory.createPartitionObjJson(ptnObj) : null;
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.timestamp = timestamp;
        this.replace = Boolean.toString(replace);
        this.files = Lists.newArrayList(fileIter);
        this.checkValid();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getTableType() {
        if (this.tableType != null) {
            return this.tableType;
        }
        return "";
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public Iterable<String> getFiles() {
        return this.files;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public boolean isReplace() {
        return Boolean.parseBoolean(this.replace);
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)JSONMessageFactory.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Partition getPtnObj() throws Exception {
        return null == this.ptnObjJson ? null : (Partition)JSONMessageFactory.getTObj(this.ptnObjJson, Partition.class);
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

