/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.spark.SparkInputPartition;
import org.apache.flink.table.store.spark.SparkReaderFactory;
import org.apache.flink.table.store.spark.SparkTypeUtils;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.types.StructType;

public class SparkScan
implements Scan,
SupportsReportStatistics {
    protected final FileStoreTable table;
    private final List<Predicate> predicates;
    private final int[] projectedFields;
    private List<Split> splits;

    public SparkScan(FileStoreTable table, List<Predicate> predicates, int[] projectedFields) {
        this.table = table;
        this.predicates = predicates;
        this.projectedFields = projectedFields;
    }

    public String description() {
        return String.format("tablestore(%s)", this.table.location().getName());
    }

    public StructType readSchema() {
        return SparkTypeUtils.fromFlinkRowType(TypeUtils.project(this.table.schema().logicalRowType(), this.projectedFields));
    }

    public Batch toBatch() {
        return new Batch(){

            public InputPartition[] planInputPartitions() {
                return (InputPartition[])SparkScan.this.splits().stream().map(SparkInputPartition::new).toArray(InputPartition[]::new);
            }

            public PartitionReaderFactory createReaderFactory() {
                return new SparkReaderFactory(SparkScan.this.table, SparkScan.this.projectedFields, SparkScan.this.predicates);
            }
        };
    }

    protected List<Split> splits() {
        if (this.splits == null) {
            this.splits = this.table.newScan().withFilter(this.predicates).plan().splits;
        }
        return this.splits;
    }

    public Statistics estimateStatistics() {
        long rowCount = 0L;
        for (Split split : this.splits()) {
            for (DataFileMeta file : split.files()) {
                rowCount += file.rowCount();
            }
        }
        final long numRows = rowCount;
        final long sizeInBytes = (long)this.readSchema().defaultSize() * numRows;
        return new Statistics(){

            public OptionalLong sizeInBytes() {
                return OptionalLong.of(sizeInBytes);
            }

            public OptionalLong numRows() {
                return OptionalLong.of(numRows);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkScan that = (SparkScan)o;
        return this.table.location().equals(that.table.location()) && this.readSchema().equals((Object)that.readSchema()) && this.predicates.equals(that.predicates);
    }

    public int hashCode() {
        return Objects.hash(this.table.location(), this.readSchema(), this.predicates);
    }
}

