/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;

@Internal
public class CompactorRequestSerializer
implements SimpleVersionedSerializer<CompactorRequest> {
    private final SimpleVersionedSerializer<FileSinkCommittable> committableSerializer;
    private static final int MAGIC_NUMBER = 801512985;

    public CompactorRequestSerializer(SimpleVersionedSerializer<FileSinkCommittable> committableSerializer) {
        this.committableSerializer = committableSerializer;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public byte[] serialize(CompactorRequest request) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(256);
        out.writeInt(801512985);
        this.serializeV1(request, out);
        return out.getCopyOfBuffer();
    }

    @Override
    public CompactorRequest deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        switch (version) {
            case 1: {
                CompactorRequestSerializer.validateMagicNumber(in);
                return this.deserializeV1(in);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private void serializeV1(CompactorRequest request, DataOutputSerializer out) throws IOException {
        out.writeUTF(request.getBucketId());
        SimpleVersionedSerialization.writeVersionAndSerializeList(this.committableSerializer, request.getCommittableToCompact(), out);
        SimpleVersionedSerialization.writeVersionAndSerializeList(this.committableSerializer, request.getCommittableToPassthrough(), out);
    }

    private CompactorRequest deserializeV1(DataInputDeserializer in) throws IOException {
        String bucketId = in.readUTF();
        List<FileSinkCommittable> committableToCompact = SimpleVersionedSerialization.readVersionAndDeserializeList(this.committableSerializer, in);
        List<FileSinkCommittable> committableToPassthrough = SimpleVersionedSerialization.readVersionAndDeserializeList(this.committableSerializer, in);
        return new CompactorRequest(bucketId, committableToCompact, committableToPassthrough);
    }

    private static void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 801512985) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }
}

