/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.FileStoreExpire;
import org.apache.flink.table.store.file.operation.Lock;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreExpireImpl
implements FileStoreExpire {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreExpireImpl.class);
    private final int numRetainedMin;
    private final int numRetainedMax;
    private final long millisRetained;
    private final FileStorePathFactory pathFactory;
    private final SnapshotManager snapshotManager;
    private final ManifestFile manifestFile;
    private final ManifestList manifestList;
    private Lock lock;

    public FileStoreExpireImpl(int numRetainedMin, int numRetainedMax, long millisRetained, FileStorePathFactory pathFactory, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory) {
        this.numRetainedMin = numRetainedMin;
        this.numRetainedMax = numRetainedMax;
        this.millisRetained = millisRetained;
        this.pathFactory = pathFactory;
        this.snapshotManager = snapshotManager;
        this.manifestFile = manifestFileFactory.create();
        this.manifestList = manifestListFactory.create();
    }

    @Override
    public FileStoreExpire withLock(Lock lock) {
        this.lock = lock;
        return this;
    }

    @Override
    public void expire() {
        Long earliest;
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            return;
        }
        long currentMillis = System.currentTimeMillis();
        try {
            earliest = this.snapshotManager.findEarliest();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find earliest snapshot id", e);
        }
        if (earliest == null) {
            return;
        }
        for (long id = Math.max(latestSnapshotId - (long)this.numRetainedMax + 1L, earliest); id <= latestSnapshotId - (long)this.numRetainedMin; ++id) {
            if (!this.snapshotManager.snapshotExists(id) || currentMillis - this.snapshotManager.snapshot(id).timeMillis() > this.millisRetained) continue;
            this.expireUntil(earliest, id);
            return;
        }
        this.expireUntil(earliest, latestSnapshotId - (long)this.numRetainedMin + 1L);
    }

    private void expireUntil(long earliestId, long endExclusiveId) {
        long id;
        if (endExclusiveId <= earliestId) {
            if (this.snapshotManager.readHint("EARLIEST") == null) {
                this.writeEarliestHint(endExclusiveId);
            }
            return;
        }
        long beginInclusiveId = earliestId;
        for (id = endExclusiveId - 1L; id >= earliestId; --id) {
            if (this.snapshotManager.snapshotExists(id)) continue;
            beginInclusiveId = id + 1L;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Snapshot expire range is [" + beginInclusiveId + ", " + endExclusiveId + ")");
        }
        for (id = beginInclusiveId + 1L; id <= endExclusiveId; ++id) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete data files in snapshot #" + id);
            }
            List<String> manifestFiles = this.manifestList.read(this.snapshotManager.snapshot(id).deltaManifestList()).stream().map(ManifestFileMeta::fileName).collect(Collectors.toList());
            Iterable<ManifestEntry> dataFileLog = this.manifestFile.readManifestFiles(manifestFiles);
            this.expireDataFiles(dataFileLog);
        }
        Snapshot exclusiveSnapshot = this.snapshotManager.snapshot(endExclusiveId);
        HashSet<ManifestFileMeta> manifestsInUse = new HashSet<ManifestFileMeta>(exclusiveSnapshot.readAllManifests(this.manifestList));
        HashSet<ManifestFileMeta> deletedManifests = new HashSet<ManifestFileMeta>();
        for (long id2 = beginInclusiveId; id2 < endExclusiveId; ++id2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ready to delete manifests in snapshot #" + id2);
            }
            Snapshot toExpire = this.snapshotManager.snapshot(id2);
            for (ManifestFileMeta manifest : toExpire.readAllManifests(this.manifestList)) {
                if (manifestsInUse.contains(manifest) || deletedManifests.contains(manifest)) continue;
                this.manifestFile.delete(manifest.fileName());
                deletedManifests.add(manifest);
            }
            this.manifestList.delete(toExpire.baseManifestList());
            this.manifestList.delete(toExpire.deltaManifestList());
            FileUtils.deleteOrWarn(this.snapshotManager.snapshotPath(id2));
        }
        this.writeEarliestHint(endExclusiveId);
    }

    @VisibleForTesting
    void expireDataFiles(Iterable<ManifestEntry> dataFileLog) {
        HashMap<Path, List> dataFileToDelete = new HashMap<Path, List>();
        block4: for (ManifestEntry entry : dataFileLog) {
            Path bucketPath = this.pathFactory.bucketPath(entry.partition(), entry.bucket());
            Path dataFilePath = new Path(bucketPath, entry.file().fileName());
            switch (entry.kind()) {
                case ADD: {
                    dataFileToDelete.remove(dataFilePath);
                    continue block4;
                }
                case DELETE: {
                    ArrayList<Path> extraFiles2 = new ArrayList<Path>(entry.file().extraFiles().size());
                    for (String file : entry.file().extraFiles()) {
                        extraFiles2.add(new Path(bucketPath, file));
                    }
                    dataFileToDelete.put(dataFilePath, extraFiles2);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
        dataFileToDelete.forEach((path, extraFiles) -> {
            FileUtils.deleteOrWarn(path);
            extraFiles.forEach(FileUtils::deleteOrWarn);
        });
    }

    private void writeEarliestHint(long earliest) {
        Callable<Void> callable = () -> {
            this.snapshotManager.commitEarliestHint(earliest);
            return null;
        };
        try {
            if (this.lock != null) {
                this.lock.runWithLock(callable);
            } else {
                callable.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

