/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.manifest.FileKind;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFileMeta;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.util.Preconditions;

public interface FileStoreScan {
    public FileStoreScan withPartitionFilter(Predicate var1);

    public FileStoreScan withPartitionFilter(List<BinaryRowData> var1);

    public FileStoreScan withBucket(int var1);

    public FileStoreScan withSnapshot(long var1);

    public FileStoreScan withManifestList(List<ManifestFileMeta> var1);

    public FileStoreScan withIncremental(boolean var1);

    public Plan plan();

    public static interface Plan {
        @Nullable
        public Long snapshotId();

        public List<ManifestEntry> files();

        default public Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupByPartFiles() {
            List<ManifestEntry> files = this.files();
            HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>> groupBy = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
            for (ManifestEntry entry : files) {
                Preconditions.checkArgument((entry.kind() == FileKind.ADD ? 1 : 0) != 0);
                groupBy.computeIfAbsent(entry.partition(), k -> new HashMap()).computeIfAbsent(entry.bucket(), k -> new ArrayList()).add(entry.file());
            }
            return groupBy;
        }
    }
}

