/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.KeyValueSerializer;
import org.apache.flink.table.store.file.data.DataFilePathFactory;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class DataFileReader {
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkFormat<RowData, FileSourceSplit> readerFactory;
    private final DataFilePathFactory pathFactory;

    private DataFileReader(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, BulkFormat<RowData, FileSourceSplit> readerFactory, DataFilePathFactory pathFactory) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.readerFactory = readerFactory;
        this.pathFactory = pathFactory;
    }

    public RecordReader<KeyValue> read(String fileName) throws IOException {
        return new DataFileRecordReader(this.pathFactory.toPath(fileName));
    }

    public static class Factory {
        private final SchemaManager schemaManager;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final int[][] fullKeyProjection;
        private int[][] keyProjection;
        private int[][] valueProjection;
        private RowType projectedKeyType;
        private RowType projectedValueType;

        public Factory(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory) {
            this.schemaManager = schemaManager;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.fullKeyProjection = Projection.range(0, keyType.getFieldCount()).toNestedIndexes();
            this.keyProjection = this.fullKeyProjection;
            this.valueProjection = Projection.range(0, valueType.getFieldCount()).toNestedIndexes();
            this.applyProjection();
        }

        public Factory withKeyProjection(int[][] projection) {
            this.keyProjection = projection;
            this.applyProjection();
            return this;
        }

        public Factory withValueProjection(int[][] projection) {
            this.valueProjection = projection;
            this.applyProjection();
            return this;
        }

        public DataFileReader create(BinaryRowData partition, int bucket) {
            return this.create(partition, bucket, true, Collections.emptyList());
        }

        public DataFileReader create(BinaryRowData partition, int bucket, boolean projectKeys, List<Predicate> filters) {
            int[][] keyProjection = projectKeys ? this.keyProjection : this.fullKeyProjection;
            RowType projectedKeyType = projectKeys ? this.projectedKeyType : this.keyType;
            RowType recordType = KeyValue.schema(this.keyType, this.valueType);
            int[][] projection = KeyValue.project(keyProjection, this.valueProjection, this.keyType.getFieldCount());
            return new DataFileReader(this.schemaManager, this.schemaId, projectedKeyType, this.projectedValueType, this.fileFormat.createReaderFactory(recordType, projection, filters), this.pathFactory.createDataFilePathFactory(partition, bucket));
        }

        private void applyProjection() {
            this.projectedKeyType = (RowType)Projection.of(this.keyProjection).project((LogicalType)this.keyType);
            this.projectedValueType = (RowType)Projection.of(this.valueProjection).project((LogicalType)this.valueType);
        }
    }

    private static class DataFileRecordIterator
    implements RecordReader.RecordIterator<KeyValue> {
        private final BulkFormat.RecordIterator<RowData> iterator;
        private final KeyValueSerializer serializer;

        private DataFileRecordIterator(BulkFormat.RecordIterator<RowData> iterator, KeyValueSerializer serializer) {
            this.iterator = iterator;
            this.serializer = serializer;
        }

        @Override
        public KeyValue next() throws IOException {
            RecordAndPosition result = this.iterator.next();
            return result == null ? null : this.serializer.fromRow((RowData)result.getRecord());
        }

        @Override
        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }

    private class DataFileRecordReader
    implements RecordReader<KeyValue> {
        private final BulkFormat.Reader<RowData> reader;
        private final KeyValueSerializer serializer;

        private DataFileRecordReader(Path path) throws IOException {
            this.reader = FileUtils.createFormatReader((BulkFormat<RowData, FileSourceSplit>)DataFileReader.this.readerFactory, path);
            this.serializer = new KeyValueSerializer(DataFileReader.this.keyType, DataFileReader.this.valueType);
        }

        @Override
        @Nullable
        public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
            BulkFormat.RecordIterator iterator = this.reader.readBatch();
            return iterator == null ? null : new DataFileRecordIterator(iterator, this.serializer);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

