/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class ActivationClassBuilder
extends ExpressionClassBuilder {
    private LocalField targetResultSetField;
    private LocalField cursorResultSetField;
    private MethodBuilder closeActivationMethod;

    ActivationClassBuilder(String superClass, CompilerContext cc) throws StandardException {
        super(superClass, null, cc);
    }

    @Override
    public String getPackageName() {
        return "org.apache.derby.exe.";
    }

    @Override
    String getBaseClassName() {
        return "org.apache.derby.impl.sql.execute.BaseActivation";
    }

    @Override
    public int getRowCount() throws StandardException {
        return this.myCompCtx.getNumResultSets();
    }

    @Override
    public void setNumSubqueries() {
        int numSubqueries = this.myCompCtx.getNumSubquerys();
        if (numSubqueries == 0) {
            return;
        }
        this.constructor.pushThis();
        this.constructor.push(numSubqueries);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "numSubqueries", "int");
        this.constructor.endStatement();
    }

    MethodBuilder startResetMethod() {
        MethodBuilder mb = this.cb.newMethodBuilder(1, "void", "reset");
        mb.addThrownException("org.apache.derby.iapi.error.StandardException");
        mb.pushThis();
        mb.callMethod((short)183, "org.apache.derby.impl.sql.execute.BaseActivation", "reset", "void", 0);
        return mb;
    }

    void finishExecuteMethod() {
        if (this.executeMethod != null) {
            this.executeMethod.methodReturn();
            this.executeMethod.complete();
        }
        if (this.closeActivationMethod != null) {
            this.closeActivationMethod.methodReturn();
            this.closeActivationMethod.complete();
        }
    }

    void addCursorPositionCode() {
        MethodBuilder getter = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getTargetResultSet");
        getter.getField(this.targetResultSetField);
        getter.methodReturn();
        getter.complete();
        getter = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getCursorResultSet");
        getter.getField(this.cursorResultSetField);
        getter.methodReturn();
        getter.complete();
    }

    void rememberCursorTarget(MethodBuilder mb) {
        this.targetResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "targetResultSet", 2);
        mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.putField(this.targetResultSetField);
        mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
    }

    void rememberCursor(MethodBuilder mb) {
        this.cursorResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "cursorResultSet", 2);
        mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.putField(this.cursorResultSetField);
        mb.cast("org.apache.derby.iapi.sql.ResultSet");
    }

    @Override
    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        LocalField lf = super.getCurrentSetup();
        MethodBuilder execute = this.getExecuteMethod();
        execute.getField(lf);
        execute.callMethod((short)182, null, "forget", "void", 0);
        return lf;
    }

    MethodBuilder getCloseActivationMethod() {
        if (this.closeActivationMethod == null) {
            this.closeActivationMethod = this.cb.newMethodBuilder(1, "void", "closeActivationAction");
            this.closeActivationMethod.addThrownException("java.lang.Exception");
        }
        return this.closeActivationMethod;
    }
}

