/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapQuickSelectSketchTest {
    private final Family fam_ = Family.QUICKSELECT;

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 512;
        int u = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(9001L).setNominalEntries(512).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 512; ++i) {
            sk1.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)512);
        byte[] byteArray = usk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int k = 512;
        int u = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(9001L).setNominalEntries(512).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 512; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertEquals((double)usk.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)512);
        byte[] byteArray = usk.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray);
        seg.set(ValueLayout.JAVA_BYTE, 2L, (byte)0);
        ThetaSketch.heapify((MemorySegment)seg, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int k = 512;
        long seed1 = 1021L;
        long seed2 = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(1021L).setNominalEntries(512).build();
        byte[] byteArray = usk.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyCorruptLgNomLongs() {
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        MemorySegment srcSeg = MemorySegment.ofArray(usk.toByteArray());
        srcSeg.set(ValueLayout.JAVA_BYTE, 3L, (byte)2);
        ThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k = 512;
        int u = 512;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(9001L).setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCurrentBytes();
        byte[] byteArray = usk.toByteArray();
        Assert.assertEquals((int)bytes, (int)byteArray.length);
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
        Assert.assertEquals((double)usk2.getEstimate(), (double)512.0, (double)0.0);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)512.0, (double)0.0);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)512.0, (double)0.0);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
        Assert.assertEquals((Object)usk2.getResizeFactor(), (Object)usk.getResizeFactor());
        usk2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int k = 4096;
        int u = 8192;
        long seed = 9001L;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(9001L).setNominalEntries(4096).build();
        for (int i = 0; i < 8192; ++i) {
            usk.update((long)i);
        }
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)true);
        byte[] byteArray = usk.toByteArray();
        MemorySegment srcSeg = MemorySegment.ofArray(byteArray).asReadOnly();
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.heapify((MemorySegment)srcSeg, (long)9001L);
        Assert.assertEquals((double)usk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)usk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)usk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)usk2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)usk2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((String)usk2.getClass().getSimpleName(), (String)usk.getClass().getSimpleName());
        Assert.assertEquals((Object)usk2.getResizeFactor(), (Object)usk.getResizeFactor());
    }

    @Test
    public void checkHeapifyMemorySegmentEstimating() {
        int k = 512;
        int u = 1024;
        long seed = 9001L;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setFamily(this.fam_).setSeed(9001L).setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            sk1.update((long)i);
        }
        double sk1est = sk1.getEstimate();
        double sk1lb = sk1.getLowerBound(2);
        double sk1ub = sk1.getUpperBound(2);
        Assert.assertTrue((boolean)sk1.isEstimationMode());
        byte[] byteArray = sk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(byteArray).asReadOnly();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.heapify((MemorySegment)seg, (long)9001L);
        Assert.assertEquals((double)sk2.getEstimate(), (double)sk1est);
        Assert.assertEquals((double)sk2.getLowerBound(2), (double)sk1lb);
        Assert.assertEquals((double)sk2.getUpperBound(2), (double)sk1ub);
        Assert.assertEquals((boolean)sk2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)sk2.isEstimationMode());
        Assert.assertEquals((String)sk2.getClass().getSimpleName(), (String)sk1.getClass().getSimpleName());
    }

    @Test
    public void checkHQStoCompactForms() {
        int k = 512;
        int u = 2048;
        int maxBytes = 8192 + (Family.QUICKSELECT.getMinPreLongs() << 3);
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(512).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        Assert.assertFalse((boolean)usk.isOffHeap());
        Assert.assertFalse((boolean)usk.hasMemorySegment());
        Assert.assertFalse((boolean)usk.isCompact());
        Assert.assertFalse((boolean)usk.isOrdered());
        for (int i = 0; i < 2048; ++i) {
            usk.update((long)i);
        }
        sk1.rebuild();
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        int uskBytes = usk.getCurrentBytes();
        int uskCompBytes = usk.getCompactBytes();
        Assert.assertEquals((int)uskBytes, (int)maxBytes);
        Assert.assertTrue((boolean)usk.isEstimationMode());
        CompactThetaSketch comp1 = usk.compact(false, null);
        Assert.assertEquals((double)comp1.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp1.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp1.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp1.isEstimationMode());
        Assert.assertEquals((int)comp1.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactSketch");
        CompactThetaSketch comp2 = usk.compact(true, null);
        Assert.assertEquals((double)comp2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp2.isEstimationMode());
        Assert.assertEquals((int)comp2.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactSketch");
        byte[] segArr = new byte[uskCompBytes];
        MemorySegment seg = MemorySegment.ofArray(segArr);
        CompactThetaSketch comp3 = usk.compact(false, seg);
        Assert.assertEquals((double)comp3.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp3.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp3.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp3.isEstimationMode());
        Assert.assertEquals((int)comp3.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        Util.clear((MemorySegment)seg);
        CompactThetaSketch comp4 = usk.compact(true, seg);
        Assert.assertEquals((double)comp4.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)comp4.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)comp4.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertTrue((boolean)comp4.isEstimationMode());
        Assert.assertEquals((int)comp4.getCompactBytes(), (int)uskCompBytes);
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactSketch");
        comp4.toString(false, true, 0, false);
    }

    @Test
    public void checkHQStoCompactEmptyForms() {
        int k = 512;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X2).setNominalEntries(512).build();
        HeapQuickSelectSketchTest.println("lgArr: " + usk.getLgArrLongs());
        HeapQuickSelectSketchTest.println(usk.toString(false, true, 0, false));
        boolean estimating = false;
        Assert.assertEquals((String)usk.getClass().getSimpleName(), (String)"HeapQuickSelectSketch");
        double uskEst = usk.getEstimate();
        double uskLB = usk.getLowerBound(2);
        double uskUB = usk.getUpperBound(2);
        int currentUSBytes = usk.getCurrentBytes();
        Assert.assertEquals((int)currentUSBytes, (int)280);
        int compBytes = usk.getCompactBytes();
        Assert.assertEquals((int)compBytes, (int)8);
        Assert.assertEquals((boolean)usk.isEstimationMode(), (boolean)false);
        byte[] arr2 = new byte[compBytes];
        MemorySegment seg = MemorySegment.ofArray(arr2);
        CompactThetaSketch csk2 = usk.compact(false, seg);
        Assert.assertEquals((double)csk2.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)csk2.getClass().getSimpleName(), (String)"DirectCompactSketch");
        CompactThetaSketch csk3 = usk.compact(true, seg);
        HeapQuickSelectSketchTest.println(csk3.toString(false, true, 0, false));
        HeapQuickSelectSketchTest.println(csk3.toString());
        Assert.assertEquals((double)csk3.getEstimate(), (double)uskEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)uskLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)false);
        Assert.assertEquals((String)csk3.getClass().getSimpleName(), (String)"DirectCompactSketch");
    }

    @Test
    public void checkExactMode() {
        int k = 4096;
        int u = 4096;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(4096).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 4096; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((double)usk.getEstimate(), (double)4096.0, (double)0.0);
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)4096);
    }

    @Test
    public void checkEstMode() {
        int k = 4096;
        int u = 8192;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X4).setNominalEntries(4096).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 8192; ++i) {
            usk.update((long)i);
        }
        Assert.assertTrue((sk1.getRetainedEntries(false) > 4096 ? 1 : 0) != 0);
    }

    @Test
    public void checkSamplingMode() {
        int k = 4096;
        int u = 4096;
        float p = 0.5f;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setP(0.5f).setNominalEntries(4096).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        for (int i = 0; i < 4096; ++i) {
            usk.update((long)i);
        }
        double p2 = sk1.getP();
        double theta = sk1.getTheta();
        Assert.assertTrue((theta <= p2 ? 1 : 0) != 0);
        double est = usk.getEstimate();
        double kdbl = 4096.0;
        Assert.assertEquals((double)4096.0, (double)est, (double)204.8);
        double ub = usk.getUpperBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int k = 512;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(512).build();
        for (int i = 0; i < 512; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double lb = usk.getLowerBound(2);
        double ub = usk.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 5120;
        for (int i = 512; i < 5120; ++i) {
            usk.update((long)i);
            usk.update((long)i);
        }
        est = usk.getEstimate();
        lb = usk.getLowerBound(2);
        ub = usk.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkEmptyAndP() {
        int k = 1024;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(1024).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        usk.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)1);
        Assert.assertFalse((boolean)usk.isEmpty());
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setFamily(this.fam_).setP(0.001f).setNominalEntries(1024).build();
        sk1 = (HeapQuickSelectSketch)usk2;
        Assert.assertTrue((boolean)usk2.isEmpty());
        usk2.update(1L);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)0);
        Assert.assertFalse((boolean)usk2.isEmpty());
        double est = usk2.getEstimate();
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
        double ub = usk2.getUpperBound(2);
        Assert.assertTrue((ub > 0.0 ? 1 : 0) != 0);
        double lb = usk2.getLowerBound(2);
        Assert.assertTrue((lb <= est ? 1 : 0) != 0);
    }

    @Test
    public void checkUpperAndLowerBounds() {
        int k = 512;
        int u = 1024;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X2).setNominalEntries(512).build();
        for (int i = 0; i < 1024; ++i) {
            usk.update((long)i);
        }
        double est = usk.getEstimate();
        double ub = usk.getUpperBound(1);
        double lb = usk.getLowerBound(1);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((lb < est ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int k = 16;
        int u = 64;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setNominalEntries(16).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        Assert.assertFalse((boolean)usk.isEmpty());
        Assert.assertTrue((usk.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((sk1.getRetainedEntries(false) > 16 ? 1 : 0) != 0);
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)16);
        sk1.rebuild();
        Assert.assertEquals((int)sk1.getRetainedEntries(false), (int)16);
        Assert.assertEquals((int)sk1.getRetainedEntries(true), (int)16);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int k = 1024;
        int u = 4096;
        UpdatableThetaSketch usk = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X8).setNominalEntries(1024).build();
        HeapQuickSelectSketch sk1 = (HeapQuickSelectSketch)usk;
        Assert.assertTrue((boolean)usk.isEmpty());
        for (int i = 0; i < 4096; ++i) {
            usk.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)2048);
        sk1.reset();
        ResizeFactor rf = sk1.getResizeFactor();
        int subMul = ThetaUtil.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        UpdatableThetaSketch usk2 = UpdatableThetaSketch.builder().setFamily(this.fam_).setResizeFactor(ResizeFactor.X1).setNominalEntries(1024).build();
        sk1 = (HeapQuickSelectSketch)usk2;
        for (int i = 0; i < 4096; ++i) {
            usk2.update((long)i);
        }
        Assert.assertEquals((int)(1 << sk1.getLgArrLongs()), (int)2048);
        sk1.reset();
        rf = sk1.getResizeFactor();
        subMul = ThetaUtil.startingSubMultiple((int)11, (int)rf.lg(), (int)5);
        Assert.assertEquals((int)sk1.getLgArrLongs(), (int)subMul);
        Assert.assertNull((Object)sk1.getMemorySegment());
        Assert.assertFalse((boolean)sk1.isOrdered());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int k = 512;
        UpdatableThetaSketch qs = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(512).build();
        qs.hashUpdate(-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMinReqBytes() {
        int k = 16;
        UpdatableThetaSketch s1 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 64; ++i) {
            s1.update((long)i);
        }
        byte[] byteArray = s1.toByteArray();
        byte[] badBytes = Arrays.copyOfRange(byteArray, 0, 24);
        MemorySegment seg = MemorySegment.ofArray(badBytes);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThetaAndLgArrLongs() {
        int k = 16;
        UpdatableThetaSketch s1 = UpdatableThetaSketch.builder().setNominalEntries(16).build();
        for (int i = 0; i < 16; ++i) {
            s1.update((long)i);
        }
        byte[] badArray = s1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(badArray);
        PreambleUtil.insertLgArrLongs((MemorySegment)seg, (int)4);
        PreambleUtil.insertThetaLong((MemorySegment)seg, (long)0x3FFFFFFFFFFFFFFFL);
        ThetaSketch.heapify((MemorySegment)seg);
    }

    @Test
    public void checkFamily() {
        UpdatableThetaSketch sketch = UpdatableThetaSketch.builder().build();
        Assert.assertEquals((Object)sketch.getFamily(), (Object)Family.QUICKSELECT);
    }

    @Test
    public void checkSegSerDeExceptions() {
        int k = 1024;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setFamily(Family.QUICKSELECT).setNominalEntries(1024).build();
        sk1.update(1L);
        byte[] bytearray1 = sk1.toByteArray();
        MemorySegment seg = MemorySegment.ofArray(bytearray1);
        long pre0 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 0L);
        HeapQuickSelectSketchTest.tryBadSeg(seg, 0, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapQuickSelectSketchTest.tryBadSeg(seg, 1, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapQuickSelectSketchTest.tryBadSeg(seg, 2, 1);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapQuickSelectSketchTest.tryBadSeg(seg, 5, 2);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        HeapQuickSelectSketchTest.tryBadSeg(seg, 2, 4);
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, pre0);
        long origThetaLong = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L);
        try {
            seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, 0x3FFFFFFFFFFFFFFFL);
            HeapQuickSelectSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        seg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, origThetaLong);
        byte[] byteArray2 = new byte[bytearray1.length - 1];
        MemorySegment seg2 = MemorySegment.ofArray(byteArray2);
        MemorySegment.copy(seg, 0L, seg2, 0L, seg2.byteSize());
        try {
            HeapQuickSelectSketch.heapifyInstance((MemorySegment)seg2, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        PreambleUtil.insertLgResizeFactor((MemorySegment)seg, (int)ResizeFactor.X1.lg());
        HeapQuickSelectSketch hqss = HeapQuickSelectSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
        Assert.assertEquals((Object)hqss.getResizeFactor(), (Object)ResizeFactor.X2);
    }

    private static void tryBadSeg(MemorySegment seg, int byteOffset, int byteValue) {
        try {
            seg.set(ValueLayout.JAVA_BYTE, (long)byteOffset, (byte)byteValue);
            HeapQuickSelectSketch.heapifyInstance((MemorySegment)seg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        HeapQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

