/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIteratorAPI;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesSketchIteratorTest {
    @Test
    public void emptySketch() {
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
        sketch.update(0.0);
        QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)it.getQuantile(), (double)0.0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            UpdatableQuantilesDoublesSketch sketch = QuantilesDoublesSketch.builder().build();
            for (int i = 0; i < n; ++i) {
                sketch.update((double)i);
            }
            QuantilesDoublesSketchIteratorAPI it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

