/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.daffodil.api.Compiler;
import org.apache.daffodil.api.InputSourceDataInputStream;
import org.apache.daffodil.api.debugger.DaffodilDebuggerRunner;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.api.infoset.InfosetInputter;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.api.infoset.JDOMInfosetOutputter;
import org.apache.daffodil.api.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.api.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.api.infoset.XMLTextEscapeStyle;
import org.apache.daffodil.core.dsom.ExpressionCompilers$;
import org.apache.daffodil.runtime1.debugger.DaffodilDebugger;
import org.apache.daffodil.runtime1.debugger.TraceDebuggerRunner;
import org.apache.daffodil.runtime1.infoset.JDOMInfosetInputter;
import org.apache.daffodil.runtime1.infoset.JsonInfosetInputter;
import org.apache.daffodil.runtime1.infoset.JsonInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.NullInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.runtime1.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetInputter;
import org.apache.daffodil.runtime1.infoset.XMLTextInfosetOutputter;
import org.jdom2.Document;
import scala.xml.Node;

public class Daffodil {
    private Daffodil() {
    }

    public static Compiler compiler() {
        return org.apache.daffodil.core.compiler.Compiler.apply(true);
    }

    public static ScalaXMLInfosetOutputter newScalaXMLInfosetOutputter() {
        return new org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter(false);
    }

    public static InfosetOutputter newXMLTextInfosetOutputter(OutputStream outputStream, boolean bl) {
        return new XMLTextInfosetOutputter(outputStream, bl, XMLTextEscapeStyle.Standard, false);
    }

    public static InfosetOutputter newXMLTextInfosetOutputter(OutputStream outputStream, boolean bl, XMLTextEscapeStyle xMLTextEscapeStyle) {
        return new XMLTextInfosetOutputter(outputStream, bl, xMLTextEscapeStyle, false);
    }

    public static InfosetOutputter newJsonInfosetOutputter(OutputStream outputStream, boolean bl) {
        return new JsonInfosetOutputter(outputStream, bl);
    }

    public static JDOMInfosetOutputter newJDOMInfosetOutputter() {
        return new org.apache.daffodil.runtime1.infoset.JDOMInfosetOutputter();
    }

    public static W3CDOMInfosetOutputter newW3CDOMInfosetOutputter() {
        return new org.apache.daffodil.runtime1.infoset.W3CDOMInfosetOutputter();
    }

    public static InfosetOutputter newNullInfosetOutputter() {
        return new NullInfosetOutputter();
    }

    public static InfosetInputter newScalaXMLInfosetInputter(Node node) {
        return new ScalaXMLInfosetInputter(node);
    }

    public static InfosetInputter newXMLTextInfosetInputter(InputStream inputStream) {
        return new XMLTextInfosetInputter(inputStream);
    }

    public static InfosetInputter newJsonInfosetInputter(InputStream inputStream) {
        return new JsonInfosetInputter(inputStream);
    }

    public static InfosetInputter newJDOMInfosetInputter(Document document) {
        return new JDOMInfosetInputter(document);
    }

    public static InfosetInputter newW3CDOMInfosetInputter(org.w3c.dom.Document document) {
        return new W3CDOMInfosetInputter(document);
    }

    public static InputSourceDataInputStream newInputSourceDataInputStream(InputStream inputStream) {
        return org.apache.daffodil.io.InputSourceDataInputStream.apply(inputStream);
    }

    public static InputSourceDataInputStream newInputSourceDataInputStream(ByteBuffer byteBuffer) {
        return org.apache.daffodil.io.InputSourceDataInputStream.apply(byteBuffer);
    }

    public static InputSourceDataInputStream newInputSourceDataInputStream(byte[] byArray) {
        return org.apache.daffodil.io.InputSourceDataInputStream.apply(byArray);
    }

    public static Debugger newDaffodilDebugger(DaffodilDebuggerRunner daffodilDebuggerRunner) {
        return new DaffodilDebugger(daffodilDebuggerRunner, ExpressionCompilers$.MODULE$);
    }

    public static Debugger newTraceDebugger(PrintStream printStream) {
        return Daffodil.newDaffodilDebugger(new TraceDebuggerRunner(printStream));
    }

    public static enum InfosetInputterEventType {
        StartDocument,
        EndDocument,
        StartElement,
        EndElement;

    }
}

