/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet.grmm;

import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.learning.GenericAcrfTui;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.jar.SequenceClassifierBuilder_ImplBase;
import org.cleartk.ml.mallet.grmm.GrmmClassifier;

public class GrmmClassifierBuilder
extends SequenceClassifierBuilder_ImplBase<GrmmClassifier, List<NameNumber>, String[], String[]> {
    private static String DEFAULT_MODEL_FILENAME = "acrf.model.ser.gz";
    private static String JAR_ENTRY_MODEL = "model.grmm";
    private static String JAR_ENTRY_OUTCOME_EXAMPLE = "dummy.outcome";
    protected ACRF acrf;
    protected String outcomeExample;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.grmm");
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        if (dir == null || !dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("invalid directory \"%s\"", dir));
        }
        if (args == null || args.length == 0 || args[0] == null) {
            throw new IllegalArgumentException("missing template file in \"args\"");
        }
        File template = new File(dir, args[0]);
        if (!template.exists()) {
            String msg = "template file \"%s\" does not exist!";
            throw new IllegalArgumentException(String.format(msg, template));
        }
        File outputFile = new File(dir, DEFAULT_MODEL_FILENAME);
        String inferencer = args.length < 2 ? "LoopyBP" : args[1];
        String maxInferencer = args.length < 3 ? "LoopyBP.createForMaxProduct()" : args[2];
        String[] grmmArgs = new String[]{"--training", new File(dir, "training-data.grmm").getAbsolutePath(), "--testing", new File(dir, "training-data.grmm").getAbsolutePath(), "--model-file", template.getAbsolutePath(), "--inferencer", inferencer, "--max-inferencer", maxInferencer};
        GenericAcrfTui.main((String[])grmmArgs);
        Files.move((File)new File("acrf.ser.gz"), (File)outputFile.getAbsoluteFile());
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        File model = new File(dir, DEFAULT_MODEL_FILENAME);
        File trainingData = new File(dir, "training-data.grmm");
        if (!model.exists()) {
            String msg = "model file \"%s\" not found";
            throw new IllegalArgumentException(String.format(msg, model));
        }
        if (!trainingData.exists()) {
            String msg = "training data file \"%s\" not found";
            throw new IllegalArgumentException(String.format(msg, trainingData));
        }
        LineNumberReader lnr = new LineNumberReader(new FileReader(trainingData));
        this.outcomeExample = lnr.readLine().split("----")[0];
        lnr.close();
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)JAR_ENTRY_MODEL, (File)model);
        modelStream.putNextEntry(new JarEntry(JAR_ENTRY_OUTCOME_EXAMPLE));
        new ObjectOutputStream(modelStream).writeObject(this.outcomeExample);
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        try {
            JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)JAR_ENTRY_MODEL);
            this.acrf = (ACRF)new ObjectInputStream(new GZIPInputStream(modelStream)).readObject();
            JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)JAR_ENTRY_OUTCOME_EXAMPLE);
            this.outcomeExample = (String)new ObjectInputStream(modelStream).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected GrmmClassifier newClassifier() {
        return new GrmmClassifier((FeaturesEncoder<List<NameNumber>>)this.featuresEncoder, (OutcomeEncoder<String[], String[]>)this.outcomeEncoder, this.acrf, this.outcomeExample);
    }
}

