/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.consumer.UmlsConceptCreator;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.uima.jcas.JCas;

public final class DefaultUmlsConceptCreator
implements UmlsConceptCreator {
    private static final Logger LOGGER = Logger.getLogger("DefaultUmlsConceptCreator");

    @Override
    public Collection<UmlsConcept> createUmlsConcepts(JCas jcas, String codingScheme, String tui, Concept concept) {
        ArrayList<UmlsConcept> concepts = new ArrayList<UmlsConcept>();
        for (String codeName : concept.getCodeNames()) {
            Collection<String> codes;
            if (codeName.equals("TUI") || (codes = concept.getCodes(codeName)) == null || codes.isEmpty()) continue;
            for (String code : codes) {
                concepts.add(DefaultUmlsConceptCreator.createUmlsConcept(jcas, codeName, concept.getCui(), tui, concept.getPreferredText(), code));
            }
        }
        if (concepts.isEmpty()) {
            concepts.add(DefaultUmlsConceptCreator.createUmlsConcept(jcas, codingScheme, concept.getCui(), tui, concept.getPreferredText(), null));
        }
        return concepts;
    }

    private static UmlsConcept createUmlsConcept(JCas jcas, String codingScheme, String cui, String tui, String preferredText, String code) {
        UmlsConcept umlsConcept = new UmlsConcept(jcas);
        umlsConcept.setCodingScheme(codingScheme);
        umlsConcept.setCui(cui);
        if (tui != null) {
            umlsConcept.setTui(tui);
        }
        if (preferredText != null && !preferredText.isEmpty()) {
            umlsConcept.setPreferredText(preferredText);
        }
        if (code != null) {
            umlsConcept.setCode(code);
        }
        return umlsConcept;
    }
}

