/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.dependency.parser.util.DependencyPath;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class DependencyPathRegexpFeatureExtractor
implements FeatureExtractor1<IdentifiedAnnotation> {
    HashMap<String, Integer> patts = new HashMap();

    public DependencyPathRegexpFeatureExtractor() throws FileNotFoundException {
        File pathFile = FileLocator.locateFile((String)"org/apache/ctakes/assertion/models/uncDepPathRegexps.txt");
        Scanner scanner = new Scanner(pathFile);
        while (scanner.hasNextLine()) {
            String[] featAndWeight = scanner.nextLine().trim().split("\t");
            String feat = featAndWeight[0];
            Double weight = Double.parseDouble(featAndWeight[1]);
            int val = this.patts.size();
            this.patts.put(feat, val);
        }
        scanner.close();
    }

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation mention) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        boolean sentWeight = false;
        ConllDependencyNode node = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)mention);
        List sentNodes = DependencyUtility.getDependencyNodes((JCas)jcas, (Annotation)DependencyUtility.getSentence((JCas)jcas, (Annotation)node));
        for (ConllDependencyNode neighborNode : sentNodes) {
            DependencyPath path;
            String pathString;
            if (node == neighborNode || !this.patts.containsKey(pathString = (path = DependencyUtility.getPath((List)sentNodes, (ConllDependencyNode)node, (ConllDependencyNode)neighborNode)).toString().replace('\n', ' ').replaceFirst("\\{[^\\}]+\\}", "{CONCEPT}").replace(' ', '_'))) continue;
            feats.add(new Feature("DepPathRegexp" + this.patts.get(pathString), (Object)true));
        }
        return feats;
    }
}

