/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.eval;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.eval.AnnotationStatisticsCompact;
import org.apache.ctakes.assertion.eval.MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas;
import org.apache.ctakes.assertion.eval.XMIReader;
import org.apache.ctakes.assertion.medfacts.ConceptConverterAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.AlternateCuePhraseAnnotator;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.ConditionalCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.EncoderReusingDataWriter;
import org.apache.ctakes.assertion.medfacts.cleartk.GenericCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.HistoryCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityFedaCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.SubjectCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.UncertaintyCleartkAnalysisEngine;
import org.apache.ctakes.assertion.pipelines.GoldEntityAndAttributeReaderPipelineForSeedCorpus;
import org.apache.ctakes.core.ae.DocumentIdPrinterAnalysisEngine;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.ContractionToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.NumToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.syntax.SymbolToken;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.NoOpAnnotator;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.CasIOUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.Evaluation_ImplBase;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.transform.InstanceDataWriter;
import org.cleartk.ml.feature.transform.InstanceStream;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;

public class AssertionEvaluation
extends Evaluation_ImplBase<File, Map<String, AnnotationStatisticsCompact<String>>> {
    private static Logger logger = Logger.getLogger(AssertionEvaluation.class);
    private static final String YTEX_NEGATION_DESCRIPTOR = "ytex.uima.NegexAnnotator";
    protected ArrayList<String> annotationTypes;
    private Class<? extends DataWriter<String>> dataWriterClass;
    private File evaluationOutputDirectory;
    public static String evaluationLogFilePath = "eval_" + new Date().toString().replaceAll(" ", "_") + ".txt";
    private static File evaluationLogFile;
    private static BufferedWriter evaluationLogFileOut;
    public static boolean useEvaluationLogFile;
    private boolean ignoreAnatomicalSites = false;
    protected static Options options;
    private String[] trainingArguments;
    public static final String GOLD_VIEW_NAME = "GoldView";

    public static void main(String[] args) throws Exception {
        System.out.println("Started assertion module at " + new Date());
        AssertionEvaluation.resetOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        if (useEvaluationLogFile && evaluationLogFileOut == null) {
            evaluationLogFile = new File(evaluationLogFilePath);
            evaluationLogFileOut = new BufferedWriter(new FileWriter(evaluationLogFile), 32768);
        }
        AssertionEvaluation.printOptionsForDebugging(options);
        ArrayList<File> trainFiles = new ArrayList<File>();
        if (null != AssertionEvaluation.options.trainDirectory) {
            String[] dirs;
            for (String dir : dirs = AssertionEvaluation.options.trainDirectory.split("[;:]")) {
                File trainDir = new File(dir);
                if (trainDir.listFiles() == null) continue;
                for (File f : trainDir.listFiles()) {
                    trainFiles.add(f);
                }
            }
        }
        File modelsDir = AssertionEvaluation.options.modelsDirectory;
        if (AssertionEvaluation.options.useTmp) {
            File tempModelDir = new File(AssertionEvaluation.options.modelsDirectory, "temp");
            tempModelDir.mkdirs();
            File curModelDir = File.createTempFile("assertion", null, tempModelDir);
            curModelDir.delete();
            curModelDir.mkdir();
            modelsDir = curModelDir;
        }
        File evaluationOutputDirectory = AssertionEvaluation.options.evaluationOutputDirectory;
        ArrayList<String> annotationTypes = new ArrayList<String>();
        if (!AssertionEvaluation.options.ignorePolarity) {
            annotationTypes.add("polarity");
        }
        if (!AssertionEvaluation.options.ignoreConditional) {
            annotationTypes.add("conditional");
        }
        if (!AssertionEvaluation.options.ignoreUncertainty) {
            annotationTypes.add("uncertainty");
        }
        if (!AssertionEvaluation.options.ignoreSubject) {
            annotationTypes.add("subject");
        }
        if (!AssertionEvaluation.options.ignoreGeneric) {
            annotationTypes.add("generic");
        }
        if (!AssertionEvaluation.options.ignoreHistory) {
            annotationTypes.add("historyOf");
        }
        String[] kernelParams = null;
        kernelParams = AssertionEvaluation.options.kernelParams != null ? AssertionEvaluation.options.kernelParams.split("\\s+") : new String[]{"-c", "1.0"};
        Class<EncoderReusingDataWriter> dw = null;
        if (AssertionEvaluation.options.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.STK || AssertionEvaluation.options.featConfig == AssertionCleartkAnalysisEngine.FEATURE_CONFIG.PTK) {
            throw new UnsupportedOperationException("This requires cleartk-2.0 which");
        }
        dw = EncoderReusingDataWriter.class;
        AssertionEvaluation evaluation = new AssertionEvaluation(modelsDir, evaluationOutputDirectory, annotationTypes, dw, kernelParams);
        if (AssertionEvaluation.options.preprocessDir != null) {
            AssertionEvaluation.preprocess(AssertionEvaluation.options.preprocessDir);
        } else if (AssertionEvaluation.options.crossValidationFolds != null) {
            List foldStats = evaluation.crossValidation(trainFiles, AssertionEvaluation.options.crossValidationFolds);
            TreeMap<String, AnnotationStatisticsCompact<String>> overallStats = new TreeMap<String, AnnotationStatisticsCompact<String>>();
            for (String currentAnnotationType : annotationTypes) {
                AnnotationStatisticsCompact currentAnnotationStatisticsCompact = new AnnotationStatisticsCompact();
                overallStats.put(currentAnnotationType, currentAnnotationStatisticsCompact);
            }
            for (Object singleFoldMap : foldStats) {
                for (String currentAnnotationType : annotationTypes) {
                    AnnotationStatisticsCompact currentFoldStatistics = (AnnotationStatisticsCompact)singleFoldMap.get(currentAnnotationType);
                    ((AnnotationStatisticsCompact)overallStats.get(currentAnnotationType)).addAll(currentFoldStatistics);
                }
            }
            AssertionEvaluation.printScore(overallStats, "CROSS FOLD OVERALL");
        } else if (Math.abs(AssertionEvaluation.options.portionOfDataToUse - 1.0) > 0.001) {
            int numIters = 5;
            List<File> testFiles = Arrays.asList(AssertionEvaluation.options.testDirectory.listFiles());
            TreeMap<String, Double> overallStats = new TreeMap<String, Double>();
            for (String annotationType : annotationTypes) {
                overallStats.put(annotationType, 0.0);
            }
            for (int iter = 0; iter < numIters; ++iter) {
                Map stats = (Map)evaluation.trainAndTest(trainFiles, testFiles);
                AssertionEvaluation.printScore(stats, "Sample " + iter + " score:");
                for (String annotationType : stats.keySet()) {
                    overallStats.put(annotationType, (Double)overallStats.get(annotationType) + ((AnnotationStatisticsCompact)stats.get(annotationType)).f1("-1"));
                }
            }
            for (String annotationType : annotationTypes) {
                System.out.println("Macro-average F-score for " + annotationType + " is: " + (Double)overallStats.get(annotationType) / (double)numIters);
            }
        } else {
            List<File> testFiles;
            if (AssertionEvaluation.options.evalOnly) {
                testFiles = Arrays.asList(AssertionEvaluation.options.evaluationOutputDirectory.listFiles());
                logger.debug((Object)("evalOnly using files in directory " + evaluationOutputDirectory.getName() + " aka " + evaluationOutputDirectory.getCanonicalPath()));
            } else {
                testFiles = AssertionEvaluation.options.trainOnly ? new ArrayList<File>() : Arrays.asList(AssertionEvaluation.options.testDirectory.listFiles());
            }
            if (!AssertionEvaluation.options.testOnly && !AssertionEvaluation.options.evalOnly) {
                CollectionReader trainCollectionReader = evaluation.getCollectionReader(trainFiles);
                evaluation.train(trainCollectionReader, modelsDir);
            }
            if (!AssertionEvaluation.options.trainOnly) {
                if (testFiles == null || testFiles.size() == 0) {
                    throw new RuntimeException("testFiles = " + testFiles + " testFiles.size() = " + (testFiles == null ? "null" : Integer.valueOf(testFiles.size())));
                }
                logger.debug((Object)("testFiles.size() = " + testFiles.size()));
                CollectionReader testCollectionReader = evaluation.getCollectionReader(testFiles);
                Object stats = evaluation.test(testCollectionReader, modelsDir);
                AssertionEvaluation.printScore((Map<String, AnnotationStatisticsCompact<String>>)stats, modelsDir != null ? modelsDir.getAbsolutePath() : "no_model");
            }
        }
        if (AssertionEvaluation.options.useTmp && modelsDir != null) {
            FileUtils.deleteRecursive((File)modelsDir);
        }
        System.out.println("Finished assertion module at " + new Date());
    }

    private static void resetOptions() {
        AssertionEvaluation.options.ignoreConditional = false;
        AssertionEvaluation.options.ignoreGeneric = false;
        AssertionEvaluation.options.ignoreHistory = false;
        AssertionEvaluation.options.ignorePolarity = false;
        AssertionEvaluation.options.ignoreSubject = false;
        AssertionEvaluation.options.ignoreUncertainty = false;
        AssertionEvaluation.options.trainOnly = false;
        AssertionEvaluation.options.testOnly = false;
        AssertionEvaluation.options.noCleartk = false;
        AssertionEvaluation.options.printErrors = false;
        AssertionEvaluation.options.printInstances = null;
        AssertionEvaluation.options.evalOnly = false;
        AssertionEvaluation.options.evaluationOutputDirectory = null;
        AssertionEvaluation.options.trainDirectory = null;
        AssertionEvaluation.options.testDirectory = null;
        AssertionEvaluation.options.devDirectory = null;
        AssertionEvaluation.options.modelsDirectory = null;
        AssertionEvaluation.options.preprocessDir = null;
        AssertionEvaluation.options.crossValidationFolds = null;
    }

    private static void printOptionsForDebugging(Options optionsArg) {
        String message = String.format("Printing options: %ntraining dir: %s%ntest dir: %s%nmodel dir: %s%npreprocess dir: %s%nevaluation output dir: %s%ncross-validation: %d%nignore polarity: %b%nignore conditional: %b%nignore uncertainty: %b%nignore subject: %b%nignore generic: %b%nignore history: %b%ntrain only: %b%ntest only: %b%neval only: %b%nnoCleartk: %b%n%n%n", optionsArg.trainDirectory, optionsArg.testDirectory != null ? optionsArg.testDirectory.getAbsolutePath() : "", optionsArg.modelsDirectory != null ? optionsArg.modelsDirectory.getAbsolutePath() : "", optionsArg.preprocessDir != null ? optionsArg.preprocessDir.getAbsolutePath() : "", optionsArg.evaluationOutputDirectory != null ? optionsArg.evaluationOutputDirectory.getAbsolutePath() : "", optionsArg.crossValidationFolds, optionsArg.ignorePolarity, optionsArg.ignoreConditional, optionsArg.ignoreUncertainty, optionsArg.ignoreSubject, optionsArg.ignoreGeneric, optionsArg.ignoreHistory, optionsArg.trainOnly, optionsArg.testOnly, optionsArg.evalOnly, optionsArg.noCleartk);
        logger.info((Object)message);
    }

    public static void printScore(Map<String, AnnotationStatisticsCompact<String>> map, String directory) {
        for (Map.Entry<String, AnnotationStatisticsCompact<String>> currentEntry : map.entrySet()) {
            String annotationType = currentEntry.getKey();
            AnnotationStatisticsCompact<String> stats = currentEntry.getValue();
            System.out.format("directory: \"%s\"; assertion type: %s%n%s%n%s%n%n", directory, annotationType.toUpperCase(), AssertionEvaluation.options.testDirectory, stats.toString());
            try {
                if (!useEvaluationLogFile) continue;
                evaluationLogFileOut.write(String.format("%s\t%f\t%s\t%s\t%s", annotationType, AssertionEvaluation.options.featureSelectionThreshold, AssertionEvaluation.options.modelsDirectory.getName(), AssertionEvaluation.options.testDirectory.toString(), stats.toTsv()));
                evaluationLogFileOut.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public AssertionEvaluation(File modelDirectory, File evaluationOutputDirectory, ArrayList<String> annotationTypes, Class<? extends DataWriter<String>> dataWriterClass, String ... trainingArguments) {
        super(modelDirectory);
        this.annotationTypes = annotationTypes;
        this.dataWriterClass = dataWriterClass;
        this.trainingArguments = trainingArguments;
        this.evaluationOutputDirectory = evaluationOutputDirectory;
    }

    public CollectionReader getCollectionReader(List<File> items) throws ResourceInitializationException {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath((String[])new String[0]), (Object[])new Object[]{"files", paths});
    }

    public static void preprocess(File rawDir) throws ResourceInitializationException, UIMAException, IOException {
        File preprocessedDir = null;
        if (AssertionEvaluation.options.trainDirectory.split("[;]").length > 1) {
            throw new IOException("Assertion preprocess wants to write to one train directory, but you've supplied multiple: " + AssertionEvaluation.options.trainDirectory);
        }
        preprocessedDir = new File(AssertionEvaluation.options.trainDirectory);
        if (AssertionEvaluation.options.corpus == Corpus.I2B2) {
            GoldEntityAndAttributeReaderPipelineForSeedCorpus.readI2B2Challenge2010(rawDir, preprocessedDir);
        } else if (AssertionEvaluation.options.corpus == Corpus.MIPACQ) {
            GoldEntityAndAttributeReaderPipelineForSeedCorpus.readMiPACQ(rawDir, preprocessedDir, AssertionEvaluation.options.testDirectory, AssertionEvaluation.options.devDirectory);
        } else if (AssertionEvaluation.options.corpus == Corpus.NEGEX) {
            GoldEntityAndAttributeReaderPipelineForSeedCorpus.readNegexTestSet(rawDir, preprocessedDir);
        } else if (AssertionEvaluation.options.corpus == Corpus.SHARP_STRATIFIED) {
            GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpStratifiedUmls(rawDir, preprocessedDir, AssertionEvaluation.options.testDirectory, AssertionEvaluation.options.devDirectory);
        } else if (AssertionEvaluation.options.corpus == Corpus.SHARP_SEED) {
            GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpSeedUmls(rawDir, preprocessedDir, AssertionEvaluation.options.testDirectory, AssertionEvaluation.options.devDirectory);
        } else {
            throw new ResourceInitializationException("No corpus type specified!", new Object[]{rawDir});
        }
    }

    public void train(CollectionReader collectionReader, File directory) throws Exception {
        if (AssertionEvaluation.options.noCleartk) {
            return;
        }
        AggregateBuilder builder = new AggregateBuilder();
        AnalysisEngineDescription goldCopierIdentifiedAnnotsAnnotator = AnalysisEngineFactory.createEngineDescription(ReferenceIdentifiedAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierIdentifiedAnnotsAnnotator, new String[0]);
        AnalysisEngineDescription goldCopierSupportingAnnotsAnnotator = AnalysisEngineFactory.createEngineDescription(ReferenceSupportingAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierSupportingAnnotsAnnotator, new String[0]);
        AnalysisEngineDescription assertionAttributeClearerAnnotator = AnalysisEngineFactory.createEngineDescription(ReferenceAnnotationsSystemAssertionClearer.class, (Object[])new Object[0]);
        builder.add(assertionAttributeClearerAnnotator, new String[0]);
        Float featureSelectionThreshold = AssertionEvaluation.options.featureSelectionThreshold;
        Class<? extends DataWriter<String>> dataWriterClassFirstPass = this.getDataWriterClass();
        if (AssertionEvaluation.options.featureSelectionThreshold == null) {
            featureSelectionThreshold = Float.valueOf(0.0f);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(AlternateCuePhraseAnnotator.class, (Object[])new Object[0]), new String[0]);
        if (!AssertionEvaluation.options.ignorePolarity) {
            AnalysisEngineDescription polarityAnnotator;
            if (AssertionEvaluation.options.useYtexNegation) {
                polarityAnnotator = AnalysisEngineFactory.createEngineDescription((String)YTEX_NEGATION_DESCRIPTOR, (Object[])new Object[0]);
            } else {
                if (AssertionEvaluation.options.feda) {
                    polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityFedaCleartkAnalysisEngine.class, (Object[])new Object[0]);
                    ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"mapTrainFileToDomain", AssertionEvaluation.options.trainDirectory});
                } else {
                    polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityCleartkAnalysisEngine.class, (Object[])new Object[0]);
                }
                ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "polarity").getPath(), "FeatureSelectionURI", PolarityCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "polarity")), "WhetherToDoFeatureSelection", featureSelectionThreshold, "FEATURE_CONFIG", AssertionEvaluation.options.featConfig, "PortionOfDataToUse", Float.valueOf((float)AssertionEvaluation.options.portionOfDataToUse)});
            }
            builder.add(polarityAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreConditional) {
            AnalysisEngineDescription conditionalAnnotator = AnalysisEngineFactory.createEngineDescription(ConditionalCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)conditionalAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "conditional").getPath(), "FeatureSelectionURI", ConditionalCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "conditional")), "WhetherToDoFeatureSelection", featureSelectionThreshold});
            builder.add(conditionalAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreUncertainty) {
            AnalysisEngineDescription uncertaintyAnnotator = AnalysisEngineFactory.createEngineDescription(UncertaintyCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)uncertaintyAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "uncertainty").getPath(), "FeatureSelectionURI", UncertaintyCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "uncertainty")), "WhetherToDoFeatureSelection", featureSelectionThreshold, "FEATURE_CONFIG", AssertionEvaluation.options.featConfig});
            builder.add(uncertaintyAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreSubject) {
            AnalysisEngineDescription subjectAnnotator = AnalysisEngineFactory.createEngineDescription(SubjectCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)subjectAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "subject").getPath(), "FeatureSelectionURI", SubjectCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "subject")), "WhetherToDoFeatureSelection", featureSelectionThreshold});
            builder.add(subjectAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreGeneric) {
            AnalysisEngineDescription genericAnnotator = AnalysisEngineFactory.createEngineDescription(GenericCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)genericAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "generic").getPath(), "FeatureSelectionURI", GenericCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "generic")), "WhetherToDoFeatureSelection", featureSelectionThreshold});
            builder.add(genericAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreHistory) {
            AnalysisEngineDescription historyAnnotator = AnalysisEngineFactory.createEngineDescription(HistoryCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)historyAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "dataWriterClassName", dataWriterClassFirstPass, "outputDirectory", new File(directory, "historyOf").getPath(), "FeatureSelectionURI", HistoryCleartkAnalysisEngine.createFeatureSelectionURI(new File(directory, "historyOf")), "WhetherToDoFeatureSelection", featureSelectionThreshold});
            builder.add(historyAnnotator, new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        for (String currentAssertionAttribute : this.annotationTypes) {
            File currentDirectory = new File(directory, currentAssertionAttribute);
            this.trainAndPackage(currentAssertionAttribute, currentDirectory, this.trainingArguments);
        }
    }

    protected Map<String, AnnotationStatisticsCompact<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        AnalysisEngineDescription goldCopierAnnotator = AnalysisEngineFactory.createEngineDescription(ReferenceIdentifiedAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierAnnotator, new String[0]);
        AnalysisEngineDescription assertionAttributeClearerAnnotator = AnalysisEngineFactory.createEngineDescription(ReferenceAnnotationsSystemAssertionClearer.class, (Object[])new Object[0]);
        builder.add(assertionAttributeClearerAnnotator, new String[0]);
        AnalysisEngineDescription documentIdPrinterAnnotator = AnalysisEngineFactory.createEngineDescription(DocumentIdPrinterAnalysisEngine.class, (Object[])new Object[0]);
        builder.add(documentIdPrinterAnnotator, new String[0]);
        if (AssertionEvaluation.options.noCleartk) {
            AssertionEvaluation.addExternalAttributeAnnotatorsToAggregate(builder);
        } else {
            AssertionEvaluation.addCleartkAttributeAnnotatorsToAggregate(directory, builder);
        }
        if (AssertionEvaluation.options.evalOnly && this.evaluationOutputDirectory != null) {
            builder = new AggregateBuilder();
            TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
            AnalysisEngineDescription noOp = AnalysisEngineFactory.createEngineDescription(NoOpAnnotator.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[0]);
            builder.add(noOp, new String[0]);
            AnalysisEngineDescription mergeGold = AnalysisEngineFactory.createEngineDescription(MergeGoldViewFromOneCasIntoInitialViewOfAnotherCas.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[0]);
            builder.add(mergeGold, new String[0]);
        }
        AnalysisEngine aggregate = builder.createAggregate();
        AnnotationStatisticsCompact<String> polarityStats = new AnnotationStatisticsCompact<String>();
        AnnotationStatisticsCompact<String> conditionalStats = new AnnotationStatisticsCompact<String>();
        AnnotationStatisticsCompact<String> uncertaintyStats = new AnnotationStatisticsCompact<String>();
        AnnotationStatisticsCompact<String> subjectStats = new AnnotationStatisticsCompact<String>();
        AnnotationStatisticsCompact<String> genericStats = new AnnotationStatisticsCompact<String>();
        AnnotationStatisticsCompact<String> historyStats = new AnnotationStatisticsCompact<String>();
        TreeMap<String, AnnotationStatisticsCompact<String>> map = new TreeMap<String, AnnotationStatisticsCompact<String>>();
        if (!AssertionEvaluation.options.ignorePolarity) {
            map.put("polarity", polarityStats);
        }
        if (!AssertionEvaluation.options.ignoreConditional) {
            map.put("conditional", conditionalStats);
        }
        if (!AssertionEvaluation.options.ignoreUncertainty) {
            map.put("uncertainty", uncertaintyStats);
        }
        if (!AssertionEvaluation.options.ignoreSubject) {
            map.put("subject", subjectStats);
        }
        if (!AssertionEvaluation.options.ignoreGeneric) {
            map.put("generic", genericStats);
        }
        if (!AssertionEvaluation.options.ignoreHistory) {
            map.put("historyOf", historyStats);
        }
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregate});
        while (casIter.hasNext()) {
            JCas goldView;
            JCas jCas = (JCas)casIter.next();
            try {
                goldView = jCas.getView(GOLD_VIEW_NAME);
            }
            catch (CASException e) {
                logger.info((Object)("jCas.getViewName() = " + jCas.getViewName()));
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList<IdentifiedAnnotation> goldEntitiesAndEvents = new ArrayList<IdentifiedAnnotation>();
            if (!this.ignoreAnatomicalSites) {
                Collection goldEntities = JCasUtil.select((JCas)goldView, EntityMention.class);
                goldEntitiesAndEvents.addAll(goldEntities);
            }
            Collection goldEvents = JCasUtil.select((JCas)goldView, EventMention.class);
            goldEntitiesAndEvents.addAll(goldEvents);
            if (goldEntitiesAndEvents.size() == 0) {
                Collection identifiedAnnotations = JCasUtil.select((JCas)goldView, IdentifiedAnnotation.class);
                goldEntitiesAndEvents.addAll(identifiedAnnotations);
            }
            ArrayList<IdentifiedAnnotation> systemEntitiesAndEvents = new ArrayList<IdentifiedAnnotation>();
            if (!this.ignoreAnatomicalSites) {
                Collection systemEntities = JCasUtil.select((JCas)jCas, EntityMention.class);
                systemEntitiesAndEvents.addAll(systemEntities);
            }
            Collection systemEvents = JCasUtil.select((JCas)jCas, EventMention.class);
            systemEntitiesAndEvents.addAll(systemEvents);
            if (this.evaluationOutputDirectory != null) {
                String sourceFileName = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
                CasIOUtil.writeXmi((JCas)jCas, (File)new File(this.evaluationOutputDirectory, sourceFileName + ".xmi"));
            }
            if (!AssertionEvaluation.options.ignorePolarity) {
                polarityStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("polarity"));
                if (AssertionEvaluation.options.printErrors) {
                    AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "polarity", -1, Integer.class);
                }
                if (AssertionEvaluation.options.printInstances != null) {
                    AssertionEvaluation.printInstances(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "polarity", -1, Integer.class, AssertionEvaluation.options.printInstances);
                }
            }
            if (!AssertionEvaluation.options.ignoreConditional) {
                conditionalStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("conditional"));
                if (AssertionEvaluation.options.printErrors) {
                    AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "conditional", true, Boolean.class);
                }
            }
            if (!AssertionEvaluation.options.ignoreUncertainty) {
                uncertaintyStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("uncertainty"));
                if (AssertionEvaluation.options.printErrors) {
                    AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "uncertainty", 1, Integer.class);
                }
            }
            if (!AssertionEvaluation.options.ignoreSubject) {
                subjectStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("subject"));
                if (AssertionEvaluation.options.printErrors) {
                    AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "subject", null, "patient".getClass());
                }
            }
            if (!AssertionEvaluation.options.ignoreGeneric) {
                genericStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("generic"));
                if (AssertionEvaluation.options.printErrors) {
                    AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "generic", true, Boolean.class);
                }
            }
            if (AssertionEvaluation.options.ignoreHistory) continue;
            historyStats.add(goldEntitiesAndEvents, systemEntitiesAndEvents, AnnotationStatisticsCompact.annotationToSpan(), AnnotationStatisticsCompact.annotationToFeatureValue("historyOf"));
            if (!AssertionEvaluation.options.printErrors) continue;
            AssertionEvaluation.printErrors(jCas, goldEntitiesAndEvents, systemEntitiesAndEvents, "historyOf", 1, Integer.class);
        }
        return map;
    }

    protected void trainAndPackage(String currentAssertionAttribute, File directory, String[] arguments) throws Exception {
        if (AssertionEvaluation.options.featureSelectionThreshold != null) {
            FeatureSelection<String> featureSelection;
            Iterable instances = InstanceStream.loadFromDirectory((File)directory);
            if (currentAssertionAttribute.equals("polarity")) {
                featureSelection = PolarityCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(PolarityCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else if (currentAssertionAttribute.equals("uncertainty")) {
                featureSelection = UncertaintyCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(UncertaintyCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else if (currentAssertionAttribute.equals("conditional")) {
                featureSelection = ConditionalCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(ConditionalCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else if (currentAssertionAttribute.equals("subject")) {
                featureSelection = SubjectCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(SubjectCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else if (currentAssertionAttribute.equals("generic")) {
                featureSelection = GenericCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(GenericCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else if (currentAssertionAttribute.equals("historyOf")) {
                featureSelection = HistoryCleartkAnalysisEngine.createFeatureSelection(AssertionEvaluation.options.featureSelectionThreshold.floatValue());
                featureSelection.train(instances);
                featureSelection.save(HistoryCleartkAnalysisEngine.createFeatureSelectionURI(directory));
            } else {
                Object featureSelection2 = null;
                throw new Exception("Feature selection is still null!");
            }
            Constructor<? extends DataWriter<String>> c = this.dataWriterClass.getConstructor(File.class);
            DataWriter<String> dataWriter = c.newInstance(directory);
            for (Instance instance : instances) {
                dataWriter.write(featureSelection.transform((Instance<String>)instance));
            }
            dataWriter.finish();
        }
        JarClassifierBuilder.trainAndPackage((File)directory, (String[])arguments);
    }

    protected Class<? extends DataWriter<String>> getDataWriterClass() {
        return AssertionEvaluation.options.featureSelectionThreshold != null ? StringInstanceDataWriter.class : this.dataWriterClass;
    }

    private static void printErrors(JCas jCas, Collection<IdentifiedAnnotation> goldEntitiesAndEvents, Collection<IdentifiedAnnotation> systemEntitiesAndEvents, String classifierType, Object trueCategory, Class<? extends Object> categoryClass) throws ResourceProcessException {
        String documentId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        HashMap goldMap = Maps.newHashMap();
        for (IdentifiedAnnotation identifiedAnnotation : goldEntitiesAndEvents) {
            goldMap.put(new HashableAnnotation((Annotation)identifiedAnnotation), identifiedAnnotation);
        }
        HashMap systemMap = Maps.newHashMap();
        for (IdentifiedAnnotation relation : systemEntitiesAndEvents) {
            systemMap.put(new HashableAnnotation((Annotation)relation), relation);
        }
        Sets.SetView setView = Sets.union(goldMap.keySet(), systemMap.keySet());
        ArrayList sorted = Lists.newArrayList((Iterable)setView);
        Collections.sort(sorted);
        for (HashableAnnotation key : sorted) {
            Feature feature;
            IdentifiedAnnotation goldAnnotation = (IdentifiedAnnotation)goldMap.get(key);
            IdentifiedAnnotation systemAnnotation = (IdentifiedAnnotation)systemMap.get(key);
            Object goldLabel = null;
            Object systemLabel = null;
            if (goldAnnotation == null) {
                logger.debug((Object)(key + " not found in gold annotations "));
            } else {
                feature = goldAnnotation.getType().getFeatureByBaseName(classifierType);
                goldLabel = AssertionEvaluation.getFeatureValue(feature, categoryClass, (Annotation)goldAnnotation);
            }
            if (systemAnnotation == null) {
                logger.info((Object)(key + " not found in system annotations "));
            } else {
                feature = systemAnnotation.getType().getFeatureByBaseName(classifierType);
                systemLabel = AssertionEvaluation.getFeatureValue(feature, categoryClass, (Annotation)systemAnnotation);
            }
            String typeId = systemAnnotation != null ? systemAnnotation.getTypeID() + "" : "X";
            if (goldLabel == null) {
                logger.debug((Object)("Skipping annotation with label " + systemLabel + " because gold label is null"));
                continue;
            }
            if (systemLabel == null) {
                logger.debug((Object)("Skipping annotation with label " + systemLabel + " because system label is null"));
                continue;
            }
            if (!goldLabel.equals(systemLabel)) {
                if (trueCategory == null) {
                    System.out.println(classifierType + " " + systemLabel + "(" + goldLabel + "): " + AssertionEvaluation.formatError(jCas, systemAnnotation));
                    continue;
                }
                if (systemLabel.equals(trueCategory)) {
                    System.out.println(classifierType + " FP: " + typeId + " " + AssertionEvaluation.formatError(jCas, systemAnnotation) + "| gold:|" + AssertionEvaluation.formatError(jCas, goldAnnotation) + " " + documentId);
                    continue;
                }
                System.out.println(classifierType + " FN: " + typeId + " " + AssertionEvaluation.formatError(jCas, goldAnnotation) + "| system:|" + AssertionEvaluation.formatError(jCas, systemAnnotation) + " " + documentId);
                continue;
            }
            if (trueCategory == null) {
                System.out.println(classifierType + " " + systemLabel + "(" + goldLabel + "): " + AssertionEvaluation.formatError(jCas, systemAnnotation));
                continue;
            }
            if (systemLabel.equals(trueCategory)) {
                System.out.println(classifierType + " TP: " + typeId + " " + AssertionEvaluation.formatError(jCas, systemAnnotation) + "| gold:|" + AssertionEvaluation.formatError(jCas, goldAnnotation) + " " + documentId);
                continue;
            }
            System.out.println(classifierType + " TN: " + typeId + " " + AssertionEvaluation.formatError(jCas, systemAnnotation) + "| gold:|" + AssertionEvaluation.formatError(jCas, goldAnnotation) + " " + documentId);
        }
    }

    private static void printInstances(JCas jCas, Collection<IdentifiedAnnotation> goldEntitiesAndEvents, Collection<IdentifiedAnnotation> systemEntitiesAndEvents, String classifierType, Object trueCategory, Class<? extends Object> categoryClass, File outputfile) throws ResourceProcessException, IOException {
        String documentId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        HashMap goldMap = Maps.newHashMap();
        for (IdentifiedAnnotation identifiedAnnotation : goldEntitiesAndEvents) {
            goldMap.put(new HashableAnnotation((Annotation)identifiedAnnotation), identifiedAnnotation);
        }
        HashMap systemMap = Maps.newHashMap();
        for (IdentifiedAnnotation relation : systemEntitiesAndEvents) {
            systemMap.put(new HashableAnnotation((Annotation)relation), relation);
        }
        Sets.SetView setView = Sets.union(goldMap.keySet(), systemMap.keySet());
        ArrayList sorted = Lists.newArrayList((Iterable)setView);
        Collections.sort(sorted);
        try (BufferedWriter fileOutWriter = new BufferedWriter(new FileWriter(outputfile, true), 32768);){
            for (HashableAnnotation key : sorted) {
                Feature feature;
                IdentifiedAnnotation goldAnnotation = (IdentifiedAnnotation)goldMap.get(key);
                IdentifiedAnnotation systemAnnotation = (IdentifiedAnnotation)systemMap.get(key);
                Object goldLabel = null;
                Object systemLabel = null;
                if (goldAnnotation == null) {
                    logger.debug((Object)(key + " not found in gold annotations "));
                } else {
                    feature = goldAnnotation.getType().getFeatureByBaseName(classifierType);
                    goldLabel = AssertionEvaluation.getFeatureValue(feature, categoryClass, (Annotation)goldAnnotation);
                }
                if (systemAnnotation == null) {
                    logger.info((Object)(key + " not found in system annotations "));
                } else {
                    feature = systemAnnotation.getType().getFeatureByBaseName(classifierType);
                    systemLabel = AssertionEvaluation.getFeatureValue(feature, categoryClass, (Annotation)systemAnnotation);
                }
                String typeId = "X";
                String typeName = "IdentifiedAnnotation";
                String subject = "";
                String coveredText = "";
                String instanceData = "";
                if (systemAnnotation != null && systemAnnotation.getEnd() >= 0) {
                    typeId = systemAnnotation.getTypeID() + "";
                    typeName = systemAnnotation.getClass().getSimpleName();
                    int polarity = systemAnnotation.getPolarity();
                    int uncertainty = systemAnnotation.getUncertainty();
                    boolean conditional = systemAnnotation.getConditional();
                    boolean generic = systemAnnotation.getGeneric();
                    subject = systemAnnotation.getSubject();
                    int historyOf = systemAnnotation.getHistoryOf();
                    coveredText = systemAnnotation.getCoveredText().replaceAll("\\n", " ").replaceAll(",", ";");
                    instanceData = documentId + "," + polarity + "," + uncertainty + "," + conditional + "," + generic + "," + subject + "," + historyOf + "," + typeId + "," + typeName + "," + coveredText;
                }
                if (goldLabel == null) {
                    logger.debug((Object)("Skipping annotation with label " + systemLabel + " because gold label is null"));
                    continue;
                }
                if (systemLabel == null) {
                    logger.debug((Object)("Skipping annotation with label " + systemLabel + " because system label is null"));
                    continue;
                }
                if (instanceData.equals("")) continue;
                if (!goldLabel.equals(systemLabel)) {
                    if (trueCategory == null) {
                        fileOutWriter.write(classifierType + ",F," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                    } else if (systemLabel.equals(trueCategory)) {
                        fileOutWriter.write(classifierType + ",FP," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                    } else {
                        fileOutWriter.write(classifierType + ",FN," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                    }
                } else if (trueCategory == null) {
                    fileOutWriter.write(classifierType + ",T," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                } else if (systemLabel.equals(trueCategory)) {
                    fileOutWriter.write(classifierType + ",TP," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                } else {
                    fileOutWriter.write(classifierType + ",TN," + systemLabel + "," + goldLabel + "," + instanceData + "\n");
                }
                fileOutWriter.flush();
            }
        }
    }

    private static Object getFeatureValue(Feature feature, Class<? extends Object> class1, Annotation annotation) throws ResourceProcessException {
        if (class1 == Integer.class) {
            return annotation.getIntValue(feature);
        }
        if (class1 == String.class) {
            return annotation.getStringValue(feature);
        }
        if (class1 == Boolean.class) {
            return annotation.getBooleanValue(feature);
        }
        throw new ResourceProcessException("Received a class type that I'm not familiar with: ", new Object[]{class1});
    }

    private static String formatError(JCas jcas, IdentifiedAnnotation mention) {
        List context = JCasUtil.selectCovering((JCas)jcas, Sentence.class, (int)mention.getBegin(), (int)mention.getEnd());
        StringBuffer buff = new StringBuffer();
        if (context.size() > 0) {
            Sentence sent = (Sentence)context.get(0);
            buff.append(sent.getCoveredText());
            long offset = mention.getBegin() - sent.getBegin();
            if (offset >= Integer.MAX_VALUE || offset <= Integer.MIN_VALUE) {
                offset = 0L;
            }
            buff.insert((int)offset, "***");
            buff.insert((int)(offset += (long)(mention.getEnd() - mention.getBegin() + 3)), "***");
        }
        return buff.toString();
    }

    private static void addExternalAttributeAnnotatorsToAggregate(AggregateBuilder builder) throws UIMAException, IOException {
        builder.add(AnalysisEngineFactory.createEngineDescription(ConceptConverterAnalysisEngine.class, (Object[])new Object[0]), new String[0]);
        AnalysisEngineDescription oldAssertionAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/assertionAnalysisEngine", (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)oldAssertionAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME});
        builder.add(oldAssertionAnnotator, new String[0]);
        AnalysisEngineDescription oldConversionAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/conceptConverterAnalysisEngine", (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)oldConversionAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME});
        builder.add(oldConversionAnnotator, new String[0]);
        AnalysisEngineDescription oldSubjectAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/SubjectAttributeAnalysisEngine", (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)oldSubjectAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME});
        builder.add(oldSubjectAnnotator, new String[0]);
        AnalysisEngineDescription oldGenericAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/GenericAttributeAnalysisEngine", (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)oldGenericAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME});
        builder.add(oldGenericAnnotator, new String[0]);
    }

    private static void addCleartkAttributeAnnotatorsToAggregate(File directory, AggregateBuilder builder) throws UIMAException, IOException, ResourceInitializationException {
        builder.add(AnalysisEngineFactory.createEngineDescription(AlternateCuePhraseAnnotator.class, (Object[])new Object[0]), new String[0]);
        if (!AssertionEvaluation.options.ignorePolarity) {
            AnalysisEngineDescription polarityAnnotator;
            if (AssertionEvaluation.options.useYtexNegation) {
                polarityAnnotator = AnalysisEngineFactory.createEngineDescription((String)YTEX_NEGATION_DESCRIPTOR, (Object[])new Object[0]);
                builder.add(polarityAnnotator, new String[0]);
            } else {
                if (AssertionEvaluation.options.feda) {
                    polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityFedaCleartkAnalysisEngine.class, (Object[])new Object[0]);
                    ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"mapTrainFileToDomain", AssertionEvaluation.options.testDirectory});
                } else {
                    polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityCleartkAnalysisEngine.class, (Object[])new Object[0]);
                }
                ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "polarity"), "model.jar").getPath(), "FEATURE_CONFIG", AssertionEvaluation.options.featConfig});
                builder.add(polarityAnnotator, new String[0]);
            }
        }
        if (!AssertionEvaluation.options.ignoreConditional) {
            AnalysisEngineDescription conditionalAnnotator = AnalysisEngineFactory.createEngineDescription(ConditionalCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)conditionalAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "conditional"), "model.jar").getPath()});
            builder.add(conditionalAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreUncertainty) {
            AnalysisEngineDescription uncertaintyAnnotator = AnalysisEngineFactory.createEngineDescription(UncertaintyCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)uncertaintyAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "uncertainty"), "model.jar").getPath()});
            builder.add(uncertaintyAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreSubject) {
            AnalysisEngineDescription subjectAnnotator = AnalysisEngineFactory.createEngineDescription(SubjectCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)subjectAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "subject"), "model.jar").getPath()});
            builder.add(subjectAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreGeneric) {
            AnalysisEngineDescription genericAnnotator = AnalysisEngineFactory.createEngineDescription(GenericCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)genericAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "generic"), "model.jar").getPath()});
            builder.add(genericAnnotator, new String[0]);
        }
        if (!AssertionEvaluation.options.ignoreHistory) {
            AnalysisEngineDescription historyAnnotator = AnalysisEngineFactory.createEngineDescription(HistoryCleartkAnalysisEngine.class, (Object[])new Object[0]);
            ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)historyAnnotator, (Object[])new Object[]{"GoldViewName", GOLD_VIEW_NAME, "classifierJarPath", new File(new File(directory, "historyOf"), "model.jar").getPath()});
            builder.add(historyAnnotator, new String[0]);
        }
    }

    static {
        useEvaluationLogFile = false;
        options = new Options();
    }

    public static class ReferenceAnnotationsSystemAssertionClearer
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EntityMention entityMention : JCasUtil.select((JCas)jCas, EntityMention.class)) {
                entityMention.setPolarity(1);
            }
            for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
                eventMention.setPolarity(1);
            }
        }
    }

    public static class ReferenceSupportingAnnotationsSystemToGoldCopier
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            try {
                goldView = jCas.getView(AssertionEvaluation.GOLD_VIEW_NAME);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (Sentence oldSystemSentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
                Sentence newGoldSentence = new Sentence(goldView, oldSystemSentence.getBegin(), oldSystemSentence.getEnd());
                newGoldSentence.addToIndexes();
            }
            for (BaseToken oldSystemToken : JCasUtil.select((JCas)jCas, BaseToken.class)) {
                Object newGoldToken = null;
                String oldSystemTokenClass = oldSystemToken.getClass().getName();
                newGoldToken = oldSystemTokenClass.equals(WordToken.class.getName()) ? new WordToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(ContractionToken.class.getName()) ? new ContractionToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(NewlineToken.class.getName()) ? new NewlineToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(NumToken.class.getName()) ? new NumToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(PunctuationToken.class.getName()) ? new PunctuationToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(SymbolToken.class.getName()) ? new SymbolToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : (oldSystemTokenClass.equals(BaseToken.class.getName()) ? new BaseToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd()) : new BaseToken(goldView, oldSystemToken.getBegin(), oldSystemToken.getEnd())))))));
                newGoldToken.setPartOfSpeech(oldSystemToken.getPartOfSpeech());
                newGoldToken.setTokenNumber(oldSystemToken.getTokenNumber());
                newGoldToken.addToIndexes();
            }
        }
    }

    public static class ReferenceIdentifiedAnnotationsSystemToGoldCopier
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            try {
                goldView = jCas.createView(AssertionEvaluation.GOLD_VIEW_NAME);
                goldView.setSofaDataString(jCas.getSofaDataString(), jCas.getSofaMimeType());
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (EntityMention oldSystemEntityMention : JCasUtil.select((JCas)jCas, EntityMention.class)) {
                EntityMention newGoldEntityMention = new EntityMention(goldView, oldSystemEntityMention.getBegin(), oldSystemEntityMention.getEnd());
                newGoldEntityMention.setDiscoveryTechnique(oldSystemEntityMention.getDiscoveryTechnique());
                newGoldEntityMention.setUncertainty(oldSystemEntityMention.getUncertainty());
                newGoldEntityMention.setConditional(oldSystemEntityMention.getConditional());
                newGoldEntityMention.setGeneric(oldSystemEntityMention.getGeneric());
                newGoldEntityMention.setPolarity(oldSystemEntityMention.getPolarity());
                newGoldEntityMention.setSubject(oldSystemEntityMention.getSubject());
                newGoldEntityMention.setHistoryOf(oldSystemEntityMention.getHistoryOf());
                newGoldEntityMention.setConfidence(oldSystemEntityMention.getConfidence());
                newGoldEntityMention.setTypeID(oldSystemEntityMention.getTypeID());
                newGoldEntityMention.addToIndexes();
            }
            for (EventMention oldSystemEventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
                EventMention newGoldEventMention = new EventMention(goldView, oldSystemEventMention.getBegin(), oldSystemEventMention.getEnd());
                newGoldEventMention.setDiscoveryTechnique(oldSystemEventMention.getDiscoveryTechnique());
                newGoldEventMention.setUncertainty(oldSystemEventMention.getUncertainty());
                newGoldEventMention.setConditional(oldSystemEventMention.getConditional());
                newGoldEventMention.setGeneric(oldSystemEventMention.getGeneric());
                newGoldEventMention.setPolarity(oldSystemEventMention.getPolarity());
                newGoldEventMention.setSubject(oldSystemEventMention.getSubject());
                newGoldEventMention.setHistoryOf(oldSystemEventMention.getHistoryOf());
                newGoldEventMention.setConfidence(oldSystemEventMention.getConfidence());
                newGoldEventMention.setTypeID(oldSystemEventMention.getTypeID());
                newGoldEventMention.addToIndexes();
            }
        }
    }

    public static class ReplaceCTakesEntityMentionsAndModifiersWithGold
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView(AssertionEvaluation.GOLD_VIEW_NAME);
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList cTakesMentions = new ArrayList();
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, EntityMention.class));
            cTakesMentions.addAll(JCasUtil.select((JCas)systemView, Modifier.class));
            for (IdentifiedAnnotation cTakesMention : cTakesMentions) {
                cTakesMention.removeFromIndexes();
            }
            ArrayList goldMentions = new ArrayList();
            goldMentions.addAll(JCasUtil.select((JCas)goldView, EntityMention.class));
            goldMentions.addAll(JCasUtil.select((JCas)goldView, Modifier.class));
            CasCopier copier = new CasCopier(goldView.getCas(), systemView.getCas());
            for (IdentifiedAnnotation goldMention : goldMentions) {
                Annotation copy = (Annotation)copier.copyFs((FeatureStructure)goldMention);
                Feature sofaFeature = copy.getType().getFeatureByBaseName("sofa");
                copy.setFeatureValue(sofaFeature, (FeatureStructure)systemView.getSofa());
                copy.addToIndexes();
            }
        }
    }

    public static class OnlyGoldAssertions
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            try {
                goldView = jCas.getView(AssertionEvaluation.GOLD_VIEW_NAME);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (EntityMention entityMention : JCasUtil.select((JCas)jCas, EntityMention.class)) {
                entityMention.removeFromIndexes();
            }
            for (EntityMention entityMention : JCasUtil.select((JCas)goldView, EntityMention.class)) {
                EntityMention newEntityMention = new EntityMention(jCas, entityMention.getBegin(), entityMention.getEnd());
                newEntityMention.setTypeID(entityMention.getTypeID());
                newEntityMention.setId(entityMention.getId());
                newEntityMention.setDiscoveryTechnique(entityMention.getDiscoveryTechnique());
                newEntityMention.setConfidence(entityMention.getConfidence());
                newEntityMention.addToIndexes();
            }
        }
    }

    public static class HashableAnnotation
    implements Comparable<HashableAnnotation> {
        protected int begin;
        protected int end;

        public HashableAnnotation(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public HashableAnnotation(Annotation arg1) {
            this(arg1.getBegin(), arg1.getEnd());
        }

        public boolean equals(Object otherObject) {
            boolean result = false;
            if (otherObject instanceof HashableAnnotation) {
                HashableAnnotation other = (HashableAnnotation)otherObject;
                result = this.getClass() == other.getClass() && this.begin == other.begin && this.end == other.end;
            }
            return result;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.begin, this.end});
        }

        public String toString() {
            return String.format("%s(%s,%s)", this.getClass().getSimpleName(), this.begin, this.end);
        }

        @Override
        public int compareTo(HashableAnnotation that) {
            int thisBegin = this.begin;
            int thatBegin = that.begin;
            if (thisBegin < thatBegin) {
                return -1;
            }
            if (thisBegin > thatBegin) {
                return 1;
            }
            if (this.equals(that)) {
                return 0;
            }
            return 1;
        }
    }

    class StringInstanceDataWriter
    extends InstanceDataWriter<String> {
        public StringInstanceDataWriter(File outputDirectory) throws IOException {
            super(outputDirectory);
        }
    }

    public static class Options {
        @Option(name="--train-dir", usage="specify the directory containing the XMI training files (for example, /NLP/Corpus/Relations/mipacq/xmi/train)", required=false)
        public String trainDirectory;
        @Option(name="--test-dir", usage="specify the directory containing the XMI testing files (for example, /NLP/Corpus/Relations/mipacq/xmi/test)", required=false)
        public File testDirectory;
        @Option(name="--dev-dir", usage="if running --preprocess, store the XMI development files here", required=false)
        public File devDirectory;
        @Option(name="--models-dir", usage="specify the directory where the models will be placed", required=false)
        public File modelsDirectory;
        @Option(name="--evaluation-output-dir", usage="specify the directory where the evaluation output xmi files will go", required=false)
        public File evaluationOutputDirectory;
        @Option(name="--ignore-polarity", usage="specify whether polarity processing should be ignored (true or false). default: false", required=false)
        public boolean ignorePolarity = false;
        @Option(name="--ignore-conditional", usage="specify whether conditional processing should be ignored (true or false). default: false", required=false)
        public boolean ignoreConditional = false;
        @Option(name="--ignore-uncertainty", usage="specify whether uncertainty processing should be ignored (true or false). default: false", required=false)
        public boolean ignoreUncertainty = false;
        @Option(name="--ignore-subject", usage="specify whether subject processing should be ignored (true or false). default: false", required=false, handler=BooleanOptionHandler.class)
        public boolean ignoreSubject = false;
        @Option(name="--ignore-generic", usage="specify whether generic processing should be ignored (true or false). default: false", required=false)
        public boolean ignoreGeneric = false;
        @Option(name="--ignore-history", usage="specify whether 'history of' processing should be run (true or false). default: false", required=false)
        public boolean ignoreHistory = false;
        @Option(name="--cross-validation", usage="ignore the test set and run n-fold cross-validation. default: n=2", required=false)
        public Integer crossValidationFolds;
        @Option(name="--train-only", usage="do not test a model, build one from xmi output and store in --models-dir", required=false)
        public boolean trainOnly = false;
        @Option(name="--test-only", usage="do not train a model, use the one specified in --models-dir", required=false)
        public boolean testOnly = false;
        @Option(name="--preprocess-only", usage="run preprocessing pipeline on a SHARP-style corpus, specify root directory", required=false)
        public File preprocessDir;
        @Option(name="--no-cleartk", usage="run the version of the assertion module released with cTAKES 2.5", required=false)
        public boolean noCleartk = false;
        @Option(name="--print-errors", usage="Flag to have test method print out error context for misclassified examples", required=false)
        public boolean printErrors = false;
        @Option(name="--print-instances", usage="Flag to have test method print out lots of info for statistical significance testing", required=false)
        public File printInstances;
        @Option(name="--eval-only", usage="Evaluate a CASes (supply the directory as an argument) with both system and gold in them.", required=false)
        public boolean evalOnly;
        @Option(name="--ytex-negation", usage="Use the negation detection from ytex, which is based on a more recent NegEx than the original cTAKES used. Note that using this requires adding the directory for YTEX_NEGATION_DESCRIPTOR to the classpath as well as the annotator class itself, since ytex is under a different license than Apache cTAKES.", required=false)
        public boolean useYtexNegation;
        @Option(name="--feature-selection", usage="Takes an argument: the Chi^2 feature selection threshold", required=false)
        public Float featureSelectionThreshold = null;
        @Option(name="--kernel-params", usage="Set of parameters to pass to kernel (libsvm)", required=false)
        public String kernelParams = null;
        @Option(name="--use-tmp", usage="Whether to put trained models into a temp directory (e.g., for a grid search)", required=false)
        public boolean useTmp = false;
        @Option(name="--corpus", usage="What corpus to read for pre-processing", required=false)
        public Corpus corpus = Corpus.SHARP_SEED;
        @Option(name="--feats", usage="What feature configuration to use", required=false)
        public AssertionCleartkAnalysisEngine.FEATURE_CONFIG featConfig = AssertionCleartkAnalysisEngine.FEATURE_CONFIG.ALL_SYN;
        @Option(name="--feda", usage="Domain adaptation -- for each semicolon-separated directory in train-dir, creates a domain-specific feature space", required=false)
        public boolean feda = false;
        @Option(name="--portion", usage="Learning curve building -- what percentage of the training data to train on.", required=false)
        public double portionOfDataToUse = 1.0;
    }

    static enum Corpus {
        SHARP_SEED,
        SHARP_STRATIFIED,
        MIPACQ,
        I2B2,
        NEGEX;

    }
}

