/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.eval;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.DocTimeRelAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.temporal.eval.I2B2Data;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.temporal.keras.KerasStringOutcomeDataWriter;
import org.apache.ctakes.temporal.nn.ae.EventEventTokenBasedAnnotator;
import org.apache.ctakes.temporal.nn.ae.EventTimeTokenBasedAnnotator;
import org.apache.ctakes.temporal.utils.AnnotationIdCollection;
import org.apache.ctakes.temporal.utils.TLinkTypeArray2;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.util.ViewUriUtil;

public class EvaluationOfNeuralEEAndETRelations
extends EvaluationOfTemporalRelations_ImplBase {
    protected static EvaluationOfEventTimeRelations.ParameterSettings flatParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "linear", 10.0, 1.0, "linear", CompositeKernel.ComboOperator.VECTOR_ONLY, DEFAULT_TK, DEFAULT_LAMBDA);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allBagsParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 100.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings allParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 10.0, 1.0, "polynomial", CompositeKernel.ComboOperator.SUM, 0.1, 0.5);
    protected static EvaluationOfEventTimeRelations.ParameterSettings ftParams = new EvaluationOfEventTimeRelations.ParameterSettings(DEFAULT_BOTH_DIRECTIONS, DEFAULT_DOWNSAMPLE, "tk", 1.0, 0.1, "radial basis function", CompositeKernel.ComboOperator.SUM, 0.5, 0.5);
    private static Boolean recallModeEvaluation = true;
    private boolean baseline;
    protected boolean useClosure;
    protected boolean useGoldAttributes;
    protected boolean skipTrain = false;
    public boolean skipWrite = false;
    private boolean writeProbabilities = false;
    protected boolean testOnTrain = false;

    public static void main(String[] args) throws Exception {
        TempRelOptions options = (TempRelOptions)CliFactory.parseArguments(TempRelOptions.class, (String[])args);
        List<Integer> trainItems = null;
        List<Integer> devItems = null;
        List<Integer> testItems = null;
        List<Integer> patientSets = options.getPatients().getList();
        if (options.getXMLFormat() == Evaluation_ImplBase.XMLFormat.I2B2) {
            trainItems = I2B2Data.getTrainPatientSets(options.getXMLDirectory());
            devItems = I2B2Data.getDevPatientSets(options.getXMLDirectory());
            testItems = I2B2Data.getTestPatientSets(options.getXMLDirectory());
        } else {
            trainItems = THYMEData.getPatientSets(patientSets, options.getTrainRemainders().getList());
            devItems = THYMEData.getPatientSets(patientSets, options.getDevRemainders().getList());
            testItems = THYMEData.getPatientSets(patientSets, options.getTestRemainders().getList());
        }
        EvaluationOfEventTimeRelations.ParameterSettings params = allParams;
        try {
            File workingDir = new File("target/eval/thyme/");
            if (!workingDir.exists()) {
                workingDir.mkdirs();
            }
            if (options.getUseTmp()) {
                File tempModelDir = File.createTempFile("temporal", null, workingDir);
                tempModelDir.delete();
                tempModelDir.mkdir();
                workingDir = tempModelDir;
            }
            EvaluationOfNeuralEEAndETRelations evaluation = new EvaluationOfNeuralEEAndETRelations(workingDir, options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory(), options.getTreebankDirectory(), options.getClosure(), options.getPrintErrors(), options.getPrintFormattedRelations(), options.getBaseline(), options.getUseGoldAttributes(), options.getKernelParams(), params);
            if (options.getI2B2Output() != null) {
                evaluation.setI2B2Output(options.getI2B2Output() + "/temporal-relations/both");
            }
            if (options.getAnaforaOutput() != null) {
                evaluation.anaforaOutput = options.getAnaforaOutput();
            }
            List<Integer> training = trainItems;
            List<Integer> testing = null;
            if (options.getTest()) {
                training.addAll(devItems);
                testing = testItems;
            } else {
                testing = devItems;
            }
            evaluation.skipTrain = options.getSkipTrain();
            evaluation.skipWrite = options.getSkipWrite();
            if (evaluation.skipTrain && options.getTest()) {
                evaluation.prepareXMIsFor(testing);
            } else {
                evaluation.prepareXMIsFor(patientSets);
            }
            evaluation.writeProbabilities = options.getWriteProbabilities();
            Collections.sort(training);
            Collections.sort(testing);
            evaluation.testOnTrain = options.getTestOnTrain();
            params.stats = evaluation.testOnTrain ? (AnnotationStatistics)evaluation.trainAndTest(training, training) : (AnnotationStatistics)evaluation.trainAndTest(training, testing);
            System.err.println(params.stats);
            if (options.getUseTmp()) {
                FileUtils.deleteRecursive((File)workingDir);
            }
        }
        catch (ResourceInitializationException e) {
            System.err.println("Error with parameter settings: " + params);
            e.printStackTrace();
        }
    }

    public EvaluationOfNeuralEEAndETRelations(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory, File treebankDirectory, boolean useClosure, boolean printErrors, boolean printRelations, boolean baseline, boolean useGoldAttributes, String kernelParams, EvaluationOfEventTimeRelations.ParameterSettings params) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, treebankDirectory, printErrors, printRelations, params);
        this.params = params;
        this.useClosure = useClosure;
        this.printErrors = printErrors;
        this.printRelations = printRelations;
        this.useGoldAttributes = useGoldAttributes;
        this.baseline = baseline;
        this.kernelParams = kernelParams == null ? null : kernelParams.split(" ");
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        if (this.skipTrain) {
            return;
        }
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class, BinaryTextRelation.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveCrossSentenceRelations.class, (Object[])new Object[0]), new String[0]);
        if (!this.useGoldAttributes) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveGoldAttributes.class, (Object[])new Object[0]), new String[0]);
        }
        if (this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[0]);
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EventEventTokenBasedAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", KerasStringOutcomeDataWriter.class, "outputDirectory", new File(directory, "event-event"), "DataWriterScriptDirectory", "scripts/nn/"}), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EventEventTokenBasedAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", KerasStringOutcomeDataWriter.class, "outputDirectory", new File(directory, "event-time"), "DataWriterScriptDirectory", "scripts/nn-et/"}), new String[0]);
        if (!this.skipWrite) {
            SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{aggregateBuilder.createAggregate()});
            JarClassifierBuilder.trainAndPackage((File)new File(directory, "event-event"), (String[])new String[0]);
            JarClassifierBuilder.trainAndPackage((File)new File(directory, "event-time"), (String[])new String[0]);
        }
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        this.useClosure = false;
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveCrossSentenceRelations.class, (Object[])new Object[]{"SentenceView", "_InitialView", "RelationView", "GoldView"}), new String[0]);
        if (!recallModeEvaluation.booleanValue() && this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        }
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.RemoveNonContainsRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(RemoveRelations.class, (Object[])new Object[0]), new String[0]);
        AnalysisEngineDescription aed = null;
        aed = AnalysisEngineFactory.createEngineDescription(EventEventTokenBasedAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(new File(directory, "event-event"), "model.jar").getPath()});
        aggregateBuilder.add(aed, new String[0]);
        aed = AnalysisEngineFactory.createEngineDescription(EventTimeTokenBasedAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(new File(directory, "event-time"), "model.jar").getPath()});
        aggregateBuilder.add(aed, new String[0]);
        aed = DocTimeRelAnnotator.createAnnotatorDescription(new File("target/eval/event-properties/train_and_test/docTimeRel/model.jar").getAbsolutePath());
        aggregateBuilder.add(aed, new String[0]);
        if (this.anaforaOutput != null) {
            aed = AnalysisEngineFactory.createEngineDescription(Evaluation_ImplBase.WriteAnaforaXML.class, (Object[])new Object[]{"PARAM_OUTPUT_DIR", this.anaforaOutput});
            aggregateBuilder.add(aed, new String[]{"TimexView", "_InitialView"});
        }
        File outf = null;
        if (recallModeEvaluation.booleanValue() && this.useClosure) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(AddClosure.class, (Object[])new Object[0]), new String[]{"GoldView", "_InitialView"});
            outf = new File("target/eval/thyme/SystemError_eventEvent_recall_test.txt");
        } else {
            outf = recallModeEvaluation == false && this.useClosure ? new File("target/eval/thyme/SystemError_eventEvent_precision_test.txt") : new File("target/eval/thyme/SystemError_eventEvent_plain_test.txt");
        }
        PrintWriter outDrop = null;
        outDrop = new PrintWriter(new BufferedWriter(new FileWriter(outf, false)));
        Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(BinaryTextRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator jcasIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        JCas jCas = null;
        while (jcasIter.hasNext()) {
            Object relation2;
            jCas = jcasIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldRelations = JCasUtil.select((JCas)goldView, BinaryTextRelation.class);
            Collection systemRelations = JCasUtil.select((JCas)systemView, BinaryTextRelation.class);
            stats.add(goldRelations, systemRelations, (Function)getSpan, getOutcome);
            if (this.printRelations) {
                URI uri = ViewUriUtil.getURI((JCas)jCas);
                String[] path = uri.getPath().split("/");
                EvaluationOfNeuralEEAndETRelations.printRelationAnnotations((String)path[path.length - 1], systemRelations);
            }
            if (!this.printErrors) continue;
            HashMap goldMap = Maps.newHashMap();
            for (Object relation2 : goldRelations) {
                goldMap.put(new RelationExtractorEvaluation.HashableArguments((BinaryTextRelation)relation2), relation2);
            }
            HashMap systemMap = Maps.newHashMap();
            relation2 = systemRelations.iterator();
            while (relation2.hasNext()) {
                BinaryTextRelation relation3 = (BinaryTextRelation)relation2.next();
                systemMap.put(new RelationExtractorEvaluation.HashableArguments(relation3), relation3);
            }
            Sets.SetView all = Sets.union(goldMap.keySet(), systemMap.keySet());
            ArrayList sorted = Lists.newArrayList((Iterable)all);
            Collections.sort(sorted);
            outDrop.println("Doc id: " + ViewUriUtil.getURI((JCas)jCas).toString());
            for (RelationExtractorEvaluation.HashableArguments key : sorted) {
                BinaryTextRelation goldRelation = (BinaryTextRelation)goldMap.get(key);
                BinaryTextRelation systemRelation = (BinaryTextRelation)systemMap.get(key);
                if (goldRelation == null) {
                    outDrop.println("System added: " + EvaluationOfNeuralEEAndETRelations.formatRelation(systemRelation));
                    continue;
                }
                if (systemRelation == null) {
                    outDrop.println("System dropped: " + EvaluationOfNeuralEEAndETRelations.formatRelation(goldRelation));
                    continue;
                }
                if (!systemRelation.getCategory().equals(goldRelation.getCategory())) {
                    String label = systemRelation.getCategory();
                    outDrop.printf("System labeled %s for %s\n", label, EvaluationOfNeuralEEAndETRelations.formatRelation(goldRelation));
                    continue;
                }
                outDrop.println("Nailed it! " + EvaluationOfNeuralEEAndETRelations.formatRelation(systemRelation));
            }
        }
        outDrop.close();
        return stats;
    }

    static void createRelation(JCas jCas, Annotation arg1, Annotation arg2, String category) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument(arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument(arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(category);
        relation.addToIndexes();
    }

    @PipeBitInfo(name="TLink Closure Engine", description="Performs closure on Temporal Relations", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddClosure
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashMultimap annotationsToRelation = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                String relationType = relation.getCategory();
                if (!AddClosure.validTemporalType(relationType)) continue;
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                annotationsToRelation.put(Arrays.asList(arg1, arg2), (Object)relation);
            }
            for (List span : Lists.newArrayList((Iterable)annotationsToRelation.keySet())) {
                Collection relations = annotationsToRelation.get((Object)span);
                if (relations.size() <= 1) continue;
                HashSet types = Sets.newHashSet();
                for (BinaryTextRelation relation : relations) {
                    types.add(relation.getCategory());
                }
                if (types.size() > 1) {
                    for (BinaryTextRelation relation : Lists.newArrayList((Iterable)relations)) {
                        annotationsToRelation.remove((Object)span, (Object)relation);
                        relation.getArg1().removeFromIndexes();
                        relation.getArg2().removeFromIndexes();
                        relation.removeFromIndexes();
                    }
                    continue;
                }
                if (types.size() != 1) continue;
                for (int i = 1; i < relations.size(); ++i) {
                    BinaryTextRelation relation;
                    relation = (BinaryTextRelation)relations.toArray()[i];
                    annotationsToRelation.remove((Object)span, (Object)relation);
                    relation.getArg1().removeFromIndexes();
                    relation.getArg2().removeFromIndexes();
                    relation.removeFromIndexes();
                }
            }
            ArrayList<BinaryTextRelation> temporalRelation = new ArrayList<BinaryTextRelation>(annotationsToRelation.values());
            if (!temporalRelation.isEmpty()) {
                TLinkTypeArray2 relationArray = new TLinkTypeArray2(temporalRelation, new AnnotationIdCollection(temporalRelation));
                int addedCount = 0;
                for (BinaryTextRelation relation : relationArray.getClosedTlinks(jCas)) {
                    Collection relations;
                    RelationArgument arg1 = relation.getArg1();
                    RelationArgument arg2 = relation.getArg2();
                    String relationType = relation.getCategory();
                    if (relationType.equals("CONTAINED-BY") || relationType.equals("AFTER") || !(relations = annotationsToRelation.get(Arrays.asList(arg1.getArgument(), arg2.getArgument()))).isEmpty()) continue;
                    arg1.addToIndexes();
                    arg2.addToIndexes();
                    relation.addToIndexes();
                    ++addedCount;
                }
                System.out.println("**************************************************************");
                System.out.println("Finally added closure relations: " + addedCount);
                System.out.println("**************************************************************");
            }
        }

        private static boolean validTemporalType(String relationType) {
            return relationType.equals("CONTAINS") || relationType.equals("OVERLAP") || relationType.equals("BEFORE") || relationType.equals("ENDS-ON") || relationType.equals("BEGINS-ON");
        }
    }

    @PipeBitInfo(name="Reverse Overlap TLinker", description="Adds Overlap temporal relations with arguments flipped.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddFlippedOverlap
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashSet overlapRelations = Sets.newHashSet();
            HashMultimap overlaps = HashMultimap.create();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("OVERLAP")) continue;
                overlapRelations.add(relation);
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                overlaps.put((Object)arg1, (Object)arg2);
            }
            for (BinaryTextRelation orelation : overlapRelations) {
                Annotation argA = orelation.getArg1().getArgument();
                Annotation argB = orelation.getArg2().getArgument();
                if (overlaps.containsEntry((Object)argB, (Object)argA)) continue;
                RelationArgument arg1 = new RelationArgument(jCas);
                arg1.setArgument(argB);
                RelationArgument arg2 = new RelationArgument(jCas);
                arg2.setArgument(argA);
                BinaryTextRelation relation = new BinaryTextRelation(jCas);
                relation.setArg1(arg1);
                relation.setArg2(arg2);
                relation.setCategory("OVERLAP");
                arg1.addToIndexes();
                arg2.addToIndexes();
                relation.addToIndexes();
                overlaps.put((Object)argB, (Object)argA);
            }
        }
    }

    @PipeBitInfo(name="TLink Overlap Adder", description="Adds an Overlap temporal relation for each Contains temporal relation.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddContain2Overlap
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashSet containsRelations = Sets.newHashSet();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("CONTAINS")) continue;
                containsRelations.add(relation);
            }
            for (BinaryTextRelation relation : containsRelations) {
                RelationArgument arg1 = (RelationArgument)relation.getArg1().clone();
                RelationArgument arg2 = (RelationArgument)relation.getArg2().clone();
                BinaryTextRelation newrelation = new BinaryTextRelation(jCas);
                newrelation.setArg1(arg1);
                newrelation.setArg2(arg2);
                newrelation.setCategory("OVERLAP");
                arg1.addToIndexes();
                arg2.addToIndexes();
                newrelation.addToIndexes();
            }
        }
    }

    @PipeBitInfo(name="Transitive Contains Adder", description="Adds Contains temporal relations for annotations / relations in contain other relations.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
    public static class AddTransitiveContainsRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            HashMultimap isContainedIn = HashMultimap.create();
            HashMultimap contains = HashMultimap.create();
            HashSet containsRelations = Sets.newHashSet();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                if (!relation.getCategory().equals("CONTAINS")) continue;
                containsRelations.add(relation);
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                contains.put((Object)arg1, (Object)arg2);
                isContainedIn.put((Object)arg2, (Object)arg1);
            }
            ArrayDeque<Annotation> todo = new ArrayDeque<Annotation>(isContainedIn.keySet());
            while (!todo.isEmpty()) {
                Annotation next = (Annotation)todo.removeFirst();
                for (Annotation parent : Lists.newArrayList((Iterable)isContainedIn.get((Object)next))) {
                    for (Annotation grandParent : Lists.newArrayList((Iterable)isContainedIn.get((Object)parent))) {
                        if (isContainedIn.containsEntry((Object)next, (Object)grandParent)) continue;
                        isContainedIn.put((Object)next, (Object)grandParent);
                        contains.put((Object)grandParent, (Object)next);
                        for (Annotation child : contains.get((Object)next)) {
                            todo.add(child);
                        }
                    }
                }
            }
            for (BinaryTextRelation relation : containsRelations) {
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
            for (Annotation contained : isContainedIn.keySet()) {
                for (Annotation container : isContainedIn.get((Object)contained)) {
                    RelationArgument arg1 = new RelationArgument(jCas);
                    arg1.setArgument(container);
                    RelationArgument arg2 = new RelationArgument(jCas);
                    arg2.setArgument(contained);
                    BinaryTextRelation relation = new BinaryTextRelation(jCas);
                    relation.setArg1(arg1);
                    relation.setArg2(arg2);
                    relation.setCategory("CONTAINS");
                    arg1.addToIndexes();
                    arg2.addToIndexes();
                    relation.addToIndexes();
                }
            }
        }
    }

    public static class RemoveRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveCrossSentenceRelations
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_SENTENCE_VIEW = "SentenceView";
        @ConfigurationParameter(name="SentenceView", mandatory=false)
        private String sentenceViewName = "_InitialView";
        public static final String PARAM_RELATION_VIEW = "RelationView";
        @ConfigurationParameter(name="RelationView", mandatory=false)
        private String relationViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas relationView;
            JCas sentenceView;
            try {
                sentenceView = jCas.getView(this.sentenceViewName);
                relationView = jCas.getView(this.relationViewName);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap sentenceIndex = Maps.newHashMap();
            int index = -1;
            for (Sentence sentence : JCasUtil.select((JCas)sentenceView, Sentence.class)) {
                ++index;
                for (EventMention event : JCasUtil.selectCovered((JCas)relationView, EventMention.class, (AnnotationFS)sentence)) {
                    sentenceIndex.put(event, index);
                }
                for (TimeMention time : JCasUtil.selectCovered((JCas)relationView, TimeMention.class, (AnnotationFS)sentence)) {
                    sentenceIndex.put(time, index);
                }
            }
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)relationView, BinaryTextRelation.class))) {
                Integer sent1 = (Integer)sentenceIndex.get(relation.getArg1().getArgument());
                Integer sent2 = (Integer)sentenceIndex.get(relation.getArg2().getArgument());
                if (sent1 != null && sent2 != null && sent1.equals(sent2)) continue;
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveNonTLINKRelations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (BinaryTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)jCas, BinaryTextRelation.class))) {
                if (relation instanceof TemporalTextRelation) continue;
                relation.getArg1().removeFromIndexes();
                relation.getArg2().removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    public static class RemoveNonUMLSEvents
    extends JCasAnnotator_ImplBase {
        public static final String PARAM_GOLD_VIEW = "GoldView";
        @ConfigurationParameter(name="GoldView", mandatory=false)
        private String goldViewName = "_InitialView";

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas goldView;
            JCas sysView;
            try {
                sysView = jCas.getView("_InitialView");
                goldView = jCas.getView(PARAM_GOLD_VIEW);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            for (TemporalTextRelation relation : Lists.newArrayList((Iterable)JCasUtil.select((JCas)goldView, TemporalTextRelation.class))) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                boolean arg1Valid = false;
                boolean arg2Valid = false;
                for (EventMention event : JCasUtil.selectCovered((JCas)sysView, EventMention.class, (AnnotationFS)arg1)) {
                    if (event.getClass().equals(EventMention.class)) continue;
                    arg1Valid = true;
                    break;
                }
                for (EventMention event : JCasUtil.selectCovered((JCas)sysView, EventMention.class, (AnnotationFS)arg2)) {
                    if (event.getClass().equals(EventMention.class)) continue;
                    arg2Valid = true;
                    break;
                }
                if (arg1Valid && arg2Valid) continue;
                arg1.removeFromIndexes();
                arg2.removeFromIndexes();
                relation.removeFromIndexes();
            }
        }
    }

    static interface TempRelOptions
    extends Evaluation_ImplBase.Options {
        @Option
        public boolean getPrintFormattedRelations();

        @Option
        public boolean getBaseline();

        @Option
        public boolean getClosure();

        @Option
        public boolean getUseTmp();

        @Option
        public boolean getUseGoldAttributes();

        @Override
        @Option
        public boolean getSkipTrain();

        @Option
        public boolean getWriteProbabilities();

        @Option
        public boolean getTestOnTrain();

        @Option
        public boolean getSkipWrite();
    }
}

