/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.ViewUriUtil;

public class GoldRelationViewer {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        CollectionReader collectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(RelationContextPrinter.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    public static class RelationContextPrinter
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                Annotation arg1 = relation.getArg1().getArgument();
                Annotation arg2 = relation.getArg2().getArgument();
                relationLookup.put(Arrays.asList(arg1, arg2), relation);
            }
            File noteFile = new File(ViewUriUtil.getURI((JCas)jCas).toString());
            String fileName = noteFile.getName();
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                String text;
                ArrayList<String> formattedRelationsInSentence = new ArrayList<String>();
                List eventMentionsInSentence = JCasUtil.selectCovered((JCas)goldView, EventMention.class, (AnnotationFS)sentence);
                List timeMentionsInSentence = JCasUtil.selectCovered((JCas)goldView, TimeMention.class, (AnnotationFS)sentence);
                for (EventMention eventMention : eventMentionsInSentence) {
                    for (TimeMention timeMention : timeMentionsInSentence) {
                        BinaryTextRelation eventTimeRel;
                        BinaryTextRelation timeEventRel = (BinaryTextRelation)relationLookup.get(Arrays.asList(timeMention, eventMention));
                        if (timeEventRel != null) {
                            text = String.format("%s(%s, %s)", timeEventRel.getCategory(), timeMention.getCoveredText(), eventMention.getCoveredText());
                            formattedRelationsInSentence.add(text);
                        }
                        if ((eventTimeRel = (BinaryTextRelation)relationLookup.get(Arrays.asList(eventMention, timeMention))) == null) continue;
                        String text2 = String.format("%s(%s, %s)", eventTimeRel.getCategory(), eventMention.getCoveredText(), timeMention.getCoveredText());
                        formattedRelationsInSentence.add(text2);
                    }
                }
                for (EventMention mention1 : eventMentionsInSentence) {
                    for (EventMention mention2 : eventMentionsInSentence) {
                        if (mention1 == mention2) continue;
                        BinaryTextRelation relation = (BinaryTextRelation)relationLookup.get(Arrays.asList(mention1, mention2));
                        if (relation == null) continue;
                        text = String.format("%s(%s, %s)", relation.getCategory(), mention1.getCoveredText(), mention2.getCoveredText());
                        formattedRelationsInSentence.add(text);
                    }
                }
                if (formattedRelationsInSentence.size() <= 0) continue;
                System.out.println(fileName + ": " + sentence.getCoveredText());
                for (String text3 : formattedRelationsInSentence) {
                    System.out.println(text3);
                }
                System.out.println();
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();
    }
}

