/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.treekernel;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.TreeFeature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class DependencySingleTreeExtractor
implements FeatureExtractor1 {
    public static final String FEAT_NAME = "TK_DepSingleT";

    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        String dtreeStr = "(TOP (EVENT " + focusAnnotation.getCoveredText().trim() + "))";
        for (ConllDependencyNode node : JCasUtil.selectCovered((JCas)view, ConllDependencyNode.class, (AnnotationFS)focusAnnotation)) {
            ConllDependencyNode head = node.getHead();
            SimpleTree curTree = null;
            SimpleTree headTree = null;
            if (head == null) continue;
            curTree = SimpleTree.fromString((String)String.format("(%s %s)", node.getDeprel(), node.getPostag()));
            while (head.getHead() != null) {
                headTree = SimpleTree.fromString((String)String.format("(%s %s)", head.getDeprel(), head.getPostag()));
                curTree.parent = (SimpleTree)headTree.children.get(0);
                ((SimpleTree)headTree.children.get(0)).addChild(curTree);
                curTree = headTree;
                head = head.getHead();
            }
            if (headTree == null) {
                curTree = SimpleTree.fromString((String)String.format("(%s (%s %s))", node.getDeprel(), node.getPostag(), "null"));
                dtreeStr = curTree.toString();
                break;
            }
            dtreeStr = headTree.toString();
            break;
        }
        features.add((Feature)new TreeFeature(FEAT_NAME, (Object)dtreeStr));
        return features;
    }
}

