/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.springframework.util.StringUtils;

public class CheckSpecialWordRelationExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private static final String LOOKUP_PATH = "/org/apache/ctakes/temporal/TimeLexicon.csv";
    private Multimap<String, String> specialWd = ArrayListMultimap.create();

    public CheckSpecialWordRelationExtractor() {
        URL url = TimeWordsExtractor.class.getResource(LOOKUP_PATH);
        try {
            for (String line : Resources.readLines((URL)url, (Charset)Charsets.US_ASCII)) {
                String[] WordAndType = line.split(",");
                if (WordAndType.length != 2) {
                    throw new IllegalArgumentException("Expected '<word>,<type>', found: " + line);
                }
                this.specialWd.put((Object)WordAndType[0], (Object)WordAndType[1]);
            }
        }
        catch (IOException e) {
            System.err.println("TimeLexicon resource initialization error.");
        }
    }

    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        if (CheckSpecialWordRelationExtractor.isBefore(arg2, arg1)) {
            IdentifiedAnnotation temp = arg1;
            arg1 = arg2;
            arg2 = temp;
        } else if (!CheckSpecialWordRelationExtractor.isBefore(arg1, arg2)) {
            return feats;
        }
        int begin = arg1.getEnd();
        int end = arg2.getBegin();
        String textInBetween = null;
        textInBetween = jcas.getDocumentText().substring(begin, end).replaceAll("[\r\n]", " ").toLowerCase();
        String textInArg1 = jcas.getDocumentText().substring(arg1.getBegin(), arg1.getEnd()).replaceAll("[\r\n]", " ").toLowerCase();
        String textInArg2 = jcas.getDocumentText().substring(arg2.getBegin(), arg2.getEnd()).replaceAll("[\r\n]", " ").toLowerCase();
        for (String lexicon : this.specialWd.keySet()) {
            Feature feature;
            String type;
            if (textInBetween != null && textInBetween.matches(".*\\b" + lexicon + "\\b.*")) {
                type = StringUtils.collectionToCommaDelimitedString((Collection)this.specialWd.get((Object)lexicon));
                feature = new Feature("SpecialWd_InBetween", (Object)type);
                feats.add(feature);
            }
            if (textInArg1.matches(".*\\b" + lexicon + "\\b.*")) {
                type = StringUtils.collectionToCommaDelimitedString((Collection)this.specialWd.get((Object)lexicon));
                feature = new Feature("SpecialWd_InArg1", (Object)type);
                feats.add(feature);
            }
            if (!textInArg2.matches(".*\\b" + lexicon + "\\b.*")) continue;
            type = StringUtils.collectionToCommaDelimitedString((Collection)this.specialWd.get((Object)lexicon));
            feature = new Feature("SpecialWd_InArg2", (Object)type);
            feats.add(feature);
        }
        return feats;
    }

    private static boolean isBefore(IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        return arg1.getBegin() < arg2.getBegin() && arg1.getEnd() < arg2.getBegin();
    }
}

