/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.ae.SHARPKnowtatorXMLReader;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.UriCollectionReader;

@PipeBitInfo(name="Knowtator XML Reader (THYME)", description="Reads annotations from THYME schema Knowtator XML files in a directory.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX, PipeBitInfo.TypeProduct.LOCATION_RELATION, PipeBitInfo.TypeProduct.DEGREE_RELATION, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class THYMEKnowtatorXMLReader
extends SHARPKnowtatorXMLReader {
    public static final String PARAM_KNOWTATOR_XML_DIRECTORY = "knowtatorXMLDirectory";
    @ConfigurationParameter(name="knowtatorXMLDirectory", mandatory=true)
    protected File knowtatorXMLDirectory;

    public static AnalysisEngineDescription getDescription(File knowtatorXMLDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(THYMEKnowtatorXMLReader.class, (Object[])new Object[]{PARAM_KNOWTATOR_XML_DIRECTORY, knowtatorXMLDirectory});
    }

    protected URI getTextURI(JCas jCas) {
        try {
            return ViewUriUtil.getURI((JCas)jCas);
        }
        catch (AnalysisEngineProcessException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected URI getKnowtatorURI(JCas jCas) {
        URI uri = this.getTextURI(jCas);
        File file = new File(uri.getPath());
        String subDir = file.getName().substring(3, 5);
        Matcher matcher = Pattern.compile("^\\d+$").matcher(subDir);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unrecognized subdirectory naming: " + subDir);
        }
        subDir = String.format("gold_revised_xml_docset%s", subDir);
        String fileName = file.getName() + ".knowtator.xml";
        return new File(new File(this.knowtatorXMLDirectory, subDir), fileName).toURI();
    }

    protected String[] getAnnotatorNames() {
        return new String[]{"consensus set annotator team", "consensus set_rel annotator team"};
    }

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : options.getPatients().getList()) {
            File setTextDirectory = new File(options.getRawTextDirectory(), "doc" + set);
            for (File file : setTextDirectory.listFiles()) {
                files.add(file);
            }
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AnalysisEngine engine = AnalysisEngineFactory.createEngine(THYMEKnowtatorXMLReader.class, (Object[])new Object[]{PARAM_KNOWTATOR_XML_DIRECTORY, options.getKnowtatorXMLDirectory()});
        SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngine[])new AnalysisEngine[]{engine});
    }

    private static interface Options {
        @Option(longName={"text"})
        public File getRawTextDirectory();

        @Option(longName={"xml"})
        public File getKnowtatorXMLDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();
    }
}

