/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalEntityAnnotator_ImplBase;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.Predicate;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="NE Predicate Annotator", description="Creates Events from Identified Annotations and Predicates.", dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.EVENT})
public class NEPredicateEventAnnotator
extends TemporalEntityAnnotator_ImplBase {
    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        EventMention eventMention;
        Event event;
        for (EntityMention neMention : JCasUtil.select((JCas)jCas, EntityMention.class)) {
            event = new Event(jCas);
            event.setConfidence(1.0);
            eventMention = new EventMention(jCas, neMention.getBegin(), neMention.getEnd());
            eventMention.setConfidence(1.0f);
            eventMention.setEvent(event);
            eventMention.setOntologyConceptArr(neMention.getOntologyConceptArr());
            event.addToIndexes();
            eventMention.addToIndexes();
        }
        for (Predicate predicate : JCasUtil.select((JCas)jCas, Predicate.class)) {
            event = new Event(jCas);
            event.setConfidence(1.0);
            eventMention = new EventMention(jCas, predicate.getBegin(), predicate.getEnd());
            eventMention.setConfidence(1.0f);
            eventMention.setEvent(event);
            event.addToIndexes();
            eventMention.addToIndexes();
        }
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(NEPredicateEventAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(NEPredicateEventAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }
}

