/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.coreference.type.BooleanLabeledFS;
import org.apache.ctakes.coreference.type.DemMarkable;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.type.MarkablePairSet;
import org.apache.ctakes.coreference.type.NEMarkable;
import org.apache.ctakes.coreference.type.PronounMarkable;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.PairAttributeCalculator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Markable Pair Creator (MiPACQ)", description="Pairs Markables using a stop word list.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.CHUNK}, usables={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class MipacqMarkablePairGenerator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_STOPWORDS_FILE = "StopFile";
    @ConfigurationParameter(name="StopFile", mandatory=false, defaultValue={"org/apache/ctakes/coreference/models/stop.txt"})
    File stopwordFile = null;
    HashSet<String> stopwords;
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    int numVecs = 0;

    public void initialize(UimaContext uc) throws ResourceInitializationException {
        super.initialize(uc);
        try {
            this.stopwords = new HashSet();
            try (BufferedReader br = new BufferedReader(new FileReader(this.stopwordFile));){
                String l;
                while ((l = br.readLine()) != null) {
                    if ((l = l.trim()).length() == 0) continue;
                    int i = l.indexOf(124);
                    if (i > 0) {
                        this.stopwords.add(l.substring(0, i).trim());
                        continue;
                    }
                    if (i >= 0) continue;
                    this.stopwords.add(l.trim());
                }
            }
            this.logger.info((Object)("Stop words list loaded: " + this.stopwordFile.getAbsolutePath()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"Error loading stop words list");
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.numVecs = 0;
        LinkedList<Annotation> lm = FSIteratorToList.convert(jcas.getJFSIndexRepository().getAnnotationIndex(Markable.type).iterator());
        for (int p = 1; p < lm.size(); ++p) {
            Markable m = (Markable)lm.get(p);
            Annotation mc = m.getContent();
            if (m instanceof PronounMarkable && ((BaseToken)mc).getPartOfSpeech().startsWith("PRP")) {
                this.createPronPairs(lm, p, jcas);
                continue;
            }
            if (m instanceof DemMarkable && ((Chunk)mc).getChunkType().equals("NP")) {
                String s = mc.getCoveredText().toLowerCase();
                if (!s.startsWith("this") && !s.startsWith("that") && !s.startsWith("these") && !s.startsWith("those") && !s.equalsIgnoreCase("which")) continue;
                this.createDemPairs(lm, p, jcas);
                continue;
            }
            if (m instanceof NEMarkable) {
                this.createCorefPairs(lm, p, jcas);
                continue;
            }
            System.err.println("Unknown type of Markable " + mc.getClass().getName() + " " + mc.getCoveredText());
        }
        System.out.println("   ....ended with " + this.numVecs + " vectors.");
    }

    private void createCorefPairs(LinkedList<Annotation> lm, int p, JCas jcas) {
        Markable a;
        int sentdist;
        NEMarkable m = (NEMarkable)lm.get(p);
        MarkablePairSet pairList = new MarkablePairSet(jcas);
        pairList.setBegin(m.getBegin());
        pairList.setEnd(m.getEnd());
        pairList.setAnaphor(m);
        NonEmptyFSList head = new NonEmptyFSList(jcas);
        pairList.setAntecedentList((FSList)head);
        NonEmptyFSList tail = null;
        for (int q = p - 1; q >= 0 && (sentdist = this.sentDist(jcas, a = (Markable)lm.get(q), m)) <= 20; --q) {
            if (m.getContent() instanceof IdentifiedAnnotation && a.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)m.getContent()).getTypeID() != ((IdentifiedAnnotation)a.getContent()).getTypeID() || a.getCoveredText().equalsIgnoreCase("which") && this.sentDist(jcas, a, m) >= 1 || a.getBegin() <= m.getBegin() && a.getEnd() >= m.getEnd() || m.getBegin() <= a.getBegin() && m.getEnd() >= a.getEnd()) continue;
            BooleanLabeledFS labeledAntecedent = new BooleanLabeledFS(jcas);
            labeledAntecedent.setFeature((TOP)a);
            if (tail == null) {
                tail = head;
            } else {
                tail.setTail((FSList)new NonEmptyFSList(jcas));
                tail = (NonEmptyFSList)tail.getTail();
            }
            tail.setHead((TOP)labeledAntecedent);
        }
        if (tail == null) {
            pairList.setAntecedentList((FSList)new EmptyFSList(jcas));
        } else {
            tail.setTail((FSList)new EmptyFSList(jcas));
        }
        ++this.numVecs;
        pairList.addToIndexes();
    }

    private void createDemPairs(LinkedList<Annotation> lm, int p, JCas jcas) {
        Markable a;
        DemMarkable m = (DemMarkable)lm.get(p);
        MarkablePairSet pairList = new MarkablePairSet(jcas);
        pairList.setAnaphor(m);
        NonEmptyFSList head = new NonEmptyFSList(jcas);
        pairList.setAntecedentList((FSList)head);
        NonEmptyFSList tail = null;
        for (int q = p - 1; q >= 0 && this.sentDist(jcas, a = (Markable)lm.get(q), m) <= 3; --q) {
            BooleanLabeledFS labeledAntecedent = new BooleanLabeledFS(jcas);
            labeledAntecedent.setFeature((TOP)a);
            if (tail == null) {
                tail = head;
            } else {
                tail.setTail((FSList)new NonEmptyFSList(jcas));
                tail = (NonEmptyFSList)tail.getTail();
            }
            tail.setHead((TOP)labeledAntecedent);
        }
        if (tail == null) {
            pairList.setAntecedentList((FSList)new EmptyFSList(jcas));
        } else {
            tail.setTail((FSList)new EmptyFSList(jcas));
        }
        ++this.numVecs;
        pairList.addToIndexes();
    }

    private void createPronPairs(LinkedList<Annotation> lm, int p, JCas jcas) {
        Markable a;
        PronounMarkable m = (PronounMarkable)lm.get(p);
        MarkablePairSet pairList = new MarkablePairSet(jcas);
        pairList.setAnaphor(m);
        NonEmptyFSList head = new NonEmptyFSList(jcas);
        pairList.setAntecedentList((FSList)head);
        NonEmptyFSList tail = null;
        for (int q = p - 1; q >= 0 && this.sentDist(jcas, a = (Markable)lm.get(q), m) <= 3; --q) {
            if (a.getBegin() <= m.getBegin() && a.getEnd() >= m.getEnd() || m.getBegin() <= a.getBegin() && m.getEnd() >= a.getEnd()) continue;
            BooleanLabeledFS labeledAntecedent = new BooleanLabeledFS(jcas);
            labeledAntecedent.setFeature((TOP)a);
            if (tail == null) {
                tail = head;
            } else {
                tail.setTail((FSList)new NonEmptyFSList(jcas));
                tail = (NonEmptyFSList)tail.getTail();
            }
            tail.setHead((TOP)labeledAntecedent);
        }
        if (tail == null) {
            pairList.setAntecedentList((FSList)new EmptyFSList(jcas));
        } else {
            tail.setTail((FSList)new EmptyFSList(jcas));
        }
        ++this.numVecs;
        pairList.addToIndexes();
    }

    private int sentDist(JCas jcas, Markable m1, Markable m2) {
        PairAttributeCalculator ac = new PairAttributeCalculator(jcas, m1, m2);
        ac.setStopWordsList(this.stopwords);
        return ac.getSentenceDistance();
    }
}

