/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.ListFactory;
import org.apache.ctakes.coreference.ae.EventCoreferenceAnnotator;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterAgreementFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterAttributeFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterDepHeadExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterDistSemExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterMentionFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterSalienceFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterSectionFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterSemTypeDepPrefsFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterStackFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterStringFeaturesExtractor;
import org.apache.ctakes.coreference.ae.features.cluster.MentionClusterUMLSFeatureExtractor;
import org.apache.ctakes.coreference.util.ClusterUtils;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelationIdentifiedAnnotationRelation;
import org.apache.ctakes.typesystem.type.relation.CoreferenceRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.MedicationEventMention;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.svmlight.rank.QidInstance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="Coreference (Cluster Rank)", description="Coreference annotator using mention-synchronous paradigm.", dependencies={PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.PARAGRAPH, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.MARKABLE}, products={PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
public class MentionClusterRankingCoreferenceAnnotator
extends CleartkAnnotator<Double> {
    public static final String NO_RELATION_CATEGORY = "-NONE-";
    public static final String CLUSTER_RELATION_CATEGORY = "CoreferenceClusterMember";
    public static final String PARAM_PROBABILITY_OF_KEEPING_A_NEGATIVE_EXAMPLE = "ProbabilityOfKeepingANegativeExample";
    @ConfigurationParameter(name="ProbabilityOfKeepingANegativeExample", mandatory=false, description="probability that a negative example should be retained for training")
    protected double probabilityOfKeepingANegativeExample = 0.5;
    protected Random coin = new Random(0L);
    boolean greedyFirst = true;
    private int qid = 0;
    private List<RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>> relationExtractors = this.getFeatureExtractors();
    private List<FeatureExtractor1<Markable>> mentionExtractors = this.getMentionExtractors();
    private Set<String> markableStrings = null;
    private Map<ConllDependencyNode, Collection<IdentifiedAnnotation>> nodeEntMap = null;
    private Map<String, Set<Markable>> headWordMarkables = null;
    private Map<RelationExtractorEvaluation.HashableArguments, Double> pairScores = null;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<?>> dataWriterClass, File outputDirectory, float downsamplingRate) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MentionClusterRankingCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", true, PARAM_PROBABILITY_OF_KEEPING_A_NEGATIVE_EXAMPLE, Float.valueOf(downsamplingRate), "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MentionClusterRankingCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    protected List<RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>> getFeatureExtractors() {
        ArrayList<RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>> extractors = new ArrayList<RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>>();
        extractors.add(new MentionClusterAgreementFeaturesExtractor());
        extractors.add(new MentionClusterStringFeaturesExtractor());
        extractors.add(new MentionClusterSectionFeaturesExtractor());
        extractors.add(new MentionClusterUMLSFeatureExtractor());
        extractors.add(new MentionClusterDepHeadExtractor());
        extractors.add(new MentionClusterStackFeaturesExtractor());
        extractors.add(new MentionClusterSalienceFeaturesExtractor());
        extractors.add(new MentionClusterAttributeFeaturesExtractor());
        try {
            extractors.add(new MentionClusterDistSemExtractor());
            extractors.add(new MentionClusterSemTypeDepPrefsFeatureExtractor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return extractors;
    }

    protected List<FeatureExtractor1<Markable>> getMentionExtractors() {
        ArrayList<FeatureExtractor1<Markable>> extractors = new ArrayList<FeatureExtractor1<Markable>>();
        extractors.add(new MentionClusterAgreementFeaturesExtractor());
        extractors.add(new MentionClusterSectionFeaturesExtractor());
        extractors.add(new MentionClusterUMLSFeatureExtractor());
        extractors.add(new MentionClusterDepHeadExtractor());
        extractors.add(new MentionClusterSalienceFeaturesExtractor());
        try {
            extractors.add(new MentionClusterMentionFeaturesExtractor());
        }
        catch (CleartkExtractorException e) {
            e.printStackTrace();
        }
        extractors.add(new MentionClusterAttributeFeaturesExtractor());
        return extractors;
    }

    protected Iterable<CollectionTextRelationIdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jcas, IdentifiedAnnotation mention) {
        int sentDist = 5;
        LinkedHashSet<CollectionTextRelationIdentifiedAnnotationPair> pairs = new LinkedHashSet<CollectionTextRelationIdentifiedAnnotationPair>();
        pairs.addAll(this.getSentenceDistancePairs(jcas, mention, sentDist));
        pairs.addAll(this.getSectionHeaderPairs(jcas, mention, sentDist));
        pairs.addAll(this.getClusterPairs(jcas, mention, Integer.MAX_VALUE));
        pairs.addAll(this.getHeadwordMatchPairs(jcas, mention, sentDist));
        return pairs;
    }

    private List<CollectionTextRelationIdentifiedAnnotationPair> getExactStringMatchPairs(JCas jcas, IdentifiedAnnotation mention, int sentDist) {
        ArrayList<CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<CollectionTextRelationIdentifiedAnnotationPair>();
        if (this.markableStrings.contains(mention.getCoveredText().toLowerCase())) {
            block0: for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
                Markable m;
                Annotation mostRecent = ClusterUtils.getMostRecent((NonEmptyFSList)cluster.getMembers(), (Annotation)mention);
                if (mostRecent == null) continue;
                Iterator iterator = JCasUtil.select((FSList)cluster.getMembers(), Markable.class).iterator();
                while (iterator.hasNext() && (m = (Markable)iterator.next()) != mostRecent) {
                    if (!m.getCoveredText().toLowerCase().equals(mention.getCoveredText().toLowerCase())) continue;
                    pairs.add(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
                    continue block0;
                }
            }
        }
        return pairs;
    }

    private List<CollectionTextRelationIdentifiedAnnotationPair> getClusterPairs(JCas jcas, IdentifiedAnnotation mention, int sentDist) {
        ArrayList<CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<CollectionTextRelationIdentifiedAnnotationPair>();
        for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
            IdentifiedAnnotation mostRecent;
            NonEmptyFSList members = (NonEmptyFSList)cluster.getMembers();
            Annotation first = (Annotation)members.getHead();
            if (first == null || mention.getBegin() <= first.getEnd() || (mostRecent = (IdentifiedAnnotation)ClusterUtils.getMostRecent((NonEmptyFSList)cluster.getMembers(), (Annotation)mention)) == null || EventCoreferenceAnnotator.sentDist(jcas, mostRecent, mention) > sentDist) continue;
            int numMembers = 0;
            for (Markable m : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
                ++numMembers;
                if (m != mostRecent) continue;
                break;
            }
            if (numMembers <= true) continue;
            pairs.add(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
        }
        return pairs;
    }

    protected List<CollectionTextRelationIdentifiedAnnotationPair> getSentenceDistancePairs(JCas jcas, IdentifiedAnnotation mention, int sentDist) {
        ArrayList<CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<CollectionTextRelationIdentifiedAnnotationPair>();
        Set<String> bestAnaTypes = this.getBestEnt(jcas, (Markable)mention);
        for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
            IdentifiedAnnotation mostRecent;
            NonEmptyFSList members = (NonEmptyFSList)cluster.getMembers();
            Annotation first = (Annotation)members.getHead();
            if (first == null || mention.getBegin() <= first.getEnd() || !bestAnaTypes.contains(AnatomicalSiteMention.class.getSimpleName()) && !bestAnaTypes.contains(MedicationEventMention.class.getSimpleName()) && ((mostRecent = (IdentifiedAnnotation)ClusterUtils.getMostRecent(members, (Annotation)mention)) == null || EventCoreferenceAnnotator.sentDist(jcas, mostRecent, mention) > sentDist)) continue;
            Set<String> bestClusterTypes = this.getBestEnt(jcas, cluster);
            if (bestAnaTypes.size() > 0 && bestClusterTypes.size() > 0) {
                boolean overlap = false;
                for (String semType : bestAnaTypes) {
                    if (!bestClusterTypes.contains(semType)) continue;
                    overlap = true;
                }
                if (!overlap) continue;
            }
            pairs.add(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
        }
        return pairs;
    }

    protected List<CollectionTextRelationIdentifiedAnnotationPair> getSectionHeaderPairs(JCas jcas, IdentifiedAnnotation mention, int sentDist) {
        ArrayList<CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<CollectionTextRelationIdentifiedAnnotationPair>();
        block0: for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
            IdentifiedAnnotation mostRecent;
            NonEmptyFSList members = (NonEmptyFSList)cluster.getMembers();
            Annotation first = (Annotation)members.getHead();
            if (first == null || mention.getBegin() <= first.getEnd() || (mostRecent = (IdentifiedAnnotation)ClusterUtils.getMostRecent(members, (Annotation)mention)) == null || EventCoreferenceAnnotator.sentDist(jcas, mostRecent, mention) <= sentDist) continue;
            List pars = JCasUtil.selectCovered((JCas)jcas, Paragraph.class, (int)0, (int)mention.getBegin());
            for (int j = 0; j < pars.size(); ++j) {
                boolean match = false;
                Paragraph par = (Paragraph)pars.get(j);
                List coveredSents = JCasUtil.selectCovered((JCas)jcas, Sentence.class, (AnnotationFS)par);
                if (coveredSents != null && coveredSents.size() == 1) {
                    for (Markable m : JCasUtil.select((FSList)members, Markable.class)) {
                        if (!MentionClusterRankingCoreferenceAnnotator.dominates((Annotation)par, (Annotation)m)) continue;
                        pairs.add(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
                        match = true;
                        break;
                    }
                }
                if (match) continue block0;
            }
        }
        return pairs;
    }

    protected List<CollectionTextRelationIdentifiedAnnotationPair> getHeadwordMatchPairs(JCas jcas, IdentifiedAnnotation mention, int sentDist) {
        ArrayList<CollectionTextRelationIdentifiedAnnotationPair> pairs = new ArrayList<CollectionTextRelationIdentifiedAnnotationPair>();
        ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)mention);
        if (headNode == null) {
            Logger.getLogger(MentionClusterRankingCoreferenceAnnotator.class).warn((Object)"There is a markable with no dependency node covering it.");
            return pairs;
        }
        String head = headNode.getCoveredText().toLowerCase();
        if (this.headWordMarkables.containsKey(head)) {
            Set<Markable> headSet = this.headWordMarkables.get(head);
            block0: for (CollectionTextRelation cluster : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
                Annotation mostRecent = ClusterUtils.getMostRecent((NonEmptyFSList)cluster.getMembers(), (Annotation)mention);
                if (mostRecent == null) continue;
                for (Markable m : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
                    if (headSet.contains(mostRecent)) {
                        pairs.add(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
                        continue block0;
                    }
                    if (m != mostRecent) continue;
                    continue block0;
                }
            }
        }
        return pairs;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.markableStrings = new HashSet<String>();
        this.nodeEntMap = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        this.headWordMarkables = new HashMap<String, Set<Markable>>();
        HashMap<CollectionTextRelationIdentifiedAnnotationPair, CollectionTextRelationIdentifiedAnnotationRelation> relationLookup = new HashMap<CollectionTextRelationIdentifiedAnnotationPair, CollectionTextRelationIdentifiedAnnotationRelation>();
        if (this.isTraining()) {
            for (CollectionTextRelation cluster : JCasUtil.select((JCas)jCas, CollectionTextRelation.class)) {
                for (IdentifiedAnnotation mention : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
                    CollectionTextRelationIdentifiedAnnotationRelation relation = new CollectionTextRelationIdentifiedAnnotationRelation(jCas);
                    relation.setCluster(cluster);
                    relation.setMention(mention);
                    relation.setCategory(CLUSTER_RELATION_CATEGORY);
                    relation.addToIndexes();
                    CollectionTextRelationIdentifiedAnnotationPair key = new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention);
                    if (relationLookup.containsKey(key)) {
                        String cat = ((CollectionTextRelationIdentifiedAnnotationRelation)relationLookup.get(key)).getCategory();
                        System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                        System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + cat + " at this span: " + mention.getCoveredText());
                    }
                    relationLookup.put(key, relation);
                }
            }
        }
        for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
            for (IdentifiedAnnotation mention : JCasUtil.selectCovered((JCas)jCas, Markable.class, (AnnotationFS)segment)) {
                ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)mention);
                String mentionText = mention.getCoveredText().toLowerCase();
                boolean singleton = true;
                double maxScore = Double.NEGATIVE_INFINITY;
                CollectionTextRelation maxCluster = null;
                ArrayList<Feature> mentionFeatures = new ArrayList<Feature>();
                for (FeatureExtractor1<Markable> featureExtractor1 : this.mentionExtractors) {
                    mentionFeatures.addAll(featureExtractor1.extract(jCas, (Annotation)mention));
                }
                for (CollectionTextRelationIdentifiedAnnotationPair collectionTextRelationIdentifiedAnnotationPair : this.getCandidateRelationArgumentPairs(jCas, mention)) {
                    CollectionTextRelation cluster = collectionTextRelationIdentifiedAnnotationPair.getCluster();
                    ArrayList<Feature> features = new ArrayList<Feature>();
                    features.addAll(mentionFeatures);
                    for (RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation> relationFeaturesExtractor : this.relationExtractors) {
                        List feats = relationFeaturesExtractor.extract(jCas, (Object)cluster, (Object)mention);
                        if (feats == null) continue;
                        features.addAll(feats);
                    }
                    ArrayList<Feature> dupFeatures = new ArrayList<Feature>();
                    for (Feature feature : features) {
                        if (feature.getValue() == null) {
                            feature.setValue((Object)"NULL");
                            String message = String.format("Null value found in %s from %s", feature, features);
                            System.err.println(message);
                            continue;
                        }
                        String prefix = null;
                        if (prefix == null) continue;
                        dupFeatures.add(new Feature(prefix + "_" + feature.getName(), feature.getValue()));
                    }
                    features.addAll(dupFeatures);
                    if (this.isTraining()) {
                        String string = this.getRelationCategory(relationLookup, cluster, mention);
                        if (string == null) continue;
                        double outVal = 1.0;
                        if (string.equals(NO_RELATION_CATEGORY)) {
                            outVal = 0.0;
                        }
                        QidInstance inst = new QidInstance();
                        inst.setQid(String.valueOf(this.qid));
                        inst.addAll(features);
                        inst.setOutcome((Object)outVal);
                        this.dataWriter.write((Instance)inst);
                        if (string.equals(NO_RELATION_CATEGORY)) continue;
                        singleton = false;
                        break;
                    }
                    Double d = this.classify(features);
                    if (!(d > maxScore)) continue;
                    maxScore = d;
                    maxCluster = cluster;
                }
                this.markableStrings.add(mention.getCoveredText().toLowerCase());
                if (headNode != null) {
                    String head = headNode.getCoveredText().toLowerCase();
                    if (!this.headWordMarkables.containsKey(head)) {
                        this.headWordMarkables.put(head, new HashSet());
                    }
                    this.headWordMarkables.get(head).add((Markable)mention);
                }
                if (this.isTraining()) {
                    QidInstance inst = new QidInstance();
                    inst.setQid(String.valueOf(this.qid));
                    for (Feature feat : mentionFeatures) {
                        if (feat.getName() == null) continue;
                        feat.setName("DUMMYLINK_" + feat.getName());
                    }
                    inst.addAll(mentionFeatures);
                    if (singleton) {
                        inst.setOutcome((Object)1.0);
                    } else {
                        inst.setOutcome((Object)0.0);
                    }
                    this.dataWriter.write((Instance)inst);
                } else {
                    Double nullPrediction = this.classify(mentionFeatures);
                    if (nullPrediction > maxScore) {
                        CollectionTextRelation collectionTextRelation = new CollectionTextRelation(jCas);
                        NonEmptyFSList list = new NonEmptyFSList(jCas);
                        list.setHead((TOP)mention);
                        list.setTail((FSList)new EmptyFSList(jCas));
                        collectionTextRelation.setMembers((FSList)list);
                        collectionTextRelation.addToIndexes();
                        list.addToIndexes();
                        list.getTail().addToIndexes();
                    } else {
                        this.createRelation(jCas, maxCluster, mention, CLUSTER_RELATION_CATEGORY);
                    }
                }
                ++this.qid;
            }
        }
        this.removeSingletonClusters(jCas);
    }

    protected String getRelationCategory(Map<CollectionTextRelationIdentifiedAnnotationPair, CollectionTextRelationIdentifiedAnnotationRelation> relationLookup, CollectionTextRelation cluster, IdentifiedAnnotation mention) {
        CollectionTextRelationIdentifiedAnnotationRelation relation = relationLookup.get(new CollectionTextRelationIdentifiedAnnotationPair(cluster, mention));
        String category = relation != null ? relation.getCategory() : (this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample ? NO_RELATION_CATEGORY : null);
        return category;
    }

    protected Double classify(List<Feature> features) throws CleartkProcessingException {
        return (Double)this.classifier.classify(features);
    }

    protected void createRelation(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention, String predictedCategory) {
        CollectionTextRelationIdentifiedAnnotationRelation relation = new CollectionTextRelationIdentifiedAnnotationRelation(jCas);
        relation.setCluster(cluster);
        relation.setMention(mention);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
        ListFactory.append((JCas)jCas, (FSList)cluster.getMembers(), (TOP)mention);
    }

    private void removeSingletonClusters(JCas jcas) {
        ArrayList<CollectionTextRelation> toRemove = new ArrayList<CollectionTextRelation>();
        for (CollectionTextRelation rel : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
            NonEmptyFSList head = (NonEmptyFSList)rel.getMembers();
            if (!(head.getTail() instanceof EmptyFSList)) continue;
            toRemove.add(rel);
        }
        for (CollectionTextRelation rel : toRemove) {
            rel.removeFromIndexes();
        }
    }

    private static final boolean dominates(Annotation arg1, Annotation arg2) {
        return arg1.getBegin() <= arg2.getBegin() && arg1.getEnd() >= arg2.getEnd();
    }

    public Set<String> getBestEnt(JCas jcas, CollectionTextRelation cluster) {
        HashSet<String> semTypes = new HashSet<String>();
        for (Markable member : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
            semTypes.addAll(this.getBestEnt(jcas, member));
        }
        return semTypes;
    }

    public Set<String> getBestEnt(JCas jcas, Markable markable) {
        HashSet<String> bestEnts = new HashSet<String>();
        Object bestEnt = null;
        HashSet<IdentifiedAnnotation> otherBestEnts = new HashSet<IdentifiedAnnotation>();
        ConllDependencyNode head = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)markable);
        Collection<IdentifiedAnnotation> coveringEnts = this.nodeEntMap.get(head);
        for (IdentifiedAnnotation ent : coveringEnts) {
            ConllDependencyNode entHead;
            if (ent.getOntologyConceptArr() == null || (entHead = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)ent)) != head) continue;
            if (bestEnt == null) {
                bestEnt = ent;
                continue;
            }
            if (ent.getEnd() - ent.getBegin() > bestEnt.getEnd() - bestEnt.getBegin()) {
                bestEnt = ent;
                otherBestEnts = new HashSet();
                continue;
            }
            if (ent.getEnd() - ent.getBegin() != bestEnt.getEnd() - bestEnt.getBegin()) continue;
            otherBestEnts.add(ent);
        }
        if (bestEnt != null) {
            bestEnts.add(bestEnt.getClass().getSimpleName());
            for (IdentifiedAnnotation other : otherBestEnts) {
                bestEnts.add(other.getClass().getSimpleName());
            }
        }
        return bestEnts;
    }

    public Map<RelationExtractorEvaluation.HashableArguments, Double> getMarkablePairScores(JCas jCas) {
        HashMap<RelationExtractorEvaluation.HashableArguments, Double> scoreMap = new HashMap<RelationExtractorEvaluation.HashableArguments, Double>();
        for (CoreferenceRelation reln : JCasUtil.select((JCas)jCas, CoreferenceRelation.class)) {
            RelationExtractorEvaluation.HashableArguments pair = new RelationExtractorEvaluation.HashableArguments((Annotation)((IdentifiedAnnotation)reln.getArg1().getArgument()), (Annotation)((IdentifiedAnnotation)reln.getArg2().getArgument()));
            scoreMap.put(pair, reln.getConfidence());
        }
        return scoreMap;
    }

    public static class CollectionTextRelationIdentifiedAnnotationPair {
        private final CollectionTextRelation cluster;
        private final IdentifiedAnnotation mention;

        public CollectionTextRelationIdentifiedAnnotationPair(CollectionTextRelation cluster, IdentifiedAnnotation mention) {
            this.cluster = cluster;
            this.mention = mention;
        }

        public final CollectionTextRelation getCluster() {
            return this.cluster;
        }

        public final IdentifiedAnnotation getMention() {
            return this.mention;
        }

        public boolean equals(Object obj) {
            CollectionTextRelationIdentifiedAnnotationPair other = (CollectionTextRelationIdentifiedAnnotationPair)obj;
            return this.cluster == other.cluster && this.mention == other.mention;
        }

        public int hashCode() {
            return 31 * this.cluster.hashCode() + (this.mention == null ? 0 : this.mention.hashCode());
        }
    }
}

