/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.coreference.ae.features.salience.ClinicalFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.salience.GrammaticalRoleFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.salience.MorphosyntacticFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.salience.SemanticEnvironmentFeatureExtractor;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

@PipeBitInfo(name="Markable Salience Annotator", description="Annotates Markable Salience.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.PARAGRAPH, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.DEPENDENCY_NODE}, usables={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class MarkableSalienceAnnotator
extends CleartkAnnotator<Boolean> {
    List<FeatureExtractor1<Markable>> extractors = new ArrayList<FeatureExtractor1<Markable>>();

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<Boolean>> dataWriterClass, File outputDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MarkableSalienceAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MarkableSalienceAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.extractors.add(new MorphosyntacticFeatureExtractor());
        this.extractors.add(new GrammaticalRoleFeatureExtractor());
        this.extractors.add(new SemanticEnvironmentFeatureExtractor());
        this.extractors.add(new ClinicalFeatureExtractor());
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        for (Markable markable : JCasUtil.select((JCas)jcas, Markable.class)) {
            ArrayList features = new ArrayList();
            for (FeatureExtractor1<Markable> extractor : this.extractors) {
                features.addAll(extractor.extract(jcas, (Annotation)markable));
            }
            Instance instance = new Instance(features);
            if (this.isTraining()) {
                boolean outcome = (double)markable.getConfidence() > 0.5;
                instance.setOutcome((Object)outcome);
                this.dataWriter.write(instance);
                continue;
            }
            Map outcomes = this.classifier.score(features);
            markable.setConfidence(((Double)outcomes.get(true)).floatValue());
        }
    }
}

