/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.cleartk.corpus.timeml.TempEval2010CollectionReader;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.timeml.eval.ModelInfo;
import org.cleartk.timeml.eval.TempEval2010Evaluation;
import org.cleartk.timeml.eval.TempEval2010TaskAAttributes;
import org.cleartk.timeml.eval.TempEval2010TaskAExtents;
import org.cleartk.timeml.eval.TempEval2010TaskBAttributes;
import org.cleartk.timeml.eval.TempEval2010TaskBExtents;
import org.cleartk.timeml.eval.TempEval2010TaskC;
import org.cleartk.timeml.eval.TempEval2010TaskD;
import org.cleartk.timeml.eval.TempEval2010TaskE;
import org.cleartk.timeml.eval.TempEval2010TaskF;

public abstract class TempEval2010Main {
    public static void main(String[] args) throws Exception {
        for (TempEval2010Main main : Arrays.asList(new TempEval2010TaskAAttributes(), new TempEval2010TaskAExtents(), new TempEval2010TaskBAttributes(), new TempEval2010TaskBExtents(), new TempEval2010TaskC(), new TempEval2010TaskD(), new TempEval2010TaskE(), new TempEval2010TaskF())) {
            main.runMain(args);
        }
    }

    public void runMain(String[] args) throws Exception {
        String className = this.getClass().getName();
        if (args.length != 4) {
            System.err.printf("usage: java %s {cv,test,train} tempeval-training-dir tempeval-test-dir output-dir", className);
            System.exit(1);
        }
        Command command = Command.valueOf(args[0].toUpperCase());
        char[] lineChars = new char[className.length()];
        Arrays.fill(lineChars, '=');
        String line = new String(lineChars);
        String message = String.format("\n%s\n%s\n%s", line, className, line);
        UIMAFramework.getLogger(this.getClass()).log(Level.INFO, message);
        File tempEvalTrainingDir = new File(args[1]);
        File tempEvalTestDir = new File(args[2]);
        File outputDirectory = new File(args[3]);
        TempEval2010Evaluation evaluation = this.getEvaluation(tempEvalTrainingDir, tempEvalTestDir, outputDirectory);
        switch (command) {
            case CV: {
                List foldResults = evaluation.crossValidation(TempEval2010CollectionReader.getAnnotatedFileNames((File)tempEvalTrainingDir), 5);
                HashMap<String, AnnotationStatistics> overallResults = new HashMap<String, AnnotationStatistics>();
                for (Map results : foldResults) {
                    for (ModelInfo modelInfo : results.keySet()) {
                        String key = modelInfo.annotatedFeatureName;
                        if (!overallResults.containsKey(key)) {
                            overallResults.put(key, new AnnotationStatistics());
                        }
                        ((AnnotationStatistics)overallResults.get(key)).addAll((AnnotationStatistics)results.get(modelInfo));
                    }
                }
                for (String key : overallResults.keySet()) {
                    System.err.println(key);
                    System.err.println(overallResults.get(key));
                }
                break;
            }
            case TEST: {
                Map results = (Map)evaluation.trainAndTest(TempEval2010CollectionReader.getAnnotatedFileNames((File)tempEvalTrainingDir), TempEval2010CollectionReader.getAnnotatedFileNames((File)tempEvalTestDir));
                for (ModelInfo modelInfo : results.keySet()) {
                    System.err.println(modelInfo.annotatedFeatureName);
                    System.err.println(results.get(modelInfo));
                    System.err.println(((AnnotationStatistics)results.get(modelInfo)).confusions());
                }
                break;
            }
            case TRAIN: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected abstract TempEval2010Evaluation getEvaluation(File var1, File var2, File var3) throws Exception;

    static enum Command {
        CV,
        TEST,
        TRAIN;

    }
}

