/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.phrasebuilder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.dictionary.lookup.phrasebuilder.PhraseBuilder;
import org.apache.ctakes.dictionary.lookup.vo.LookupAnnotation;
import org.apache.ctakes.dictionary.lookup.vo.LookupToken;

public class VariantPhraseBuilderImpl
implements PhraseBuilder {
    private final List<TextExtractor> iv_textExtractorList = new ArrayList<TextExtractor>();

    public VariantPhraseBuilderImpl(String[] variantAttrNames, boolean useOriginalText) {
        if (useOriginalText) {
            this.iv_textExtractorList.add(new OriginalTextImpl());
        }
        for (String name : variantAttrNames) {
            this.iv_textExtractorList.add(new AttributeTextImpl(name));
        }
    }

    @Override
    public String[] getPhrases(List<LookupToken> lookupTokenList) {
        HashSet<String> phraseSet = new HashSet<String>();
        for (TextExtractor extractor : this.iv_textExtractorList) {
            StringBuilder sb = new StringBuilder();
            LookupAnnotation previousLt = null;
            for (LookupToken lt : lookupTokenList) {
                String variant = extractor.getText(lt);
                if (variant == null) {
                    variant = lt.getText();
                }
                if (previousLt != null && previousLt.getEndOffset() != lt.getStartOffset()) {
                    sb.append(' ');
                }
                sb.append(variant);
                previousLt = lt;
            }
            String phrase = sb.toString().trim();
            phraseSet.add(phrase);
        }
        return phraseSet.toArray(new String[phraseSet.size()]);
    }

    class AttributeTextImpl
    implements TextExtractor {
        private String iv_varAttrName;

        public AttributeTextImpl(String varAttrName) {
            this.iv_varAttrName = varAttrName;
        }

        @Override
        public String getText(LookupToken lt) {
            return lt.getStringAttribute(this.iv_varAttrName);
        }
    }

    class OriginalTextImpl
    implements TextExtractor {
        OriginalTextImpl() {
        }

        @Override
        public String getText(LookupToken lt) {
            return lt.getText();
        }
    }

    private static interface TextExtractor {
        public String getText(LookupToken var1);
    }
}

